/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.server.servlet;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.core.Jvm;
import com.hexagonkt.core.logging.Logger;
import com.hexagonkt.http.server.HttpServer;
import com.hexagonkt.http.server.HttpServerFeature;
import com.hexagonkt.http.server.HttpServerSettings;
import com.hexagonkt.http.server.handlers.HandlersKt;
import com.hexagonkt.http.server.handlers.PathHandler;
import com.hexagonkt.http.server.handlers.ServerHandler;
import com.hexagonkt.http.server.servlet.ServletFilter;
import com.hexagonkt.http.server.servlet.ServletServer;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hexagonkt/http/server/servlet/ServletServer;", "Ljakarta/servlet/ServletContextListener;", "handler", "Lcom/hexagonkt/http/server/handlers/ServerHandler;", "settings", "Lcom/hexagonkt/http/server/HttpServerSettings;", "(Lcom/hexagonkt/http/server/handlers/ServerHandler;Lcom/hexagonkt/http/server/HttpServerSettings;)V", "handlers", "", "(Ljava/util/List;Lcom/hexagonkt/http/server/HttpServerSettings;)V", "logger", "Lcom/hexagonkt/core/logging/Logger;", "pathHandler", "Lcom/hexagonkt/http/server/handlers/PathHandler;", "contextDestroyed", "", "sce", "Ljakarta/servlet/ServletContextEvent;", "contextInitialized", "createBanner", "", "startUpTimestamp", "", "http_server_servlet"})
public abstract class ServletServer
implements ServletContextListener {
    @NotNull
    private final HttpServerSettings settings;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PathHandler pathHandler;

    public ServletServer(@NotNull List<? extends ServerHandler> handlers, @NotNull HttpServerSettings settings) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.logger = new Logger(Reflection.getOrCreateKotlinClass(ServletServer.class));
        this.pathHandler = HandlersKt.path((String)this.settings.getContextPath(), handlers);
    }

    public /* synthetic */ ServletServer(List list, HttpServerSettings httpServerSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            httpServerSettings = new HttpServerSettings(null, 0, null, null, null, null, null, 127, null);
        }
        this(list, httpServerSettings);
    }

    public ServletServer(@NotNull ServerHandler handler, @NotNull HttpServerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(CollectionsKt.listOf((Object)handler), settings);
    }

    public /* synthetic */ ServletServer(ServerHandler serverHandler, HttpServerSettings httpServerSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpServerSettings = new HttpServerSettings(null, 0, null, null, null, null, null, 127, null);
        }
        this(serverHandler, httpServerSettings);
    }

    public void contextInitialized(@NotNull ServletContextEvent sce) {
        Intrinsics.checkNotNullParameter((Object)sce, (String)"sce");
        long startTimestamp = System.nanoTime();
        ServletFilter servletFilter = new ServletFilter(this.pathHandler, this.settings);
        servletFilter.init(new FilterConfig(sce){
            @NotNull
            private final Hashtable<String, String> params;
            final /* synthetic */ ServletContextEvent $sce;
            {
                void $this$params_u24lambda_u2d0;
                Hashtable<K, V> hashtable;
                this.$sce = $sce;
                Hashtable<K, V> hashtable2 = hashtable = new Hashtable<K, V>(1);
                contextInitialized.1 var5_4 = this;
                boolean bl = false;
                $this$params_u24lambda_u2d0.put("filterName", this.getFilterName());
                var5_4.params = hashtable;
            }

            @NotNull
            public final Hashtable<String, String> getParams() {
                return this.params;
            }

            @NotNull
            public String getFilterName() {
                String string = ServletFilter.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ServletFilter::class.java.name");
                return string;
            }

            @NotNull
            public ServletContext getServletContext() {
                ServletContext servletContext = this.$sce.getServletContext();
                Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"sce.servletContext");
                return servletContext;
            }

            @NotNull
            public String getInitParameter(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Object object = HelpersKt.require((Map)this.params, (Object)name2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"params.require(name)");
                return (String)object;
            }

            @NotNull
            public Enumeration<String> getInitParameterNames() {
                Enumeration<String> enumeration = this.params.keys();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"params.keys()");
                return enumeration;
            }
        });
        FilterRegistration.Dynamic filter = sce.getServletContext().addFilter("filters", (Filter)servletFilter);
        filter.setAsyncSupported(this.settings.getFeatures().contains(HttpServerFeature.ASYNC));
        String[] stringArray = new String[]{"/*"};
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, stringArray);
        this.logger.info((Function0)new Function0<Object>(this, startTimestamp){
            final /* synthetic */ ServletServer this$0;
            final /* synthetic */ long $startTimestamp;
            {
                this.this$0 = $receiver;
                this.$startTimestamp = $startTimestamp;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Server started\n" + ServletServer.access$createBanner(this.this$0, System.nanoTime() - this.$startTimestamp);
            }
        });
    }

    public void contextDestroyed(@Nullable ServletContextEvent sce) {
        this.logger.info((Function0)contextDestroyed.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final String createBanner(long startUpTimestamp) {
        String string;
        StringBuilder stringBuilder;
        String information;
        block3: {
            block2: {
                void it;
                MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                String string2 = "%,d";
                Object object = new Object[]{heap.getInit() / (long)1024};
                String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                String jvmMemory = string3;
                object = "%,d";
                Object object2 = new Object[]{heap.getUsed() / (long)1024};
                String string4 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
                String usedMemory = string4;
                object2 = "%01.3f";
                Object object3 = new Object[]{(double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0};
                String string5 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
                String bootTime = string5;
                object3 = "%,.0f";
                Object[] objectArray = new Object[]{(double)startUpTimestamp / 1000000.0};
                String string6 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
                String startUpTime = string6;
                String serverAdapterValue = "\u001b[1m\u001b[36m" + this.getClass().getSimpleName() + "\u001b[0m";
                String features2 = CollectionsKt.joinToString$default((Iterable)this.settings.getFeatures(), (CharSequence)"\u001b[0m, \u001b[36m", (CharSequence)"\u001b[36m", (CharSequence)"\u001b[0m", (int)0, null, (Function1)createBanner.features.1.INSTANCE, (int)24, null);
                String hostnameValue = "\u001b[34m" + Jvm.INSTANCE.getHostname() + "\u001b[0m";
                String cpuCountValue = "\u001b[34m" + Jvm.INSTANCE.getCpuCount() + "\u001b[0m";
                String jvmMemoryValue = "\u001b[34m" + jvmMemory + "\u001b[0m";
                String javaVersionValue = "\u001b[1m\u001b[34mJava " + Jvm.INSTANCE.getVersion() + "\u001b[0m [\u001b[34m" + Jvm.INSTANCE.getName() + "\u001b[0m]";
                String localeValue = "\u001b[34m" + Jvm.INSTANCE.getLocaleCode() + "\u001b[0m";
                String timezoneValue = "\u001b[34m" + Jvm.INSTANCE.getTimezone() + "\u001b[0m";
                String charsetValue = "\u001b[34m" + Jvm.INSTANCE.getCharset() + "\u001b[0m";
                String bootTimeValue = "\u001b[1m\u001b[35m" + bootTime + " s\u001b[0m";
                String startUpTimeValue = "\u001b[1m\u001b[35m" + startUpTime + " ms\u001b[0m";
                String usedMemoryValue = "\u001b[1m\u001b[35m" + usedMemory + " KB\u001b[0m";
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("\n\n            Server Adapter: ").append(serverAdapterValue).append("\n            Enabled Features: ").append(features2).append("\n\n            \ud83d\udda5\ufe0f\ufe0f Running in '").append(hostnameValue).append("' with ").append(cpuCountValue).append(" CPUs ").append(jvmMemoryValue).append(" KB\n            \ud83d\udee0 Using ").append(javaVersionValue).append("\n            \ud83c\udf0d Locale: ").append(localeValue).append(" Timezone: ").append(timezoneValue).append(" Charset: ").append(charsetValue).append("\n\n            \u23f1 Started in ").append(bootTimeValue).append(" (server: ").append(startUpTimeValue).append(") using ");
                stringBuilder2.append(usedMemoryValue).append("\n            \ud83d\ude80 Served at a JEE Server\n\n        ");
                information = StringsKt.trimIndent((String)stringBuilder2.toString());
                stringBuilder = new StringBuilder();
                string = this.settings.getBanner();
                if (string == null) break block2;
                String string7 = string;
                StringBuilder stringBuilder3 = stringBuilder;
                boolean bl = false;
                String string8 = (String)it + '\n';
                stringBuilder = stringBuilder3;
                string = string8;
                if (string8 != null) break block3;
            }
            string = HttpServer.Companion.getBanner();
        }
        String banner = stringBuilder.append(string).append(information).toString();
        return com.hexagonkt.core.StringsKt.prependIndent$default((String)banner, (int)0, null, (int)3, null);
    }

    public ServletServer() {
        this((List)null, (HttpServerSettings)null, 3, (DefaultConstructorMarker)null);
    }

    public static final /* synthetic */ String access$createBanner(ServletServer $this, long startUpTimestamp) {
        return $this.createBanner(startUpTimestamp);
    }
}

