/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.logging.jul;

import com.hexagonkt.core.StringsKt;
import com.hexagonkt.core.logging.LoggerPort;
import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingManager;
import com.hexagonkt.core.logging.LoggingPort;
import com.hexagonkt.logging.jul.PatternFormat;
import com.hexagonkt.logging.jul.SystemStreamHandler;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/hexagonkt/logging/jul/JulLoggingAdapter;", "Lcom/hexagonkt/core/logging/LoggingPort;", "messageOnly", "", "stream", "Ljava/io/PrintStream;", "(ZLjava/io/PrintStream;)V", "createLogger", "Lcom/hexagonkt/core/logging/LoggerPort;", "name", "", "isLoggerLevelEnabled", "level", "Lcom/hexagonkt/core/logging/LoggingLevel;", "mapLevel", "Ljava/util/logging/Level;", "mapLevel$logging_jul", "setLoggerLevel", "", "logging_jul"})
public final class JulLoggingAdapter
implements LoggingPort {
    public JulLoggingAdapter(boolean messageOnly, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Logger root = Logger.getLogger("");
        Handler[] handlerArray = root.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"root.handlers");
        for (Handler hnd : handlerArray) {
            root.removeHandler(hnd);
        }
        PatternFormat handlerFormatter = new PatternFormat(LoggingManager.INSTANCE.getUseColor(), messageOnly);
        SystemStreamHandler systemStreamHandler = new SystemStreamHandler(handlerFormatter, stream);
        root.addHandler(systemStreamHandler);
        root.setLevel(Level.INFO);
    }

    public /* synthetic */ JulLoggingAdapter(boolean bl, PrintStream printStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"out");
            printStream = printStream2;
        }
        this(bl, printStream);
    }

    public void setLoggerLevel(@NotNull String name, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger.getLogger(name).setLevel(this.mapLevel$logging_jul(level));
    }

    @NotNull
    public LoggerPort createLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LoggerPort(name, this){
            @NotNull
            private final Logger log;
            final /* synthetic */ JulLoggingAdapter this$0;
            {
                this.this$0 = $receiver;
                Logger logger = Logger.getLogger($name);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name)");
                this.log = logger;
            }

            @NotNull
            public final Logger getLog() {
                return this.log;
            }

            public void log(@NotNull LoggingLevel level, @NotNull Function0<? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                Level julLevel = this.this$0.mapLevel$logging_jul(level);
                if (this.log.isLoggable(julLevel)) {
                    this.log.log(julLevel, this.color(String.valueOf(message.invoke())));
                }
            }

            public <E extends Throwable> void log(@NotNull LoggingLevel level, @NotNull E exception, @NotNull Function1<? super E, ? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(exception, (String)"exception");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                Level julLevel = this.this$0.mapLevel$logging_jul(level);
                if (this.log.isLoggable(julLevel)) {
                    this.log.log(julLevel, this.color(String.valueOf(message.invoke(exception))), exception);
                }
            }

            private final String color(String message) {
                return LoggingManager.INSTANCE.getUseColor() ? message : StringsKt.stripAnsi((String)message);
            }
        };
    }

    public boolean isLoggerLevelEnabled(@NotNull String name, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return Logger.getLogger(name).isLoggable(this.mapLevel$logging_jul(level));
    }

    @NotNull
    public final Level mapLevel$logging_jul(@NotNull LoggingLevel level) {
        Level level2;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Level level3 = Level.FINER;
                level2 = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"FINER");
                break;
            }
            case 2: {
                Level level4 = Level.FINE;
                level2 = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"FINE");
                break;
            }
            case 3: {
                Level level5 = Level.INFO;
                level2 = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"INFO");
                break;
            }
            case 4: {
                Level level6 = Level.WARNING;
                level2 = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"WARNING");
                break;
            }
            case 5: {
                Level level7 = Level.SEVERE;
                level2 = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"SEVERE");
                break;
            }
            case 6: {
                Level level8 = Level.OFF;
                level2 = level8;
                Intrinsics.checkNotNullExpressionValue((Object)level8, (String)"OFF");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level2;
    }

    public JulLoggingAdapter() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingLevel.values().length];
            try {
                nArray[LoggingLevel.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.OFF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

