/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.logging.jul;

import com.hexagonkt.core.ExceptionsKt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/hexagonkt/logging/jul/PatternFormat;", "Ljava/util/logging/Formatter;", "useColor", "", "messageOnly", "(ZZ)V", "levelColors", "", "Ljava/util/logging/Level;", "", "levelNames", "pattern", "format", "record", "Ljava/util/logging/LogRecord;", "Companion", "logging_jul"})
public final class PatternFormat
extends Formatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean useColor;
    private final boolean messageOnly;
    @NotNull
    private final String pattern;
    @NotNull
    private final Map<Level, String> levelColors;
    @NotNull
    private final Map<Level, String> levelNames;
    @NotNull
    public static final String TIMESTAMP = "%tH:%<tM:%<tS,%<tL";
    @NotNull
    public static final String LEVEL = "%-5s";
    @NotNull
    public static final String THREAD = "[%-15s]";
    @NotNull
    public static final String LOGGER = "%-30s";
    @NotNull
    public static final String PATTERN = "%tH:%<tM:%<tS,%<tL %-5s [%-15s] %-30s | %s%n";
    @NotNull
    public static final String COLOR_PATTERN = "\u001b[90m%tH:%<tM:%<tS,%<tL %s%-5s\u001b[0m \u001b[35m[%-15s] \u001b[36m%-30s\u001b[0m | %s%n";

    public PatternFormat(boolean useColor, boolean messageOnly) {
        this.useColor = useColor;
        this.messageOnly = messageOnly;
        this.pattern = this.useColor ? COLOR_PATTERN : PATTERN;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Level.FINER, (Object)"\u001b[39m"), TuplesKt.to((Object)Level.FINE, (Object)"\u001b[39m"), TuplesKt.to((Object)Level.INFO, (Object)"\u001b[34m"), TuplesKt.to((Object)Level.WARNING, (Object)"\u001b[33m"), TuplesKt.to((Object)Level.SEVERE, (Object)"\u001b[31m\u001b[1m")};
        this.levelColors = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)Level.FINER, (Object)"TRACE"), TuplesKt.to((Object)Level.FINE, (Object)"DEBUG"), TuplesKt.to((Object)Level.INFO, (Object)"INFO"), TuplesKt.to((Object)Level.WARNING, (Object)"WARN"), TuplesKt.to((Object)Level.SEVERE, (Object)"ERROR")};
        this.levelNames = MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ PatternFormat(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (this.messageOnly) {
            return record.getMessage() + "\n";
        }
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        Throwable thrown = record.getThrown();
        String trace = thrown == null ? "" : (this.useColor ? StringsKt.replace$default((String)(com.hexagonkt.core.StringsKt.getEol() + ExceptionsKt.toText$default((Throwable)thrown, null, (int)1, null)), (String)"\n", (String)"\n\u001b[31m", (boolean)false, (int)4, null) : com.hexagonkt.core.StringsKt.getEol() + ExceptionsKt.toText$default((Throwable)thrown, null, (int)1, null));
        Level level = record.getLevel();
        String string2 = this.levelNames.get(level);
        if (string2 == null) {
            ExceptionsKt.getFail();
            throw new KotlinNothingValueException();
        }
        String levelName = string2;
        String string3 = this.levelColors.get(level);
        if (string3 == null) {
            string3 = "\u001b[34m";
        }
        String levelColor = string3;
        String message = record.getMessage();
        String loggerName = record.getLoggerName();
        String threadName = Thread.currentThread().getName();
        if (this.useColor) {
            String string4 = this.pattern;
            Object[] objectArray = new Object[]{dateTime, levelColor, levelName, threadName, loggerName, message + trace};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
        } else {
            String string6 = this.pattern;
            Object[] objectArray = new Object[]{dateTime, levelName, threadName, loggerName, message + trace};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(this, *args)");
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hexagonkt/logging/jul/PatternFormat$Companion;", "", "()V", "COLOR_PATTERN", "", "LEVEL", "LOGGER", "PATTERN", "THREAD", "TIMESTAMP", "logging_jul"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

