/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph;

import com.imsweb.mph.HematoDbUtilsProvider;
import com.imsweb.mph.internal.HematoDbDTO;
import com.opencsv.CSVReaderBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class DefaultHematoDbUtilsProvider
implements HematoDbUtilsProvider {
    private Map<String, List<HematoDbDTO>> _samePrimaryDto = new HashMap<String, List<HematoDbDTO>>();
    private Map<String, List<HematoDbDTO>> _transformToDto;
    private Map<String, List<HematoDbDTO>> _transformFromDto;
    private static Pattern _MORPHOLOGY = Pattern.compile("^(\\d{4}/\\d)");

    public DefaultHematoDbUtilsProvider() {
        ArrayList<HematoDbDTO> list;
        InputStream is;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010SamePrimaryPairs.csv");
            try {
                for (String[] row : new CSVReaderBuilder((Reader)new InputStreamReader(is, "US-ASCII")).withSkipLines(1).build().readAll()) {
                    if (this._samePrimaryDto.containsKey(row[0])) {
                        this._samePrimaryDto.get(row[0]).add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                        continue;
                    }
                    list = new ArrayList<HematoDbDTO>();
                    list.add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                    this._samePrimaryDto.put(row[0], list);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._transformToDto = new HashMap<String, List<HematoDbDTO>>();
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010TransformToPairs.csv");
            try {
                for (String[] row : new CSVReaderBuilder((Reader)new InputStreamReader(is, "US-ASCII")).withSkipLines(1).build().readAll()) {
                    if (this._transformToDto.containsKey(row[0])) {
                        this._transformToDto.get(row[0]).add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                        continue;
                    }
                    list = new ArrayList();
                    list.add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                    this._transformToDto.put(row[0], list);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._transformFromDto = new HashMap<String, List<HematoDbDTO>>();
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010TransformFromPairs.csv");
            try {
                for (String[] row : new CSVReaderBuilder((Reader)new InputStreamReader(is, "US-ASCII")).withSkipLines(1).build().readAll()) {
                    if (this._transformFromDto.containsKey(row[0])) {
                        this._transformFromDto.get(row[0]).add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                        continue;
                    }
                    list = new ArrayList();
                    list.add(new HematoDbDTO(Short.valueOf(row[1]), Short.valueOf(row[2]), row[3]));
                    this._transformFromDto.put(row[0], list);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSamePrimary(String leftCode, String rightCode, int leftYear, int rightYear) {
        if (leftCode == null || rightCode == null || !_MORPHOLOGY.matcher(leftCode).matches() || !_MORPHOLOGY.matcher(rightCode).matches()) {
            return false;
        }
        if (leftCode.equals(rightCode)) {
            return true;
        }
        if (this._samePrimaryDto.containsKey(leftCode)) {
            for (HematoDbDTO dto : this._samePrimaryDto.get(leftCode)) {
                if (!dto.matches(rightCode, leftYear)) continue;
                return true;
            }
        }
        if (this._samePrimaryDto.containsKey(rightCode)) {
            for (HematoDbDTO dto : this._samePrimaryDto.get(rightCode)) {
                if (!dto.matches(leftCode, rightYear)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canTransformTo(String fromCode, String toCode, int fromYear, int toYear) {
        return this.confirmTransformTo(fromCode, toCode, fromYear) || this.confirmTransformFrom(toCode, fromCode, toYear);
    }

    private boolean confirmTransformTo(String leftCode, String rightCode, int year) {
        if (leftCode == null || rightCode == null || !_MORPHOLOGY.matcher(leftCode).matches() || !_MORPHOLOGY.matcher(rightCode).matches()) {
            return false;
        }
        if (this._transformToDto.containsKey(leftCode)) {
            for (HematoDbDTO dto : this._transformToDto.get(leftCode)) {
                if (!dto.matches(rightCode, year)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean confirmTransformFrom(String leftCode, String rightCode, int year) {
        if (leftCode == null || rightCode == null || !_MORPHOLOGY.matcher(leftCode).matches() || !_MORPHOLOGY.matcher(rightCode).matches()) {
            return false;
        }
        if (this._transformFromDto.containsKey(leftCode)) {
            for (HematoDbDTO dto : this._transformFromDto.get(leftCode)) {
                if (!dto.matches(rightCode, year)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Date getDataLastUpdated() {
        Date date;
        block8: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("hemato_data_info.properties");
            try {
                Properties prop = new Properties();
                prop.load(is);
                String lastUpdateDate = prop.getProperty("last_updated");
                date = new SimpleDateFormat("yyyyMMddHHmm").parse(lastUpdateDate);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    return null;
                }
            }
            is.close();
        }
        return date;
    }
}

