/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphInput;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class GroupUtility {
    public static boolean validateProperties(String primarySite, String histology, String behavior, int year) {
        return GroupUtility.validateSite(primarySite) && GroupUtility.validateHistology(histology) && GroupUtility.validateBehavior(behavior) && GroupUtility.validateYear(year);
    }

    public static boolean validateSite(String site) {
        return site != null && site.length() == 4 && site.startsWith("C") && NumberUtils.isDigits((String)site.substring(1)) && !"C809".equalsIgnoreCase(site);
    }

    public static boolean validateHistology(String hist) {
        return NumberUtils.isDigits((String)hist) && Integer.parseInt(hist) >= 8000 && Integer.parseInt(hist) <= 9999;
    }

    public static boolean validateBehavior(String behavior) {
        return Arrays.asList("0", "1", "2", "3", "6").contains(behavior);
    }

    public static boolean validateYear(int year) {
        return year >= 0 && year <= LocalDate.now().getYear();
    }

    public static boolean sameValidDates(int year1, int month1, int day1, int year2, int month2, int day2) {
        try {
            return LocalDate.of(year1, month1, day1).isEqual(LocalDate.of(year2, month2, day2));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isContained(List<Range<Integer>> list, Integer value) {
        if (list != null && !list.isEmpty()) {
            for (Range<Integer> range : list) {
                if (!range.contains((Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Range<Integer>> computeRange(String rawValue, boolean isSite) {
        if (rawValue == null) {
            return null;
        }
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        for (String item : StringUtils.split((String)rawValue, (char)',')) {
            String[] parts = StringUtils.split((String)item.trim(), (char)'-');
            if (parts.length == 1) {
                if (isSite) {
                    result.add((Range<Integer>)Range.is((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim().substring(1)))));
                    continue;
                }
                result.add((Range<Integer>)Range.is((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim()))));
                continue;
            }
            if (isSite) {
                result.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim().substring(1))), (Comparable)Integer.valueOf(Integer.parseInt(parts[1].trim().substring(1)))));
                continue;
            }
            result.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim())), (Comparable)Integer.valueOf(Integer.parseInt(parts[1].trim()))));
        }
        return result;
    }

    public static List<String> expandList(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (String item : list) {
            String[] ranges;
            for (String range : ranges = StringUtils.split((String)item.trim(), (char)',')) {
                String[] parts = StringUtils.split((String)range.trim(), (char)'-');
                if (parts.length <= 1) {
                    result.add(range);
                    continue;
                }
                Integer start = Integer.valueOf(parts[0]);
                Integer end = Integer.valueOf(parts[1]);
                while (start <= end) {
                    Integer n = start;
                    Integer n2 = start = Integer.valueOf(start + 1);
                    result.add(String.valueOf(n));
                }
            }
        }
        return result;
    }

    public static List<String> expandList(String rawValue) {
        return GroupUtility.expandList(Collections.singletonList(rawValue));
    }

    public static boolean isSiteContained(String list, String site) {
        return GroupUtility.isContained(GroupUtility.computeRange(list, true), Integer.valueOf(site.substring(1)));
    }

    public static boolean differentCategory(String prop1, String prop2, List<String> cat1, List<String> cat2) {
        return cat1 != null && cat2 != null && !cat1.isEmpty() && !cat2.isEmpty() && (cat1.contains(prop1) && cat2.contains(prop2) || cat1.contains(prop2) && cat2.contains(prop1));
    }

    public static boolean isPairedSites(String site1, String site2, List<String> pairedSites) {
        if (pairedSites != null && !pairedSites.isEmpty()) {
            for (String pairedSite : pairedSites) {
                if (!GroupUtility.isContained(GroupUtility.computeRange(pairedSite, true), Integer.parseInt(site1.substring(1))) || !GroupUtility.isContained(GroupUtility.computeRange(pairedSite, true), Integer.parseInt(site2.substring(1)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean validPairedSiteLaterality(String lat1, String lat2) {
        return !(!"1".equals(lat1) && !"2".equals(lat1) || !"1".equals(lat2) && !"2".equals(lat2));
    }

    public static boolean validateLaterality(String lat) {
        return Arrays.asList("0", "1", "2", "3", "4", "5", "9").contains(lat);
    }

    public static boolean areOppositeSides(String lat1, String lat2) {
        return "1".equals(lat1) && "2".equals(lat2) || "1".equals(lat2) && "2".equals(lat1);
    }

    public static boolean areSameSide(String lat1, String lat2) {
        return "1".equals(lat1) && "1".equals(lat2) || "2".equals(lat2) && "2".equals(lat1);
    }

    public static boolean sameAndValidMainFields(MphInput i1, MphInput i2) {
        int year1 = NumberUtils.isDigits((String)i1.getDateOfDiagnosisYear()) ? Integer.parseInt(i1.getDateOfDiagnosisYear()) : -1;
        int year2 = NumberUtils.isDigits((String)i2.getDateOfDiagnosisYear()) ? Integer.parseInt(i2.getDateOfDiagnosisYear()) : -1;
        int month1 = NumberUtils.isDigits((String)i1.getDateOfDiagnosisMonth()) ? Integer.parseInt(i1.getDateOfDiagnosisMonth()) : -1;
        int month2 = NumberUtils.isDigits((String)i2.getDateOfDiagnosisMonth()) ? Integer.parseInt(i2.getDateOfDiagnosisMonth()) : -1;
        int day1 = NumberUtils.isDigits((String)i1.getDateOfDiagnosisDay()) ? Integer.parseInt(i1.getDateOfDiagnosisDay()) : -1;
        int day2 = NumberUtils.isDigits((String)i2.getDateOfDiagnosisDay()) ? Integer.parseInt(i2.getDateOfDiagnosisDay()) : -1;
        String site1 = i1.getPrimarySite();
        String site2 = i2.getPrimarySite();
        String hist1 = i1.getHistology();
        String hist2 = i2.getHistology();
        String beh1 = i1.getBehavior();
        String beh2 = i2.getBehavior();
        String lat1 = i1.getLaterality();
        String lat2 = i2.getLaterality();
        return GroupUtility.validateProperties(site1, hist1, beh1, year1) && GroupUtility.validateProperties(site2, hist2, beh2, year2) && GroupUtility.validateLaterality(lat1) && GroupUtility.validateLaterality(lat2) && Objects.equals(site1, site2) && Objects.equals(hist1, hist2) && Objects.equals(beh1, beh2) && GroupUtility.sameValidDates(year1, month1, day1, year2, month2, day2) && Objects.equals(lat1, lat2);
    }

    public static int compareDxDate(MphInput input1, MphInput input2) {
        int day2;
        int day1;
        int month2;
        int month1;
        block16: {
            int year2;
            block15: {
                int year1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisYear()) ? Integer.parseInt(input1.getDateOfDiagnosisYear()) : 9999;
                year2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisYear()) ? Integer.parseInt(input2.getDateOfDiagnosisYear()) : 9999;
                month1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisMonth()) ? Integer.parseInt(input1.getDateOfDiagnosisMonth()) : 99;
                month2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisMonth()) ? Integer.parseInt(input2.getDateOfDiagnosisMonth()) : 99;
                day1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisDay()) ? Integer.parseInt(input1.getDateOfDiagnosisDay()) : 99;
                day2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisDay()) ? Integer.parseInt(input2.getDateOfDiagnosisDay()) : 99;
                int currYear = LocalDate.now().getYear();
                if (year1 == 9999 || year2 == 9999 || year1 > currYear || year2 > currYear) {
                    return -1;
                }
                if (year1 > year2) {
                    return 1;
                }
                if (year2 > year1) {
                    return 2;
                }
                if (month1 == 99) {
                    day1 = 99;
                }
                if (month2 == 99) {
                    day2 = 99;
                }
                try {
                    LocalDate.of(year1, month1 == 99 ? 1 : month1, day1 == 99 ? 1 : day1);
                }
                catch (Exception e) {
                    day1 = 99;
                    if (month1 >= 1 && month1 <= 12) break block15;
                    month1 = 99;
                }
            }
            try {
                LocalDate.of(year2, month2 == 99 ? 1 : month2, day2 == 99 ? 1 : day2);
            }
            catch (Exception e) {
                day2 = 99;
                if (month2 >= 1 && month2 <= 12) break block16;
                month2 = 99;
            }
        }
        if (month1 == 99 || month2 == 99) {
            return -1;
        }
        if (month1 > month2) {
            return 1;
        }
        if (month2 > month1) {
            return 2;
        }
        if (day1 == 99 || day2 == 99) {
            return -1;
        }
        if (day1 > day2) {
            return 1;
        }
        if (day2 > day1) {
            return 2;
        }
        return 0;
    }

    public static int verifyYearsApart(MphInput input1, MphInput input2, int yearsApart) {
        int day2;
        int day1;
        int month2;
        int month1;
        int year2;
        int year1;
        block14: {
            block13: {
                year1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisYear()) ? Integer.parseInt(input1.getDateOfDiagnosisYear()) : 9999;
                year2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisYear()) ? Integer.parseInt(input2.getDateOfDiagnosisYear()) : 9999;
                month1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisMonth()) ? Integer.parseInt(input1.getDateOfDiagnosisMonth()) : 99;
                month2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisMonth()) ? Integer.parseInt(input2.getDateOfDiagnosisMonth()) : 99;
                day1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisDay()) ? Integer.parseInt(input1.getDateOfDiagnosisDay()) : 99;
                day2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisDay()) ? Integer.parseInt(input2.getDateOfDiagnosisDay()) : 99;
                int currYear = LocalDate.now().getYear();
                if (year1 == 9999 || year2 == 9999 || year1 > currYear || year2 > currYear) {
                    return -1;
                }
                if (Math.abs(year1 - year2) > yearsApart) {
                    return 1;
                }
                if (Math.abs(year1 - year2) < yearsApart) {
                    return 0;
                }
                if (month1 == 99) {
                    day1 = 99;
                }
                if (month2 == 99) {
                    day2 = 99;
                }
                try {
                    LocalDate.of(year1, month1 == 99 ? 1 : month1, day1 == 99 ? 1 : day1);
                }
                catch (Exception e) {
                    day1 = 99;
                    if (month1 >= 1 && month1 <= 12) break block13;
                    month1 = 99;
                }
            }
            try {
                LocalDate.of(year2, month2 == 99 ? 1 : month2, day2 == 99 ? 1 : day2);
            }
            catch (Exception e) {
                day2 = 99;
                if (month2 >= 1 && month2 <= 12) break block14;
                month2 = 99;
            }
        }
        if (month1 == 99 || month2 == 99) {
            return -1;
        }
        if (year1 > year2 && month1 > month2 || year2 > year1 && month2 > month1) {
            return 1;
        }
        if (year1 > year2 && month1 < month2 || year2 > year1 && month2 < month1) {
            return 0;
        }
        if (day1 == 99 || day2 == 99) {
            return -1;
        }
        return Math.abs(ChronoUnit.YEARS.between(LocalDate.of(year1, month1, day1), LocalDate.of(year2, month2, day2))) >= (long)yearsApart ? 1 : 0;
    }

    public static int verifyDaysApart(MphInput input1, MphInput input2, int days) {
        int day2;
        int day1;
        int month2;
        int month1;
        int year2;
        int year1;
        int latestDx;
        block13: {
            block12: {
                latestDx = GroupUtility.compareDxDate(input1, input2);
                if (latestDx == 0) {
                    return 0;
                }
                year1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisYear()) ? Integer.parseInt(input1.getDateOfDiagnosisYear()) : 9999;
                year2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisYear()) ? Integer.parseInt(input2.getDateOfDiagnosisYear()) : 9999;
                int currYear = LocalDate.now().getYear();
                if (year1 == 9999 || year2 == 9999 || year1 > currYear || year2 > currYear) {
                    return -1;
                }
                month1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisMonth()) ? Integer.parseInt(input1.getDateOfDiagnosisMonth()) : 99;
                month2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisMonth()) ? Integer.parseInt(input2.getDateOfDiagnosisMonth()) : 99;
                day1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisDay()) ? Integer.parseInt(input1.getDateOfDiagnosisDay()) : 99;
                int n = day2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisDay()) ? Integer.parseInt(input2.getDateOfDiagnosisDay()) : 99;
                if (month1 == 99) {
                    day1 = 99;
                }
                if (month2 == 99) {
                    day2 = 99;
                }
                try {
                    LocalDate.of(year1, month1 == 99 ? 1 : month1, day1 == 99 ? 1 : day1);
                }
                catch (Exception e) {
                    day1 = 99;
                    if (month1 >= 1 && month1 <= 12) break block12;
                    month1 = 99;
                }
            }
            try {
                LocalDate.of(year2, month2 == 99 ? 1 : month2, day2 == 99 ? 1 : day2);
            }
            catch (Exception e) {
                day2 = 99;
                if (month2 >= 1 && month2 <= 12) break block13;
                month2 = 99;
            }
        }
        int minDaysInBetween = GroupUtility.daysInBetween(year2, month2, day2, year1, month1, day1, true);
        int maxDaysInBetween = GroupUtility.daysInBetween(year2, month2, day2, year1, month1, day1, false);
        if (-1 == latestDx) {
            return Math.max(Math.abs(minDaysInBetween), Math.abs(maxDaysInBetween)) <= days ? 0 : -1;
        }
        if (2 == latestDx) {
            minDaysInBetween = GroupUtility.daysInBetween(year1, month1, day1, year2, month2, day2, true);
            maxDaysInBetween = GroupUtility.daysInBetween(year1, month1, day1, year2, month2, day2, false);
        }
        if (minDaysInBetween > days) {
            return 1;
        }
        if (maxDaysInBetween <= days) {
            return 0;
        }
        return -1;
    }

    private static int daysInBetween(int startYr, int startMon, int startDay, int endYr, int endMon, int endDay, boolean minimum) {
        LocalDate startDateMin = LocalDate.of(startYr, 1, 1);
        LocalDate startDateMax = LocalDate.of(startYr, 12, 31);
        LocalDate endDateMin = LocalDate.of(endYr, 1, 1);
        LocalDate endDateMax = LocalDate.of(endYr, 12, 31);
        if (startDay != 99) {
            startDateMin = LocalDate.of(startYr, startMon, startDay);
            startDateMax = LocalDate.of(startYr, startMon, startDay);
        } else if (startMon != 99) {
            startDateMin = LocalDate.of(startYr, startMon, 1);
            startDateMax = LocalDate.of(startYr, startMon, YearMonth.of(startYr, startMon).lengthOfMonth());
        }
        if (endDay != 99) {
            endDateMin = LocalDate.of(endYr, endMon, endDay);
            endDateMax = LocalDate.of(endYr, endMon, endDay);
        } else if (endMon != 99) {
            endDateMin = LocalDate.of(endYr, endMon, 1);
            endDateMax = LocalDate.of(endYr, endMon, YearMonth.of(endYr, endMon).lengthOfMonth());
        }
        return minimum ? (int)ChronoUnit.DAYS.between(startDateMax, endDateMin) : (int)ChronoUnit.DAYS.between(startDateMin, endDateMax);
    }
}

