/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphComputeOptions;
import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleFiveYearsApart;
import com.imsweb.mph.mprules.MpRuleInsituAfterInvasive;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituLessThan60Days;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import java.util.Arrays;
import java.util.Map;

public class Mp2018HeadAndNeckGroup
extends MphGroup {
    public Mp2018HeadAndNeckGroup() {
        super("mp_2018_head_and_neck", "2018 Head And Neck", "C000-C148, C300-C339, C410, C411, C442, C479", null, null, "9590-9992, 9140", "2-3,6", "2018-9999");
        MphRule rule = new MphRule("mp_2018_head_and_neck", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
                String s2;
                TempRuleResult result = new TempRuleResult();
                String s1 = i1.getPrimarySite();
                if (GroupUtility.differentCategory(s1, s2 = i2.getPrimarySite(), MphConstants.UPPER_LIP, MphConstants.LOWER_LIP)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.UPPER_GUM, MphConstants.LOWER_GUM)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.NASAL_CAVITY, MphConstants.MIDDLE_EAR)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.HARD_PALATE, MphConstants.SOFT_PALATE) || GroupUtility.differentCategory(s1, s2, MphConstants.HARD_PALATE, MphConstants.UVULA) || GroupUtility.differentCategory(s1, s2, MphConstants.SOFT_PALATE, MphConstants.UVULA)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.MAXILLARY_SINUS, MphConstants.ETHMOID_SINUS) || GroupUtility.differentCategory(s1, s2, MphConstants.MAXILLARY_SINUS, MphConstants.FRONTAL_SINUS) || GroupUtility.differentCategory(s1, s2, MphConstants.MAXILLARY_SINUS, MphConstants.SPHENOID_SINUS) || GroupUtility.differentCategory(s1, s2, MphConstants.ETHMOID_SINUS, MphConstants.FRONTAL_SINUS) || GroupUtility.differentCategory(s1, s2, MphConstants.ETHMOID_SINUS, MphConstants.SPHENOID_SINUS) || GroupUtility.differentCategory(s1, s2, MphConstants.FRONTAL_SINUS, MphConstants.SPHENOID_SINUS)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.SUBMANDIBULAR_GLAND, MphConstants.SUBLINGUAL_GLAND)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (MphConstants.GLOTTIS_AND_LARYNGEAL_SITES.containsAll(Arrays.asList(s1, s2)) && !s1.equals(s2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.MAXILLA, MphConstants.MANDIBLE)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.differentCategory(s1, s2, MphConstants.POSTCRICOID, MphConstants.HYPOPHARYNGEAL_ASPECT_OF_ARYEPIGLOTTIC_FOLD) || GroupUtility.differentCategory(s1, s2, MphConstants.POSTCRICOID, MphConstants.POSTERIOR_WALL_OF_HYPOPHARYNX) || GroupUtility.differentCategory(s1, s2, MphConstants.HYPOPHARYNGEAL_ASPECT_OF_ARYEPIGLOTTIC_FOLD, MphConstants.POSTERIOR_WALL_OF_HYPOPHARYNX)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors on:\nGlottis C320 AND/OR supraglottis C321 AND/OR subglottis C322 AND/OR laryngeal cartilage C323, \nHard palate C050 AND/OR soft palate C051 AND/OR uvula C052, \nMaxilla C410 AND Mandible C411, \nMaxillary sinus C310 AND/OR ethmoid sinus C311 AND/OR frontal sinus C312 AND/OR sphenoid sinus C313, \nNasal cavity C300 AND middle ear C301, \nPostcricoid C130 AND/OR hypopharyngeal aspect of aryepiglottic fold C131 AND/OR posterior wall of hypopharynx C132, \nSubmandibular gland C080 AND sublingual gland C081, \nUpper gum C030 AND lower gum C031, \nUpper lip C000 or C003 AND lower lip C001 or C004?");
        rule.setReason("Tumors on:\nGlottis C320 AND/OR supraglottis C321 AND/OR subglottis C322 AND/OR laryngeal cartilage C323, \nHard palate C050 AND/OR soft palate C051 AND/OR uvula C052, \nMaxilla C410 AND Mandible C411, \nMaxillary sinus C310 AND/OR ethmoid sinus C311 AND/OR frontal sinus C312 AND/OR sphenoid sinus C313, \nNasal cavity C300 AND middle ear C301, \nPostcricoid C130 AND/OR hypopharyngeal aspect of aryepiglottic fold C131 AND/OR posterior wall of hypopharynx C132, \nSubmandibular gland C080 AND sublingual gland C081, \nUpper gum C030 AND lower gum C031, \nUpper lip C000 or C003 AND lower lip C001 or C004, are multiple primaries.");
        rule.getNotes().add("Use this rule only for multiple tumors.");
        rule.getNotes().add("Timing is irrelevant.");
        rule.getNotes().add("Histology is irrelevant.");
        rule.getNotes().add("These primary sites differ at the fourth character of the site code CxxX. Use this rule ONLY for the primary sites listed.");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("mp_2018_head_and_neck", "M4");
        rule.getNotes().add("Use this rule only for multiple tumors.");
        rule.getNotes().add("Timing is irrelevant.");
        rule.getNotes().add("Histology is irrelevant.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_head_and_neck", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
                TempRuleResult result = new TempRuleResult();
                if (GroupUtility.isPairedSites(i1.getPrimarySite(), i2.getPrimarySite(), MphConstants.HEAD_AND_NECK_2018_PAIRED_SITES)) {
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there separate, non-contiguous tumors on both the right side and the left side of a paired site?");
        rule.setReason("Separate, non-contiguous tumors on the right side and the left side of a paired site are multiple primaries.");
        rule.getNotes().add("See Table 10 for a list of paired sites.");
        rule.getNotes().add("Use this rule only for multiple tumors.");
        rule.getNotes().add("Timing is irrelevant.");
        rule.getNotes().add("Histology is irrelevant.");
        this._rules.add(rule);
        rule = new MpRuleFiveYearsApart("mp_2018_head_and_neck", "M6");
        rule.getNotes().add("Clinically disease-free means that there was no evidence of recurrence on follow-up.");
        rule.getNotes().add("  \u2022 Scopes are NED");
        rule.getNotes().add("  \u2022 Scans are NED");
        rule.getNotes().add("  \u2022 Biomarkers are NED");
        rule.getNotes().add("When there is a recurrence less than or equal to five years of diagnosis, the \u201cclock\u201d starts over. The time interval is calculated from the date of last recurrence. In other words, the patient must have been disease-free for greater than five years from the date of the last recurrence.");
        rule.getNotes().add("When it is unknown/not documented whether the patient had a recurrence, default to date of diagnosis to compute the time interval.");
        rule.getNotes().add("The physician may state this is a recurrence, meaning the patient had a previous head and neck tumor and now has another head and neck tumor. Follow the rules; do not attempt to interpret the physician\u2019s statement.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_head_and_neck", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
                TempRuleResult result = new TempRuleResult();
                Map<String, String> map1 = MphConstants.HEAD_AND_NECK_2018_SUBTYPES_FOR_SITE.get(i1.getPrimarySite());
                Map<String, String> map2 = MphConstants.HEAD_AND_NECK_2018_SUBTYPES_FOR_SITE.get(i2.getPrimarySite());
                if (map1 == null || map2 == null) {
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    result.setMessage("Two separate lesions of lip is rare; no histology tables exist for lip in Terms and Definitions.");
                } else if (!map1.equals(map2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else {
                    String subtype2;
                    String h1 = i1.getHistology();
                    String icd1 = h1 + "/" + i1.getBehavior();
                    String h2 = i2.getHistology();
                    String icd2 = h2 + "/" + i2.getBehavior();
                    String subtype1 = map1.containsKey(h1) ? map1.get(h1) : map1.get(icd1);
                    String string = subtype2 = map2.containsKey(h2) ? map2.get(h2) : map2.get(icd2);
                    if (subtype1 != null && subtype2 != null && !subtype1.equals(subtype2)) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are separate, non-contiguous tumors are two or more different subtypes/variants in Column 3 of the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions?");
        rule.setReason("Separate, non-contiguous tumors are two or more different subtypes/variants in Column 3 of the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions are multiple primaries.");
        rule.getNotes().add("The tumors may be subtypes/variants of the same or different NOS histologies.");
        rule.getNotes().add("  \u2022 Same NOS: Alveolar rhabdomyosarcoma 8920/3 and embryonal rhabdomyosarcoma 8910/3 are both subtypes of rhabdomyosarcoma 8900/3 but are distinctly different histologies. Abstract multiple primaries.");
        rule.getNotes().add("  \u2022 Different NOS: Colloid-type adenocarcinoma 8144 is a subtype of adenocarcinoma NOS 8140; Sarcomatoid carcinoma 8074 is a subtype of squamous cell carcinoma 8070. They are distinctly different histologies. Abstract multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_head_and_neck", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
                TempRuleResult result = new TempRuleResult();
                Map<String, String> map1 = MphConstants.HEAD_AND_NECK_2018_TABLE_FOR_SITE.get(i1.getPrimarySite());
                Map<String, String> map2 = MphConstants.HEAD_AND_NECK_2018_TABLE_FOR_SITE.get(i2.getPrimarySite());
                if (map1 == null || map2 == null) {
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    result.setMessage("Two separate lesions of lip is rare; no histology tables exist for lip in Terms and Definitions.");
                } else if (!map1.equals(map2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else {
                    String row2;
                    String h1 = i1.getHistology();
                    String icd1 = h1 + "/" + i1.getBehavior();
                    String h2 = i2.getHistology();
                    String icd2 = h2 + "/" + i2.getBehavior();
                    String row1 = map1.containsKey(h1) ? map1.get(h1) : map1.get(icd1);
                    String string = row2 = map2.containsKey(h2) ? map2.get(h2) : map2.get(icd2);
                    if (row1 == null || row2 == null) {
                        result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                        result.setMessageNotInTable(this.getStep(), this.getGroupId());
                    } else if (!row1.equals(row2)) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are separate, non-contiguous tumors on different rows in the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions?");
        rule.setReason("Separate, non-contiguous tumors on different rows in the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions is multiple primaries.");
        rule.getNotes().add("Each row in the table is a distinctly different histology.");
        this._rules.add(rule);
        rule = new MpRuleInsituAfterInvasive("mp_2018_head_and_neck", "M9");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("The tumors may be a NOS and a subtype/variant of that NOS. See Tables 1-9 in the Equivalent Terms and Definitions for listings of NOS and subtype/variants.");
        rule.getNotes().add("The in situ is recorded as a recurrence for those registrars who collect recurrence data.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituLessThan60Days("mp_2018_head_and_neck", "M10");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("The tumors may be an NOS and a subtype/variant of that NOS");
        rule.getNotes().add("When the case has been abstracted, change behavior code on original abstract from /2 to /3. Do not change date of diagnosis.");
        rule.getNotes().add("If the case has already been submitted to the central registry, report all changes.");
        rule.getNotes().add("The physician may stage both tumors because staging and determining multiple primaries are done for different reasons. Staging determines which treatment would be most effective. Determining multiple primaries is done to stabilize the data for the study of epidemiology (long-term studies done on incidence, mortality, and causation of a disease with the goal of reducing or eliminating that disease).");
        rule.getNotes().add("See the COC and SEER manuals for instructions on coding other data items such as Date of Diagnosis, Accession Year and Sequence Number.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("mp_2018_head_and_neck", "M11");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("Abstract both the invasive and in situ tumors.");
        rule.getNotes().add("Abstract as multiple primaries even if physician states the invasive tumor is disease recurrence or progression.");
        rule.getNotes().add("This rule is based on long-term epidemiologic studies of recurrence intervals. The specialty medical experts (SMEs) reviewed and approved these rules.  Many of the SMEs were also authors, co-authors, or editors of the AJCC Staging Manual.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_head_and_neck", "M12"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
                TempRuleResult result = new TempRuleResult();
                Map<String, String> map1 = MphConstants.HEAD_AND_NECK_2018_TABLE_FOR_SITE.get(i1.getPrimarySite());
                Map<String, String> map2 = MphConstants.HEAD_AND_NECK_2018_TABLE_FOR_SITE.get(i2.getPrimarySite());
                if (map1 == null || map2 == null) {
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    result.setMessage("Two separate lesions of lip is rare; no histology tables exist for lip in Terms and Definitions.");
                } else if (map1.equals(map2)) {
                    String row2;
                    String h1 = i1.getHistology();
                    String icd1 = h1 + "/" + i1.getBehavior();
                    String h2 = i2.getHistology();
                    String icd2 = h2 + "/" + i2.getBehavior();
                    String row1 = map1.containsKey(h1) ? map1.get(h1) : map1.get(icd1);
                    String string = row2 = map2.containsKey(h2) ? map2.get(h2) : map2.get(icd2);
                    if (row1 == null || row2 == null) {
                        result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                        result.setMessageNotInTable(this.getStep(), this.getGroupId());
                    } else if (row1.equals(row2)) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are separate, non-contiguous tumors in the same primary site and on the same row in the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions?");
        rule.setReason("Separate, non-contiguous tumors in the same primary site and on the same row in the appropriate site table (Tables 1-9) in the Equivalent Terms and Definitions is a single primary.");
        rule.getNotes().add("The same row means the tumors are:");
        rule.getNotes().add("  \u2022 The same histology (same four-digit ICD-O code) OR");
        rule.getNotes().add("  \u2022 One is the preferred term (column 1) and the other is a synonym for the preferred term (column 2) OR");
        rule.getNotes().add("  \u2022 A NOS (column 1/column 2) and the other is a subtype/variant of that NOS (column 3)");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2018_head_and_neck", "M13");
        rule.getNotes().add("Use caution when applying this default rule. Please confirm that you have not overlooked an applicable rule.");
        this._rules.add(rule);
    }
}

