/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphComputeOptions;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;

public class MpRuleHistology
extends MphRule {
    public MpRuleHistology(String groupId, String step) {
        super(groupId, step);
        this.setQuestion("Do the tumors have ICD-O-3 histology codes that are different at the first (?xxx), second (x?xx) or third (xx?x) number?");
        this.setReason("Tumors with ICD-O-3 histology codes that are different at the first (?xxx), second (x?xx) or third (xx?x) number are multiple primaries.");
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
        TempRuleResult result = new TempRuleResult();
        String hist1 = i1.getHistology();
        String hist2 = i2.getHistology();
        if (MphComputeOptions.MpHistologyMatching.LENIENT.equals((Object)options.getHistologyMatchingMode()) && ("8000".equals(hist1) && hist2.startsWith("8") || "8000".equals(hist2) && hist1.startsWith("8"))) {
            return result;
        }
        if (!hist1.substring(0, 3).equals(hist2.substring(0, 3))) {
            result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
        }
        return result;
    }
}

