/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphComputeOptions;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Collections;

public class MpRuleInsituAfterInvasiveSameSide
extends MphRule {
    public MpRuleInsituAfterInvasiveSameSide(String groupId, String step) {
        super(groupId, step);
        this.setQuestion("Is there an in situ tumor following an invasive tumor?");
        this.setReason("An in situ tumor diagnosed following an invasive tumor is a single primary.");
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, MphComputeOptions options) {
        TempRuleResult result = new TempRuleResult();
        String beh1 = i1.getBehavior();
        String beh2 = i2.getBehavior();
        if (!GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality()) && GroupUtility.differentCategory(beh1, beh2, Collections.singletonList("2"), Collections.singletonList("3"))) {
            int latestDx = GroupUtility.compareDxDate(i1, i2);
            if (1 == latestDx && "3".equals(beh1) || 2 == latestDx && "3".equals(beh2)) {
                return result;
            }
            if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                if (-1 == latestDx) {
                    result.setMessageUnknownLatAndDate(this.getStep(), this.getGroupId());
                } else {
                    result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                }
            } else if (-1 == latestDx) {
                result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
            } else if (1 == latestDx && "2".equals(beh1) || 2 == latestDx && "2".equals(beh2)) {
                result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
            }
        }
        return result;
    }
}

