/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph;

import com.imsweb.mph.MphRule;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Range;

public abstract class MphGroup {
    protected String _id;
    protected String _name;
    protected String _siteInclusions;
    protected String _siteExclusions;
    protected String _histInclusions;
    protected String _histExclusions;
    protected String _behavInclusions;
    protected String _yearInclusions;
    protected List<MphRule> _rules;
    private List<Range<Integer>> _siteIncRanges;
    private List<Range<Integer>> _siteExcRanges;
    private List<Range<Integer>> _histIncRanges;
    private List<Range<Integer>> _histExcRanges;
    private List<Range<Integer>> _behavIncRanges;
    private List<Range<Integer>> _yearIncRanges;

    public MphGroup(String id, String name, String siteInclusions, String siteExclusions, String histInclusions, String histExclusions, String behavInclusions, String yearInclusions) {
        this._id = id;
        this._name = name;
        this._siteInclusions = siteInclusions;
        this._siteExclusions = siteExclusions;
        this._histInclusions = histInclusions;
        this._histExclusions = histExclusions;
        this._behavInclusions = behavInclusions;
        this._yearInclusions = yearInclusions;
        this._rules = new ArrayList<MphRule>();
        this._siteIncRanges = GroupUtility.computeRange(siteInclusions, true);
        this._siteExcRanges = GroupUtility.computeRange(siteExclusions, true);
        this._histIncRanges = GroupUtility.computeRange(histInclusions, false);
        this._histExcRanges = GroupUtility.computeRange(histExclusions, false);
        this._behavIncRanges = GroupUtility.computeRange(behavInclusions, false);
        this._yearIncRanges = GroupUtility.computeRange(yearInclusions, false);
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getSiteInclusions() {
        return this._siteInclusions;
    }

    public String getSiteExclusions() {
        return this._siteExclusions;
    }

    public String getHistInclusions() {
        return this._histInclusions;
    }

    public String getHistExclusions() {
        return this._histExclusions;
    }

    public String getBehavInclusions() {
        return this._behavInclusions;
    }

    public String getYearInclusions() {
        return this._yearInclusions;
    }

    public List<MphRule> getRules() {
        return this._rules;
    }

    public boolean isApplicable(String primarySite, String histology, String behavior, int year) {
        boolean siteOk;
        if (!GroupUtility.validateProperties(primarySite, histology, behavior, year)) {
            return false;
        }
        if (!GroupUtility.isContained(this._behavIncRanges, Integer.parseInt(behavior)) || !GroupUtility.isContained(this._yearIncRanges, year)) {
            return false;
        }
        boolean histOk = false;
        Integer site = Integer.parseInt(primarySite.substring(1));
        Integer hist = Integer.parseInt(histology);
        if (this._siteIncRanges != null) {
            siteOk = GroupUtility.isContained(this._siteIncRanges, site);
        } else {
            boolean bl = siteOk = !GroupUtility.isContained(this._siteExcRanges, site);
        }
        if (siteOk) {
            histOk = this._histIncRanges != null ? GroupUtility.isContained(this._histIncRanges, hist) : !GroupUtility.isContained(this._histExcRanges, hist);
        }
        return siteOk && histOk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MphGroup mphGroup = (MphGroup)o;
        return this._id.equals(mphGroup._id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }
}

