/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph;

import com.imsweb.mph.DefaultHematoDbUtilsProvider;
import com.imsweb.mph.HematoDbUtilsProvider;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphOutput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mpgroups.Mp1998HematopoieticGroup;
import com.imsweb.mph.mpgroups.Mp2001HematopoieticGroup;
import com.imsweb.mph.mpgroups.Mp2004BenignBrainGroup;
import com.imsweb.mph.mpgroups.Mp2004SolidMalignantGroup;
import com.imsweb.mph.mpgroups.Mp2007BenignBrainGroup;
import com.imsweb.mph.mpgroups.Mp2007BreastGroup;
import com.imsweb.mph.mpgroups.Mp2007ColonGroup;
import com.imsweb.mph.mpgroups.Mp2007HeadAndNeckGroup;
import com.imsweb.mph.mpgroups.Mp2007KidneyGroup;
import com.imsweb.mph.mpgroups.Mp2007LungGroup;
import com.imsweb.mph.mpgroups.Mp2007MalignantBrainGroup;
import com.imsweb.mph.mpgroups.Mp2007MelanomaGroup;
import com.imsweb.mph.mpgroups.Mp2007OtherSitesGroup;
import com.imsweb.mph.mpgroups.Mp2007UrinaryGroup;
import com.imsweb.mph.mpgroups.Mp2010HematopoieticGroup;
import com.imsweb.mph.mpgroups.Mp2018BreastGroup;
import com.imsweb.mph.mpgroups.Mp2018ColonGroup;
import com.imsweb.mph.mpgroups.Mp2018HeadAndNeckGroup;
import com.imsweb.mph.mpgroups.Mp2018KidneyGroup;
import com.imsweb.mph.mpgroups.Mp2018LungGroup;
import com.imsweb.mph.mpgroups.Mp2018MalignantCNSAndPeripheralNervesGroup;
import com.imsweb.mph.mpgroups.Mp2018NonMalignantCNSTumorsGroup;
import com.imsweb.mph.mpgroups.Mp2018OtherSitesGroup;
import com.imsweb.mph.mpgroups.Mp2018UrinarySitesGroup;
import com.imsweb.mph.mpgroups.Mp2021CutaneousMelanomaGroup;
import com.imsweb.mph.mpgroups.Mp2022BreastGroup;
import com.imsweb.mph.mpgroups.Mp2022ColonGroup;
import com.imsweb.mph.mpgroups.Mp2022HeadAndNeckGroup;
import com.imsweb.mph.mpgroups.Mp2022KidneyGroup;
import com.imsweb.mph.mpgroups.Mp2022MalignantCNSAndPeripheralNervesGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class MphUtils {
    private static MphUtils _INSTANCE = null;
    private HematoDbUtilsProvider _provider = null;
    private Map<String, MphGroup> _groups = new HashMap<String, MphGroup>();

    public static synchronized void initialize(HematoDbUtilsProvider provider) {
        _INSTANCE = new MphUtils(provider);
    }

    public static synchronized boolean isInitialized() {
        return _INSTANCE != null;
    }

    public static synchronized MphUtils getInstance() {
        if (!MphUtils.isInitialized()) {
            MphUtils.initialize(new DefaultHematoDbUtilsProvider());
        }
        return _INSTANCE;
    }

    private void addGroup(MphGroup newGroup) {
        this._groups.put(newGroup.getId(), newGroup);
    }

    private MphUtils(HematoDbUtilsProvider provider) {
        if (provider == null) {
            throw new NullPointerException("Hemato DB Utils provider cannot be null.");
        }
        this._provider = provider;
        this.addGroup(new Mp1998HematopoieticGroup());
        this.addGroup(new Mp2001HematopoieticGroup());
        this.addGroup(new Mp2010HematopoieticGroup());
        this.addGroup(new Mp2004BenignBrainGroup());
        this.addGroup(new Mp2004SolidMalignantGroup());
        this.addGroup(new Mp2007HeadAndNeckGroup());
        this.addGroup(new Mp2007ColonGroup());
        this.addGroup(new Mp2007LungGroup());
        this.addGroup(new Mp2007MelanomaGroup());
        this.addGroup(new Mp2007BreastGroup());
        this.addGroup(new Mp2007KidneyGroup());
        this.addGroup(new Mp2007UrinaryGroup());
        this.addGroup(new Mp2007BenignBrainGroup());
        this.addGroup(new Mp2007MalignantBrainGroup());
        this.addGroup(new Mp2007OtherSitesGroup());
        this.addGroup(new Mp2018BreastGroup());
        this.addGroup(new Mp2018ColonGroup());
        this.addGroup(new Mp2018HeadAndNeckGroup());
        this.addGroup(new Mp2018KidneyGroup());
        this.addGroup(new Mp2018LungGroup());
        this.addGroup(new Mp2018MalignantCNSAndPeripheralNervesGroup());
        this.addGroup(new Mp2018NonMalignantCNSTumorsGroup());
        this.addGroup(new Mp2018OtherSitesGroup());
        this.addGroup(new Mp2018UrinarySitesGroup());
        this.addGroup(new Mp2021CutaneousMelanomaGroup());
        this.addGroup(new Mp2022BreastGroup());
        this.addGroup(new Mp2022ColonGroup());
        this.addGroup(new Mp2022HeadAndNeckGroup());
        this.addGroup(new Mp2022KidneyGroup());
        this.addGroup(new Mp2022MalignantCNSAndPeripheralNervesGroup());
    }

    public MphOutput computePrimaries(MphInput input1, MphInput input2) {
        MphOutput output = new MphOutput();
        int year1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisYear()) ? Integer.parseInt(input1.getDateOfDiagnosisYear()) : -1;
        int year2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisYear()) ? Integer.parseInt(input2.getDateOfDiagnosisYear()) : -1;
        String site1 = input1.getPrimarySite();
        String site2 = input2.getPrimarySite();
        String hist1 = input1.getHistology();
        String hist2 = input2.getHistology();
        String beh1 = input1.getBehavior();
        String beh2 = input2.getBehavior();
        if (!GroupUtility.validateProperties(site1, hist1, beh1, year1)) {
            output.setResult(MpResult.INVALID_INPUT);
            output.setReason("Cannot identify rule set for " + GroupUtility.getSiteHistInfo(site1, hist1, beh1, year1) + ". Valid primary site (C000-C999 excluding C809), histology (8000-9999), behavior (0-3, 6) and diagnosis year are required.");
            return output;
        }
        if (!GroupUtility.validateProperties(site2, hist2, beh2, year2)) {
            output.setResult(MpResult.INVALID_INPUT);
            output.setReason("Cannot identify rule set for " + GroupUtility.getSiteHistInfo(site2, hist2, beh2, year2) + ".Valid primary site (C000-C999 excluding C809), histology (8000-9999), behavior (0-3, 6) and diagnosis year are required.");
            return output;
        }
        int latestYear = Math.max(year1, year2);
        MphGroup group1 = this.findCancerGroup(site1, hist1, beh1, latestYear);
        MphGroup group2 = this.findCancerGroup(site2, hist2, beh2, latestYear);
        if (group1 == null && group2 == null && GroupUtility.sameAndValidMainFields(input1, input2)) {
            output.setResult(MpResult.SINGLE_PRIMARY);
            output.setReason("The two sets of parameters have same values for site, histology, behavior, diagnosis date and laterality.");
        } else if (group1 == null) {
            output.setResult(MpResult.QUESTIONABLE);
            output.setReason("Could not find rule sets for " + GroupUtility.getSiteHistInfo(site1, hist1, beh1, year1) + ".");
        } else if (group2 == null) {
            output.setResult(MpResult.QUESTIONABLE);
            output.setReason("Could not find rule sets for " + GroupUtility.getSiteHistInfo(site2, hist2, beh2, year2) + ".");
        } else if (!group1.getId().equals(group2.getId())) {
            output.setResult(MpResult.MULTIPLE_PRIMARIES);
            output.setReason("The two sets of parameters belong to two different cancer groups.");
        } else {
            TempRuleResult potentialResult = null;
            ArrayList<MphRule> rulesAppliedAfterQuestionable = new ArrayList<MphRule>();
            for (MphRule rule : group1.getRules()) {
                if (potentialResult == null) {
                    output.getAppliedRules().add(rule);
                } else {
                    rulesAppliedAfterQuestionable.add(rule);
                }
                TempRuleResult result = rule.apply(input1, input2);
                if (result.getPotentialResult() != null) {
                    if (potentialResult == null) {
                        potentialResult = result;
                        continue;
                    }
                    if (result.getPotentialResult().equals((Object)potentialResult.getPotentialResult())) continue;
                    output.setResult(MpResult.QUESTIONABLE);
                    output.setGroupId(rule.getGroupId());
                    output.setStep(output.getAppliedRules().get(output.getAppliedRules().size() - 1).getStep());
                    output.setReason(potentialResult.getMessage());
                    break;
                }
                if (result.getFinalResult() == null) continue;
                if (potentialResult == null || potentialResult.getPotentialResult().equals((Object)result.getFinalResult())) {
                    output.setResult(result.getFinalResult());
                    output.setGroupId(rule.getGroupId());
                    output.setStep(rule.getStep());
                    output.setReason(StringUtils.isNotBlank((CharSequence)result.getMessage()) ? result.getMessage() : rule.getReason());
                    if (potentialResult == null || !potentialResult.getPotentialResult().equals((Object)result.getFinalResult())) break;
                    output.getAppliedRules().addAll(rulesAppliedAfterQuestionable);
                    break;
                }
                output.setResult(MpResult.QUESTIONABLE);
                output.setGroupId(rule.getGroupId());
                output.setStep(output.getAppliedRules().get(output.getAppliedRules().size() - 1).getStep());
                output.setReason(potentialResult.getMessage());
                break;
            }
        }
        return output;
    }

    public HematoDbUtilsProvider getHematoDbUtilsProvider() {
        return this._provider;
    }

    public MphGroup findCancerGroup(String primarySite, String histology, String behavior, int year) {
        if (!GroupUtility.validateProperties(primarySite, histology, behavior, year)) {
            return null;
        }
        for (Map.Entry<String, MphGroup> entry : this.getAllGroups().entrySet()) {
            if (!entry.getValue().isApplicable(primarySite, histology, behavior, year)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, MphGroup> getAllGroups() {
        return Collections.unmodifiableMap(this._groups);
    }

    public static enum MpResult {
        SINGLE_PRIMARY,
        MULTIPLE_PRIMARIES,
        QUESTIONABLE,
        INVALID_INPUT;

    }
}

