/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Mp2001HematopoieticGroup
extends MphGroup {
    private static List<String[]> _2001_HEMATOPOIETIC_GROUPS = new ArrayList<String[]>();
    private static List<String[]> _2001_HEMATOPOIETIC_GROUP_PAIRS = new ArrayList<String[]>();

    public Mp2001HematopoieticGroup() {
        super("mp_2001_hemato", "Hematopoietic (2001)", "C000-C809", null, "9590-9989", null, "2-3,6", "2001-2009");
        Mp2001HematopoieticGroup.initializeLookups();
        MphRule rule = new MphRule("mp_2001_hemato", ""){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String hist1 = i1.getHistology();
                String hist2 = i2.getHistology();
                String group1 = null;
                String group2 = null;
                for (String[] row : _2001_HEMATOPOIETIC_GROUPS) {
                    if (group1 == null && hist1.compareTo(row[1]) >= 0 && hist1.compareTo(row[2]) <= 0) {
                        group1 = row[0];
                    }
                    if (group2 == null && hist2.compareTo(row[1]) >= 0 && hist2.compareTo(row[2]) <= 0) {
                        group2 = row[0];
                    }
                    if (group1 == null || group2 == null) continue;
                    break;
                }
                if (group1 != null && group2 != null) {
                    int laterDx = GroupUtility.compareDxDate(i1, i2);
                    if (-1 == laterDx) {
                        result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                        result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                        return result;
                    }
                    String firstDx = 1 == laterDx ? group2 : group1;
                    String secondDx = 1 == laterDx ? group1 : group2;
                    for (String[] row : _2001_HEMATOPOIETIC_GROUP_PAIRS) {
                        if ((!firstDx.equals(row[0]) || !secondDx.equals(row[1])) && (0 != laterDx || !secondDx.equals(row[0]) || !firstDx.equals(row[1]))) continue;
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessage("Single primary based on SEER 2001 multiple primary rules for hematopoietic cancer.");
                        return result;
                    }
                }
                result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                result.setMessage("Multiple primaries based on SEER 2001 multiple primary rules for hematopoietic cancer.");
                return result;
            }
        };
        this._rules.add(rule);
    }

    private static synchronized void initializeLookups() {
        if (_2001_HEMATOPOIETIC_GROUPS.isEmpty() || _2001_HEMATOPOIETIC_GROUP_PAIRS.isEmpty()) {
            InputStream is;
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2001HistologyGroups.csv");
                try {
                    if (is == null) {
                        throw new RuntimeException("Unable to read Hematopoietic2001HistologyGroups.csv");
                    }
                    _2001_HEMATOPOIETIC_GROUPS.addAll(new CSVReaderBuilder((Reader)new InputStreamReader(is, StandardCharsets.US_ASCII)).withSkipLines(1).build().readAll());
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (CsvException | IOException e) {
                throw new RuntimeException(e);
            }
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2001HistologyGroupPairs.csv");
                try {
                    if (is == null) {
                        throw new RuntimeException("Unable to read Hematopoietic2001HistologyGroupPairs.csv");
                    }
                    _2001_HEMATOPOIETIC_GROUP_PAIRS.addAll(new CSVReaderBuilder((Reader)new InputStreamReader(is, StandardCharsets.US_ASCII)).withSkipLines(1).build().readAll());
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (CsvException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

