/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleFiveYearsApart;
import com.imsweb.mph.mprules.MpRuleHistology;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import java.util.Arrays;
import java.util.List;

public class Mp2007HeadAndNeckGroup
extends MphGroup {
    public Mp2007HeadAndNeckGroup() {
        super("mp_2007_head_and_neck", "Head and Neck (2007)", "C000-C148, C300-C329", null, null, "9590-9989, 9140", "2-3,6", "2007-2017");
        MphRule rule = new MphRule("mp_2007_head_and_neck", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> pairedSites = Arrays.asList("C079", "C080,C081", "C090,C091,C098,C099", "C300", "C310,C312", "C301");
                if (GroupUtility.isPairedSites(i1.getPrimarySite(), i2.getPrimarySite(), pairedSites)) {
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in both the left and right sides of a paired site?");
        rule.setReason("Tumors on the right side and the left side of a paired site are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_head_and_neck", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (GroupUtility.differentCategory(i1.getPrimarySite(), i2.getPrimarySite(), MphConstants.UPPER_LIP, MphConstants.LOWER_LIP)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors on the upper lip (C000 or C003) and the lower lip (C001 or C004)?");
        rule.setReason("Tumors on the upper lip (C000 or C003) and the lower lip (C001 or C004) are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_head_and_neck", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (GroupUtility.differentCategory(i1.getPrimarySite(), i2.getPrimarySite(), MphConstants.UPPER_GUM, MphConstants.LOWER_GUM)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors on the upper gum (C030) and the lower gum (C031)?");
        rule.setReason("Tumors on the upper gum (C030) and the lower gum (C031) are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_head_and_neck", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (GroupUtility.differentCategory(i1.getPrimarySite(), i2.getPrimarySite(), MphConstants.NASAL_CAVITY, MphConstants.MIDDLE_EAR)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in the nasal cavity (C300) and the middle ear (C301)?");
        rule.setReason("Tumors in the nasal cavity (C300) and the middle ear (C301) are multiple primaries.");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("mp_2007_head_and_neck", "M7");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("mp_2007_head_and_neck", "M8");
        rule.getNotes().add("The purpose of this rule is to ensure that the case is counted as an incident (invasive) case when incidence data are analyzed.");
        rule.getNotes().add("Abstract as multiple primaries even if the medical record/physician states it is recurrence or progression of disease.");
        this._rules.add(rule);
        rule = new MpRuleFiveYearsApart("mp_2007_head_and_neck", "M9");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_head_and_neck", "M10"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String hist1 = i1.getHistology();
                String hist2 = i2.getHistology();
                List<String> nosList = Arrays.asList("8000", "8010", "8140", "8070", "8720", "8800");
                if (nosList.contains(hist1) && MphConstants.NOS_VS_SPECIFIC.containsKey(hist1) && MphConstants.NOS_VS_SPECIFIC.get(hist1).contains(hist2) || nosList.contains(hist2) && MphConstants.NOS_VS_SPECIFIC.containsKey(hist2) && MphConstants.NOS_VS_SPECIFIC.get(hist2).contains(hist1)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is there cancer/malignant neoplasm, NOS (8000) and another is a specific histology? or\nIs there carcinoma, NOS (8010) and another is a specific carcinoma? or\nIs there adenocarcinoma, NOS (8140) and another is a specific adenocarcinoma? or\nIs there squamous cell carcinoma, NOS (8070) and another is a specific squamous cell carcinoma? or\nIs there melanoma, NOS (8720) and another is a specific melanoma? or\nIs there sarcoma, NOS (8800) and another is a specific sarcoma?");
        rule.setReason("Abstract as a single primary* when one tumor is:\n- Cancer/malignant neoplasm, NOS (8000) and another is a specific histology or\n- Carcinoma, NOS (8010) and another is a specific carcinoma or\n- Adenocarcinoma, NOS (8140) and another is a specific adenocarcinoma or\n- Squamous cell carcinoma, NOS (8070) and another is specific squamous cell carcinoma or\n- Melanoma, NOS (8720) and another is a specific melanoma or\n- Sarcoma, NOS (8800) and another is a specific sarcoma");
        this._rules.add(rule);
        rule = new MpRuleHistology("mp_2007_head_and_neck", "M11");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2007_head_and_neck", "M12");
        rule.getNotes().add("When an invasive tumor follows an in situ tumor within 60 days, abstract as a single primary.");
        rule.getNotes().add("All cases covered by Rule M12 have the same first 3 numbers in ICD-O-3 histology code.");
        rule.getExamples().add("Multifocal tumors in floor of mouth.");
        rule.getExamples().add("An in situ and invasive tumor diagnosed within60 days.");
        rule.getExamples().add("In situ following an invasive tumor more than 60 days apart.");
        this._rules.add(rule);
    }
}

