/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleHistology;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import java.util.Collections;
import java.util.List;

public class Mp2007MalignantBrainGroup
extends MphGroup {
    public Mp2007MalignantBrainGroup() {
        super("mp_2007_malignant_brain", "Malignant Brain (2007)", "C700-C701,C709-C725,C728-C729,C751-C753", null, null, "9590-9989,9140", "3", "2007-2017");
        MphRule rule = new MphRule("mp_2007_malignant_brain", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                return new TempRuleResult();
            }
        };
        rule.setQuestion("Is there an invasive tumor (/3) and either a benign brain tumor (/0) or an uncertain/borderline brain tumor (/1)?");
        rule.setReason("An invasive brain tumor (/3) and either a benign brain tumor (/0) or an uncertain/borderline brain tumor (/1) are always multiple primaries.");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("mp_2007_malignant_brain", "M5");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_malignant_brain", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String h2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                if (!h1.equals(h2 = i2.getHistology()) && GroupUtility.differentCategory(h1, h2, MphConstants.GLIAL_TUMOR, Collections.singletonList("9440"))) {
                    int laterDiagnosedTumor = GroupUtility.compareDxDate(i1, i2);
                    if (-1 == laterDiagnosedTumor) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                    } else if (1 == laterDiagnosedTumor && "9440".equals(h1)) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    } else if (2 == laterDiagnosedTumor && "9440".equals(h2)) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Is there a glioblastoma or glioblastoma multiforme (9440) following a glial tumor (See Chart 1) ?");
        rule.setReason("A glioblastoma or glioblastoma multiforme (9440) following a glial tumor is a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_malignant_brain", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> branch1 = MphConstants.MALIGNANT_BRAIN_2007_CHART1.get(i1.getHistology());
                List<String> branch2 = MphConstants.MALIGNANT_BRAIN_2007_CHART1.get(i2.getHistology());
                if (branch1 != null && branch2 != null && (!Collections.disjoint(branch1, branch2) || branch1.contains("Neuroepithelial") || branch2.contains("Neuroepithelial"))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                } else {
                    branch1 = MphConstants.MALIGNANT_BRAIN_2007_CHART2.get(i1.getHistology());
                    branch2 = MphConstants.MALIGNANT_BRAIN_2007_CHART2.get(i2.getHistology());
                    if (branch1 != null && branch2 != null && !Collections.disjoint(branch1, branch2)) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Do the tumors have ICD-O-3 histology on the same branch in Chart 1 or Chart 2?");
        rule.setReason("Tumors with ICD-O-3 histology codes on the same branch in Chart 1 or Chart 2 are a single primary.");
        rule.getNotes().add("Recurrence, progression, or any reappearance of histologies on the same branch in Chart 1 or Chart 2 is always the same disease process.");
        rule.getExamples().add("Patient has an astrocytoma. Ten years later the patient is diagnosed with glioblastoma multiforme. This is a progression or recurrence of the earlier astrocytoma.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_malignant_brain", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> branch1 = MphConstants.MALIGNANT_BRAIN_2007_CHART1.get(i1.getHistology());
                List<String> branch2 = MphConstants.MALIGNANT_BRAIN_2007_CHART1.get(i2.getHistology());
                if (branch1 != null && branch2 != null && Collections.disjoint(branch1, branch2) && !branch1.contains("Neuroepithelial") && !branch2.contains("Neuroepithelial")) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else {
                    branch1 = MphConstants.MALIGNANT_BRAIN_2007_CHART2.get(i1.getHistology());
                    branch2 = MphConstants.MALIGNANT_BRAIN_2007_CHART2.get(i2.getHistology());
                    if (branch1 != null && branch2 != null && Collections.disjoint(branch1, branch2)) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Do the tumors have ICD-O-3 histology codes on different branches in Chart 1 or Chart 2?");
        rule.setReason("Tumors with ICD-O-3 histology codes on different branches in Chart 1 or Chart 2 are multiple primaries.");
        this._rules.add(rule);
        rule = new MpRuleHistology("mp_2007_malignant_brain", "M9");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2007_malignant_brain", "M10");
        rule.getNotes().add("Multicentric brain tumors which involve different lobes of the brain that do not meet any of the above criteria are the same disease process.");
        rule.getNotes().add("Neither timing nor laterality is used to determine multiple primaries for malignant intracranial and CNS tumors.");
        rule.getExamples().add("The patient is treated for an anaplastic astrocytoma (9401) in the right parietal lobe. Three months later the patient is diagnosed with a separate anaplastic astrocytoma in the left parietal lobe. This is one primary because laterality is not used to determine multiple primary status.");
        this._rules.add(rule);
    }
}

