/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleHistology;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import com.imsweb.mph.mprules.MpRuleThreeYearsApart;
import java.util.ArrayList;
import java.util.Arrays;

public class Mp2007UrinaryGroup
extends MphGroup {
    public Mp2007UrinaryGroup() {
        super("mp_2007_urinary", "Urinary (2007)", "C659, C669, C670-C679, C680-C689", null, null, "9590-9989, 9140", "2-3,6", "2007-2017");
        MphRule rule = new MphRule("mp_2007_urinary", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if ("C659".equals(i1.getPrimarySite()) && "C659".equals(i2.getPrimarySite())) {
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in both the right renal pelvis and the left renal pelvis and no other urinary sites are involved?");
        rule.setReason("When no other urinary sites are involved, tumor(s) in the right renal pelvis AND tumor(s) in the left renal pelvis are multiple primaries.");
        rule.getNotes().add("Use this rule and abstract as a multiple primary unless documented to be metastatic.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_urinary", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if ("C669".equals(i1.getPrimarySite()) && "C669".equals(i2.getPrimarySite())) {
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in both the right ureter and the left ureter and no other urinary sites are involved?");
        rule.setReason("When no other urinary sites are involved, tumor(s) in both the right ureter AND tumor(s) in the left ureter are multiple primaries.");
        rule.getNotes().add("Use this rule and abstract as a multiple primary unless documented to be metastatic.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("mp_2007_urinary", "M5");
        rule.getNotes().add("The purpose of this rule is to ensure that the case is counted as an incident (invasive) case when incidence data are analyzed.");
        rule.getNotes().add("Abstract as multiple primaries even if the medical record/physician states it is recurrence or progression of disease.");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_urinary", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                ArrayList<String> carcinomaHist = new ArrayList<String>(MphConstants.TRANSITIONAL_CELL_CARCINOMA);
                carcinomaHist.addAll(MphConstants.PAPILLARY_TRANSITIONAL_CELL_CARCINOMA);
                carcinomaHist.add("8050");
                if (i1.getPrimarySite().startsWith("C67") && i2.getPrimarySite().startsWith("C67") && carcinomaHist.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there bladder tumors with any combination of the following histologies:\n- papillary carcinoma (8050)\n- transitional cell carcinoma (8120-8124)\n- papillary tansitional cell carcinoma (8130-8131)?");
        rule.setReason("Bladder tumors with any combination of the following histologies: papillary carcinoma (8050), transitional cell carcinoma (8120-8124), or papillary transitional cell carcinoma (8130-8131), are a single primary.");
        this._rules.add(rule);
        rule = new MpRuleThreeYearsApart("mp_2007_urinary", "M7");
        this._rules.add(rule);
        rule = new MphRule("mp_2007_urinary", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String site1 = i1.getPrimarySite();
                String site2 = i2.getPrimarySite();
                if (MphConstants.UROTHELIAL.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology())) && ("C659".equals(site1) || "C669".equals(site1) || site1.startsWith("C67") || "C680".equals(site1)) && ("C659".equals(site2) || "C669".equals(site2) || site2.startsWith("C67") || "C680".equals(site2))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there urothelial tumors in two or more of the following sites:\n- Renal pelvis (C659)\n- Ureter(C669)\n- Bladder (C670-C679)\n- Urethra /prostatic urethra (C680)");
        rule.setReason("Urothelial tumors in two or more of the following sites are a single primary.\n- Renal pelvis (C659)\n- Ureter(C669)\n- Bladder (C670-C679)\n- Urethra /prostatic urethra (C680)");
        this._rules.add(rule);
        rule = new MpRuleHistology("mp_2007_urinary", "M9");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("mp_2007_urinary", "M10");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2007_urinary", "M11");
        rule.getNotes().add("When an invasive tumor follows an in situ tumor within 60 days, abstract as a single primary.");
        this._rules.add(rule);
    }
}

