/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import java.util.Collections;

public class Mp2018MalignantCNSAndPeripheralNervesGroup
extends MphGroup {
    public Mp2018MalignantCNSAndPeripheralNervesGroup() {
        super("mp_2018_malignant_cns_and_peripheral_nerves", "2018 Malignant CNS And Peripheral Nerves", "C470-C479, C700, C701, C709, C710-C719, C720-C725, C728, C729, C751-C753", null, null, "9590-9992, 9140", "3", "2018-2021");
        MphRule rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                return new TempRuleResult();
            }
        };
        rule.getNotes().add("The rules are hierarchical. Only use when previous rules do not apply.");
        rule.getNotes().add("See Table 2 in the Equivalent Terms and Definitions for a listing of CNS sites.");
        rule.getNotes().add("A non-malignant CNS tumor and a malignant CNS tumor are always multiple primaries (timing and primary sites are irrelevant). Prepare two abstracts; one for the non-malignant and another for the malignant tumor.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String h2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                if (!h1.equals(h2 = i2.getHistology()) && GroupUtility.differentCategory(h1, h2, MphConstants.GLIAL_TUMOR_2018, Collections.singletonList("9440"))) {
                    int laterDiagnosedTumor = GroupUtility.compareDxDate(i1, i2);
                    if (-1 == laterDiagnosedTumor) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                    } else if (1 == laterDiagnosedTumor && "9440".equals(h1)) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    } else if (2 == laterDiagnosedTumor && "9440".equals(h2)) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Does the patient have a glial tumor and is subsequently diagnosed with a glioblastoma multiforme 9440 (GBM)?");
        rule.setReason("A glial tumor that is subsequently diagnosed with a glioblastoma multiforme 9440 (GBM) is multiple primaries.");
        rule.getNotes().add("Definition of a glial tumor: Any tumor arising from the CNS glial cells.  The following is simply a list of all tumors which would be classified as glial.");
        rule.getNotes().add("  - Astroblastoma 9430");
        rule.getNotes().add("  - Astrocytomas 9400 and all subtypes");
        rule.getNotes().add("    \uf0a7 Anaplastic astrocytoma IDH-mutant/wildtype; anaplastic astrocytoma NOS 9401");
        rule.getNotes().add("    \uf0a7 Gemistocytic astrocytoma IDH-mutant 9411");
        rule.getNotes().add("  - Diffuse midline glioma H3 K27M Mutant 9385");
        rule.getNotes().add("  - Ependymoma 9391 and all subtypes");
        rule.getNotes().add("    \uf0a7 Anaplastic ependymoma 9392");
        rule.getNotes().add("    \uf0a7 Ependymoma, RELA fusion-positive 9396");
        rule.getNotes().add("    \uf0a7 Papillary ependymoma 9393");
        rule.getNotes().add("  - Glioblastoma 9440 and all subtypes (this is a glial tumor; however do not apply this rule to a GBM followed by a GBM)");
        rule.getNotes().add("    \uf0a7 Giant cell glioblastoma 9441");
        rule.getNotes().add("    \uf0a7 Glioblastoma IDH-mutant 9445");
        rule.getNotes().add("    \uf0a7 Gliosarcoma 9442");
        rule.getNotes().add("  - Oligodendroglioma and all subtypes 9450");
        rule.getNotes().add("    \uf0a7 Anaplastic oligodendroglioma; IDH-mutant; 1p/19q-codeleted; IDH-mutant and 1p/19q-codeleted 9451");
        rule.getNotes().add("  - Pleomorphic xanthroastrocytoma 9424");
        rule.getNotes().add("This is a change from the 2007 Rules.");
        rule.getNotes().add("Abstracting GBM as a new primary will allow analysis of:");
        rule.getNotes().add("  - The number of tumors that recur as a more aggressive histology (GBM)");
        rule.getNotes().add("  - The time interval between occurrence of the glial or astrocytic tumors and a GBM");
        rule.getNotes().add("  - Which histologies are more likely to recur as a GBM");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (i1.getHistology().equals(i2.getHistology()) && GroupUtility.isSiteContained("C710-C719", i1.getPrimarySite()) && GroupUtility.isSiteContained("C710-C719", i2.getPrimarySite())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are the tumors separate, non-contiguous, in the brain (multicentric/multifocal), and have the same histology?");
        rule.setReason("Tumors which are separate, non-contiguous, in the brain (multicentric/multifocal), and have the same histology are a single primary.");
        rule.getExamples().add("The patient had a resection of an anaplastic astrocytoma 9401 in the right parietal lobe. Three months later the patient is diagnosed with a de novo anaplastic astrocytoma in the left parietal lobe. This is one primary because neither laterality nor timing are used to determine multiple primary status.");
        rule.getNotes().add("Multiple sites/subsites and/or different lateralities imply either metastatic or multifocal/multicentric disease. Glioblastoma multiforme commonly exhibits multiple tumors which are described as multifocal/multicentric.");
        rule.getNotes().add("Metastases are never used to determine multiple primaries. Seeding metastasis is often noted for the following tumors:");
        rule.getNotes().add("  - Glioblastoma multiforme");
        rule.getNotes().add("  - pNET-medulloblastoma");
        rule.getNotes().add("  - Oligodendroglioma");
        rule.getNotes().add("Hereditary syndromes frequently exhibit multiple tumors including the following:");
        rule.getNotes().add("  - Neurofibromatosis type 1 (NF1)");
        rule.getNotes().add("    \uf0a7 Malignant peripheral nerve sheath tumors (MPNST)");
        rule.getNotes().add("  - Neurofibromatosis type 2 (NF2)");
        rule.getNotes().add("    \uf0a7 Anaplastic ependymomas");
        rule.getNotes().add("    \uf0a7 Meningiomas");
        rule.getNotes().add("Most malignant neoplasms are single tumors with the exception of those listed in this rule.");
        rule.getNotes().add("This is a change from/clarification to previous rules.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String s1 = i1.getPrimarySite();
                String s2 = i2.getPrimarySite();
                if (GroupUtility.isSiteContained("C710-C719", s1) && !GroupUtility.isSiteContained("C710-C719", s2) || GroupUtility.isSiteContained("C710-C719", s2) && !GroupUtility.isSiteContained("C710-C719", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C721", s1) && !GroupUtility.isSiteContained("C721", s2) || GroupUtility.isSiteContained("C721", s2) && !GroupUtility.isSiteContained("C721", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C700", s1) && !GroupUtility.isSiteContained("C700", s2) || GroupUtility.isSiteContained("C700", s2) && !GroupUtility.isSiteContained("C700", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C722-C725", s1) && !GroupUtility.isSiteContained("C722-C725", s2) || GroupUtility.isSiteContained("C722-C725", s2) && !GroupUtility.isSiteContained("C722-C725", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C722-C725", s1) && GroupUtility.isSiteContained("C722-C725", s2) && !s1.equals(s2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C709", s1) && !GroupUtility.isSiteContained("C709", s2) || GroupUtility.isSiteContained("C709", s2) && !GroupUtility.isSiteContained("C709", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C720", s1) && !GroupUtility.isSiteContained("C720", s2) || GroupUtility.isSiteContained("C720", s2) && !GroupUtility.isSiteContained("C720", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C701", s1) && !GroupUtility.isSiteContained("C701", s2) || GroupUtility.isSiteContained("C701", s2) && !GroupUtility.isSiteContained("C701", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are multiple tumors present in the following sites:\nAny lobe of the brain C710-C719 AND any other part of CNS,\nCauda equina C721 AND any other part of CNS,\nCerebral meninges C700 AND spinal meninges C701,\nCerebral meninges C700 AND any other part of CNS,\nAny of the cranial nerves C722-C725 AND any other part of the CNS,\nAny two or more of the cranial nerves: C722 Olfactory, C723 Optic, C724 Acoustic, C725 Cranial nerves NOS,\nMeninges of cranial or peripheral nerves C709 AND any other part of the CNS,\nSpinal cord C720 AND any other part of CNS,\nSpinal meninges C701 AND any other part of CNS?");
        rule.setReason("Multiple tumors present in the following sites:\nAny lobe of the brain C710-C719 AND any other part of CNS,\nCauda equina C721 AND any other part of CNS,\nCerebral meninges C700 AND spinal meninges C701,\nCerebral meninges C700 AND any other part of CNS,\nAny of the cranial nerves C722-C725 AND any other part of the CNS,\nAny two or more of the cranial nerves: C722 Olfactory, C723 Optic, C724 Acoustic, C725 Cranial nerves NOS,\nMeninges of cranial or peripheral nerves C709 AND any other part of the CNS,\nSpinal cord C720 AND any other part of CNS,\nSpinal meninges C701 AND any other part of CNS,\nare multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M9"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String subtype2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String subtype1 = MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.containsKey(h1) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.get(h1) : MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.get(icd1);
                String string = subtype2 = MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.containsKey(h2) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.get(h2) : MphConstants.MALIGNANT_CNS_2018_TABLE3_SUBTYPES.get(icd2);
                if (subtype1 != null && subtype2 != null && !subtype1.contains(subtype2) && !subtype2.contains(subtype1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors two or more different subtypes/variants in Column 3, Table 3 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors that are two or more different subtypes/variants in Column 3, Table 3 in the Equivalent Terms and Definitions are multiple primaries.");
        rule.getNotes().add("The tumors may be subtypes/variants of the same or different NOS histologies.");
        rule.getNotes().add("  - Same NOS: Anaplastic astrocytoma IDH-mutant 9401 and gemistocytic astrocytoma IDH-mutant 9411 are both subtypes of astrocytoma NOS 9400/3 but are distinctly different histologies. Abstract multiple primaries.");
        rule.getNotes().add("  - Different NOS: Papillary ependymoma 9393 is a subtype of ependymoma NOS 9391; gliosarcoma 9442 is a subtype of glioblastoma NOS 9440. They are distinctly different histologies. Abstract multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M10"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.containsKey(h1) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(h1) : MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(icd1);
                String string = row2 = MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.containsKey(h2) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(h2) : MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (row1.equals(row2)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors on the same rows in Table 3 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors on the same row in Table 3 in the Equivalent Terms and Definitions is a single primary.");
        rule.getNotes().add("The same row means the tumors are:");
        rule.getNotes().add("  - The same histology (same four-digit ICD-O code) OR");
        rule.getNotes().add("  - One is the preferred term (column 1) and the other is a synonym for the preferred term (column 2) OR");
        rule.getNotes().add("  - A NOS (column 1/column 2) and the other is a subtype/variant of that NOS (column 3)");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_malignant_cns_and_peripheral_nerves", "M11"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.containsKey(h1) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(h1) : MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(icd1);
                String string = row2 = MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.containsKey(h2) ? MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(h2) : MphConstants.MALIGNANT_CNS_2018_TABLE3_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (!row1.equals(row2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors on different rows in Table 3 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors on different rows in Table 3 in the Equivalent Terms and Definitions is multiple primaries.");
        rule.getNotes().add("Each row in the table is a distinctly different histology.");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2018_malignant_cns_and_peripheral_nerves", "M12");
        rule.getNotes().add("Use caution when applying this default rule.  Please confirm that you have not overlooked an applicable rule.");
        this._rules.add(rule);
    }
}

