/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import java.util.Arrays;

public class Mp2018NonMalignantCNSTumorsGroup
extends MphGroup {
    public Mp2018NonMalignantCNSTumorsGroup() {
        super("mp_2018_non_malignant_cns_tumors", "2018 Non Malignant CNS Tumors", "C700, C701, C709, C710-C719, C720-C725, C728, C729, C751-C753", null, null, "9590-9992, 9140", "0-1", "2018-9999");
        MphRule rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                return new TempRuleResult();
            }
        };
        rule.setQuestion("Is there a malignant tumor following a non-malignant tumor?");
        rule.setReason("A malignant tumor diagnosed following an non-malignant tumor is multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String icd2;
                TempRuleResult result = new TempRuleResult();
                String icd1 = i1.getHistology() + "/" + i1.getBehavior();
                if (icd1.equals(icd2 = i2.getHistology() + "/" + i2.getBehavior()) && Arrays.asList("9560/0", "9421/1").contains(icd1)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are the tumors bilateral acoustic neuromas/vestibular schwannomas 9560/0 or bilateral optic gliomas/pilocytic astrocytomas 9421/1?");
        rule.setReason("Bilateral acoustic neuromas/vestibular schwannomas 9560/0 or bilateral optic gliomas/pilocytic astrocytomas 9421/1 are a single primary.");
        rule.getNotes().add("The bilateral tumors may appear simultaneously (at the same time) OR the contralateral tumor may be diagnosed at any time following the original diagnosis.");
        rule.getNotes().add("WHO and IARC designate pilocytic astrocytoma as a synonyn for optic glioma.  When the primary site is optic nerve, the behavior is non-malignant.");
        rule.getNotes().add("When the bilateral tumors are diagnosed at different times, the physician may stage each tumor because staging and determining multiple primaries are done for different reasons. Staging determines which course of treatment would be most effective. Determining multiple primaries is done to stabilize the data for the study of epidemiology (long-term studies done on incidence, mortality, and causation of a disease with the goal of reducing or eliminating that disease).");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String s1 = i1.getPrimarySite();
                String s2 = i2.getPrimarySite();
                if (GroupUtility.isSiteContained("C710-C719", s1) && !GroupUtility.isSiteContained("C710-C719", s2) || GroupUtility.isSiteContained("C710-C719", s2) && !GroupUtility.isSiteContained("C710-C719", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C721", s1) && !GroupUtility.isSiteContained("C721", s2) || GroupUtility.isSiteContained("C721", s2) && !GroupUtility.isSiteContained("C721", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C700", s1) && !GroupUtility.isSiteContained("C700", s2) || GroupUtility.isSiteContained("C700", s2) && !GroupUtility.isSiteContained("C700", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C722-C725", s1) && !GroupUtility.isSiteContained("C722-C725", s2) || GroupUtility.isSiteContained("C722-C725", s2) && !GroupUtility.isSiteContained("C722-C725", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C709", s1) && !GroupUtility.isSiteContained("C709", s2) || GroupUtility.isSiteContained("C709", s2) && !GroupUtility.isSiteContained("C709", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C720", s1) && !GroupUtility.isSiteContained("C720", s2) || GroupUtility.isSiteContained("C720", s2) && !GroupUtility.isSiteContained("C720", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                } else if (GroupUtility.isSiteContained("C701", s1) && !GroupUtility.isSiteContained("C701", s2) || GroupUtility.isSiteContained("C701", s2) && !GroupUtility.isSiteContained("C701", s1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are multiple tumors present in the following sites:\n - Any lobe(s) of the brain C710-C719 AND any other part of CNS\n - Cauda equina C721 AND any other part of CNS\n - Cerebral meninges C700 AND spinal meninges C701\n - Cerebral meninges C700 AND any other part of CNS\n - Any cranial nerve(s) C721-C725 AND any other part of the CNS\n - Meninges of cranial nerves C709 AND any other part of the CNS\n - Spinal cord C720 AND any other part of CNS\n - Spinal meninges C701 AND any other part of CNS?");
        rule.setReason("Multiple tumors present in the following sites:\n - Any lobe(s) of the brain C710-C719 AND any other part of CNS\n - Cauda equina C721 AND any other part of CNS\n - Cerebral meninges C700 AND spinal meninges C701\n - Cerebral meninges C700 AND any other part of CNS\n - Any cranial nerve(s) C721-C725 AND any other part of the CNS\n - Meninges of cranial nerves C709 AND any other part of the CNS\n - Spinal cord C720 AND any other part of CNS\n - Spinal meninges C701 AND any other part of CNS\nare multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String icd1 = i1.getHistology() + "/" + i1.getBehavior();
                String icd2 = i2.getHistology() + "/" + i2.getBehavior();
                if (!i1.getHistology().equals(i2.getHistology()) && MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_SUBTYPES.containsAll(Arrays.asList(icd1, icd2))) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors two or more different subtypes/variants in Column 3, Table 6 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors that are two or more different subtypes/variants in Column 3, Table 6 in the Equivalent Terms and Definitions are multiple primaries.");
        rule.getNotes().add("The tumors may be subtypes/variants of the same or different NOS histologies.");
        rule.getNotes().add("  - Same NOS: Atypical meningioma 9539/1 and fibrous meningioma 9532/0 are both subtypes of meningioma NOS 9530 but are distinctly different histologies. Abstract multiple primaries.");
        rule.getNotes().add("  - Different NOS: Melanotic schwannoma 9560/1 is a subtype of schwannoma NOS 9560/0; papillary craniopharyngioma 9352/1 is a subtype of craniopharyngioma 9350/1. They are distinctly different histologies. Abstract multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M9"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String icd1 = i1.getHistology() + "/" + i1.getBehavior();
                String icd2 = i2.getHistology() + "/" + i2.getBehavior();
                if ("C700".equals(i1.getPrimarySite()) && i2.getPrimarySite().equals(i1.getPrimarySite()) && MphConstants.CNS_2018_MENINGIOMAS.containsAll(Arrays.asList(icd1, icd2))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are two or more separate/non-contiguous meningiomas arising in the cranial meninges?");
        rule.setReason("Two or more separate/non-contiguous meningiomas arising in the cranial meninges is a single primary.");
        rule.getNotes().add("This rule applies ONLY to meningiomas.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M10"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (i1.getHistology().equals(i2.getHistology()) && GroupUtility.isSiteContained("C710-C719", i1.getPrimarySite()) && GroupUtility.isSiteContained("C710-C719", i2.getPrimarySite())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are the tumors separate, non-contiguous and in the brain (multicentric/multifocal)?");
        rule.setReason("Tumors which are separate, non-contiguous and in the brain (multicentric/multifocal) are a single primary.");
        rule.getNotes().add("Metastases are never used to determine multiple primaries. Seeding metastasis is often noted in ependymomas.");
        rule.getNotes().add("This is a change from/clarification to previous rules.");
        rule.getNotes().add("These rules are hierarchical.  Use this rule ONLY when the previous rules do not apply.");
        rule.getNotes().add("An example of a non-malignant brain tumor that may be multi-focal/multi-centric is hemangioblastoma 9161/1.");
        rule.getNotes().add("The physician may stage each tumor because staging and determining multiple primaries are done for different reasons. Staging determines which course of treatment would be most effective. Determining multiple primaries is done to stabilize the data for the study of epidemiology (long-term studies done on incidence, mortality, and causation of a disease with the goal of reducing or eliminating that disease).");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M11"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.containsKey(h1) ? MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(h1) : MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(icd1);
                String string = row2 = MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.containsKey(h2) ? MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(h2) : MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (row1.equals(row2)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors on the same rows in Table 6 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors on the same row in Table 6 in the Equivalent Terms and Definitions is a single primary.");
        rule.getNotes().add("The same row means the tumors are:");
        rule.getNotes().add("  - The same histology (same four-digit ICD-O code) OR");
        rule.getNotes().add("  - One is the preferred term (column 1) and the other is a synonym for the preferred term (column 2) OR");
        rule.getNotes().add("  - A NOS (column 1/column 2) and the other is a subtype/variant of that NOS (column 3). NOS and subtype/variants are:");
        rule.getNotes().add("    \uf0a7 Choroid plexus papilloma 9390/0 and a subtype/variant of choroid plexus papilloma");
        rule.getNotes().add("    \uf0a7 Craniopharyngioma 9350/1 and a subtype/variant of craniopharyngioma");
        rule.getNotes().add("    \uf0a7 Gangliocytoma 9492/0 and a subtype/variant of craniopharyngioma");
        rule.getNotes().add("    \uf0a7 Lipoma 8860/0 and a subtype/variant of lipoma");
        rule.getNotes().add("    \uf0a7 Meningeal melanocytosis 8728/0 and a subtype/variant of meningeal melanocytosis");
        rule.getNotes().add("    \uf0a7 Meningioma 9530/0 and a subtype/variant of meningioma");
        rule.getNotes().add("    \uf0a7 Myofibroblastoma 8825/0 and a subtype/variant of myofibroblastoma");
        rule.getNotes().add("    \uf0a7 Neurofibroma 9540/0 and a subtype/variant of neurofibroma");
        rule.getNotes().add("    \uf0a7 Schwannoma 9560/0 and a subtype/variant of schwannoma");
        rule.getNotes().add("    \uf0a7 Solitary fibrous tumor WHO Grade 1 8815/0 and a subtype/variant of solitary fibrous tumor WHO Grade 1");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_non_malignant_cns_tumors", "M12"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.containsKey(h1) ? MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(h1) : MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(icd1);
                String string = row2 = MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.containsKey(h2) ? MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(h2) : MphConstants.NON_MALIGNANT_CNS_2018_TABLE6_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (!row1.equals(row2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors on different rows in Table 6 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors on different rows in Table 6 in the Equivalent Terms and Definitions is multiple primaries.");
        rule.getNotes().add("Each row in the table is a distinctly different histology.");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2018_non_malignant_cns_tumors", "M13");
        rule.getNotes().add("These rules are hierarchical.  Use this rule ONLY when the previous rules do not apply.");
        this._rules.add(rule);
    }
}

