/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mpgroups.Mp2007MelanomaGroup;
import com.imsweb.mph.mpgroups.Mp2018BreastGroup;
import com.imsweb.mph.mpgroups.Mp2018ColonGroup;
import com.imsweb.mph.mpgroups.Mp2018HeadAndNeckGroup;
import com.imsweb.mph.mpgroups.Mp2018KidneyGroup;
import com.imsweb.mph.mpgroups.Mp2018LungGroup;
import com.imsweb.mph.mpgroups.Mp2018MalignantCNSAndPeripheralNervesGroup;
import com.imsweb.mph.mpgroups.Mp2018NonMalignantCNSTumorsGroup;
import com.imsweb.mph.mpgroups.Mp2018UrinarySitesGroup;
import com.imsweb.mph.mpgroups.Mp2021CutaneousMelanomaGroup;
import com.imsweb.mph.mpgroups.Mp2022BreastGroup;
import com.imsweb.mph.mpgroups.Mp2022ColonGroup;
import com.imsweb.mph.mpgroups.Mp2022HeadAndNeckGroup;
import com.imsweb.mph.mpgroups.Mp2022KidneyGroup;
import com.imsweb.mph.mpgroups.Mp2022MalignantCNSAndPeripheralNervesGroup;
import com.imsweb.mph.mprules.MpRuleHistology;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Mp2018OtherSitesGroup
extends MphGroup {
    public Mp2018OtherSitesGroup() {
        super("mp_2018_other_sites", "2018 Other Sites", null, null, null, "", "2-3,6", "2018-9999");
        MphRule rule = new MphRule("mp_2018_other_sites", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if ("C619".equals(i1.getPrimarySite()) && "C619".equals(i2.getPrimarySite()) && MphConstants.ADENOCARCINOMA_NOS.contains(i1.getHistology()) && MphConstants.ADENOCARCINOMA_NOS.contains(i2.getHistology())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is the diagnosis adenocarcinoma of the prostate?");
        rule.setReason("Adenocarcinoma of the prostate is always a single primary.");
        rule.getNotes().add("Report only one adenocarcinoma of the prostate per patient per lifetime.");
        rule.getNotes().add("95% of prostate malignancies are the common (acinar) adenocarcinoma histology (8140). See Equivalent Terms, Definitions and Tables for more information.");
        rule.getNotes().add("If patient has a previous acinar adenocarcinoma of the prostate in the database and is diagnosed with adenocarcinoma in 2007 it is a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (MphConstants.RETINO_BLASTOMA.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is the diagnosis retinoblastoma (unilateral or bilateral)?");
        rule.setReason("Retinoblastoma is always a single primary (unilateral or bilateral).");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if ("9140".equals(i1.getHistology()) && "9140".equals(i2.getHistology())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is the diagnosis Kaposi sarcoma (any site or sites)?");
        rule.setReason("Kaposi sarcoma (any site or sites) is always a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                ArrayList<String> follicularAndPapillary = new ArrayList<String>(MphConstants.FOLLICULAR);
                follicularAndPapillary.addAll(MphConstants.PAPILLARY);
                String site1 = i1.getPrimarySite();
                String site2 = i2.getPrimarySite();
                String hist1 = i1.getHistology();
                String hist2 = i2.getHistology();
                if ("C739".equals(site1) && "C739".equals(site2) && follicularAndPapillary.containsAll(Arrays.asList(hist1, hist2))) {
                    int sixtyDayApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                    if (-1 == sixtyDayApart) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessage("Unable to apply Rule " + this.getStep() + " of " + this.getGroupId() + ". There is no enough diagnosis date information.");
                    } else if (0 == sixtyDayApart) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there follicular and papillary tumors of the thyroid within 60 days of diagnosis?");
        rule.setReason("Follicular and papillary tumors in the thyroid within 60 days of diagnosis are a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String site1 = i1.getPrimarySite().toUpperCase();
                String site2 = i2.getPrimarySite().toUpperCase();
                String hist1 = i1.getHistology();
                String hist2 = i2.getHistology();
                if ("C569".equals(site1) && "C569".equals(site2) && Integer.parseInt(hist1) <= 8799 && Integer.parseInt(hist2) <= 8799) {
                    int sixtyDayApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                    if (-1 == sixtyDayApart) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessage("Unable to apply Rule " + this.getStep() + " of " + this.getGroupId() + ". There is no enough diagnosis date information.");
                    } else if (0 == sixtyDayApart) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there bilateral epithelial tumors (8000-8799) of the ovary within 60 days of diagnosis?");
        rule.setReason("Bilateral epithelial tumors (8000-8799) of the ovary within 60 days are a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> pairedSites = Arrays.asList("C384", "C400", "C401", "C402", "C403", "C413", "C414", "C441", "C442", "C443", "C445", "C446", "C447", "C471", "C472", "C491", "C492", "C569", "C570", "C620-C629", "C630", "C631", "C690-C699", "C740-C749", "C754");
                if (GroupUtility.isPairedSites(i1.getPrimarySite(), i2.getPrimarySite(), pairedSites)) {
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                        result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in both the left and right sides of a paired site (Table 1)?");
        rule.setReason("Tumors on both sides (right and left) of a site listed in Table 1 are multiple primaries.");
        rule.getNotes().add("See Table 1: Paired Organs and Sites with Laterality");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M9"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                boolean isOneMalignant;
                TempRuleResult result = new TempRuleResult();
                String site1 = i1.getPrimarySite();
                String site2 = i2.getPrimarySite();
                String s1 = i1.getPrimarySite().substring(0, 3);
                String s2 = i2.getPrimarySite().substring(0, 3);
                boolean isSiteInRange = !(!"C18".equals(s1) && !"C199".equals(site1) && !"C209".equals(site1) || !"C18".equals(s2) && !"C199".equals(site2) && !"C209".equals(site2));
                boolean bl = isOneMalignant = "3".equals(i1.getBehavior()) || "3".equals(i2.getBehavior());
                if (isSiteInRange && isOneMalignant && GroupUtility.differentCategory(i1.getHistology(), i2.getHistology(), MphConstants.FAMILIAL_ADENOMATOUS_POLYPOSIS, MphConstants.POLYP)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is the diagnosis adenocarcinoma in adenomatous polyposis coli (familialpolyposis ) with one or more malignant polyps?");
        rule.setReason("Adenocarcinoma in adenomatous polyposis coli (familial polyposis) with one or more in situ or malignant polyps is a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M10"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                int diff = GroupUtility.verifyYearsApart(i1, i2, 1);
                if (-1 == diff) {
                    result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    result.setMessage("Unable to apply Rule " + this.getStep() + " of " + this.getGroupId() + ". There is no enough diagnosis date information.");
                } else if (1 == diff) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors diagnosed more than one (1) year apart?");
        rule.setReason("Tumors diagnosed more than one (1) year apart are multiple primaries.");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("mp_2018_other_sites", "M11");
        rule.getExamples().add("A tumor in the penis C609 and a tumor in the rectum C209 have different second characters in their ICD-O-3 topography codes, so they are multiple primaries.");
        rule.getExamples().add("A tumor in the cervix C539 and a tumor in the vulva C519 have different third characters in their ICD-O-3 topography codes, so they are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M12"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> list = Arrays.asList("C21", "C40", "C41", "C47", "C49", "C44");
                if (list.contains(i1.getPrimarySite().substring(0, 3)) && i1.getPrimarySite().charAt(3) != i2.getPrimarySite().charAt(3)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors in sites with ICD-O-3 topography codes that differ at only the fourth character (Cxx?) and are in any one of the following primary sites:\nAnus and anal canal (C21_)\nBones, joints, and articular cartilage (C40_- C41_)\nPeripheral nerves and autonomic nervous system (C47_)\nConnective subcutaneous and other soft tissues (C49_)\nSkin (C44_)");
        rule.setReason("Tumors with ICD-O-3 topography codes that differ only at the fourth character (Cxx?) and are in any one of the following primary sites are multiple primaries.\nAnus and anal canal (C21_)\nBones, joints, and articular cartilage (C40_- C41_)\nPeripheral nerves and autonomic nervous system (C47_)\nConnective subcutaneous and other soft tissues (C49_)\nSkin (C44_)");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M13"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> insituOrMalignant = Arrays.asList("2", "3");
                ArrayList<String> adenocarcinoma = new ArrayList<String>(MphConstants.ADENOCARCINOMA_SPECIFIC);
                adenocarcinoma.addAll(MphConstants.ADENOCARCINOMA_NOS);
                if (insituOrMalignant.containsAll(Arrays.asList(i1.getBehavior(), i2.getBehavior())) && !MphConstants.POLYP.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology())) && GroupUtility.differentCategory(i1.getHistology(), i2.getHistology(), adenocarcinoma, MphConstants.POLYP)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is there a frank in situ or malignant adenocarcinoma and an in situ or malignant tumor in a polyp?");
        rule.setReason("A frank in situ or malignant adenocarcinoma and an in situ or malignant tumor in a polyp are a single primary.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M14"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> insituOrMalignant = Arrays.asList("2", "3");
                if (insituOrMalignant.containsAll(Arrays.asList(i1.getBehavior(), i2.getBehavior())) && MphConstants.POLYP.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there multiple in situ and/or malignant polyps?");
        rule.setReason("Multiple in situ and/or malignant polyps are a single primary.");
        rule.getNotes().add("Includes all combinations of adenomatous, tubular, villous, and tubulovillous adenomas or polyps.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("mp_2018_other_sites", "M15");
        rule.getNotes().add("The purpose of this rule is to ensure that the case is counted as an incident (invasive) case when incidence data are analyzed.");
        rule.getNotes().add("Abstract as multiple primaries even if the medical record/physician states it is recurrence or progression of disease.");
        this._rules.add(rule);
        rule = new MphRule("mp_2018_other_sites", "M16"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                String hist1 = i1.getHistology();
                String hist2 = i2.getHistology();
                List<String> nosList = Arrays.asList("8000", "8010", "8070", "8140", "8720", "8800");
                if (nosList.contains(hist1) && MphConstants.NOS_VS_SPECIFIC.containsKey(hist1) && MphConstants.NOS_VS_SPECIFIC.get(hist1).contains(hist2) || nosList.contains(hist2) && MphConstants.NOS_VS_SPECIFIC.containsKey(hist2) && MphConstants.NOS_VS_SPECIFIC.get(hist2).contains(hist1)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Is there cancer/malignant neoplasm, NOS (8000) and another is a specific histology? or\nIs there carcinoma, NOS (8010) and another is a specific carcinoma? or\nIs there squamous cell carcinoma, NOS (8070) and another is a specific squamous cell carcinoma? or\nIs there adenocarcinoma, NOS (8140) and another is a specific adenocarcinoma? or\nIs there melanoma, NOS (8720) and another is a specific melanoma? or\nIs there sarcoma, NOS (8800) and another is a specific sarcoma?");
        rule.setReason("Abstract as a single primary* when one tumor is:\n- Cancer/malignant neoplasm, NOS (8000) and another is a specific histology or\n- Carcinoma, NOS (8010) and another is a specific carcinoma or\n- Squamous cell carcinoma, NOS (8070) and another is specific squamous cell carcinoma or\n- Adenocarcinoma, NOS (8140) and another is a specific adenocarcinoma or\n- Melanoma, NOS (8720) and another is a specific melanoma or\n- Sarcoma, NOS (8800) and another is a specific sarcoma");
        this._rules.add(rule);
        rule = new MpRuleHistology("mp_2018_other_sites", "M17");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2018_other_sites", "M18");
        rule.getNotes().add("When an invasive tumor follows an in situ tumor within 60 days, abstract as a single primary.");
        this._rules.add(rule);
    }

    @Override
    public boolean isApplicable(String primarySite, String histology, String behavior, int year) {
        if (GroupUtility.isContained(GroupUtility.computeRange(this._histExclusions, false), Integer.parseInt(histology)) || !this._behavInclusions.contains(behavior) || !GroupUtility.isContained(GroupUtility.computeRange(this._yearInclusions, false), year) || !GroupUtility.validateProperties(primarySite, histology, behavior, year)) {
            return false;
        }
        ArrayList<MphGroup> specificGroups = new ArrayList<MphGroup>();
        specificGroups.add(new Mp2018BreastGroup());
        specificGroups.add(new Mp2018ColonGroup());
        specificGroups.add(new Mp2007MelanomaGroup());
        specificGroups.add(new Mp2018HeadAndNeckGroup());
        specificGroups.add(new Mp2018KidneyGroup());
        specificGroups.add(new Mp2018LungGroup());
        specificGroups.add(new Mp2018MalignantCNSAndPeripheralNervesGroup());
        specificGroups.add(new Mp2018NonMalignantCNSTumorsGroup());
        specificGroups.add(new Mp2018UrinarySitesGroup());
        specificGroups.add(new Mp2021CutaneousMelanomaGroup());
        specificGroups.add(new Mp2022BreastGroup());
        specificGroups.add(new Mp2022ColonGroup());
        specificGroups.add(new Mp2022HeadAndNeckGroup());
        specificGroups.add(new Mp2022KidneyGroup());
        specificGroups.add(new Mp2022MalignantCNSAndPeripheralNervesGroup());
        for (MphGroup group : specificGroups) {
            if (!group.isApplicable(primarySite, histology, behavior, year)) continue;
            return false;
        }
        return true;
    }
}

