/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Mp2021CutaneousMelanomaGroup
extends MphGroup {
    public Mp2021CutaneousMelanomaGroup() {
        super("mp_2021_cutaneous_melanoma", "2021 Cutaneous Melanoma", "C440-C449", null, "8720-8780", null, "2-3,6", "2021-9999");
        MphRule rule = new MphRule("mp_2021_cutaneous_melanoma", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (i1.getPrimarySite().equals("C449") || i2.getPrimarySite().equals("C449")) {
                    result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    result.setMessage("Unable to apply Rule " + this.getStep() + " of " + this.getGroupId() + ". One of the sites is C449.");
                } else if (!i1.getPrimarySite().equals(i2.getPrimarySite())) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there melanomas in sites with ICD-O-3 topography codes that are different at the second (C?xx) , third (Cx?x) and/or fourth (C44?) character?");
        rule.setReason("Melanomas in sites with ICD-O-3 topography codes that are different at the second (C?xx), third (Cx?x) or fourth (C44?) character are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2021_cutaneous_melanoma", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                List<String> lateralityNotRequiredSites = Arrays.asList("C440", "C448", "C449");
                if (lateralityNotRequiredSites.contains(i1.getPrimarySite()) || "9".equals(i1.getLaterality()) || "9".equals(i2.getLaterality()) || StringUtils.isEmpty((CharSequence)i1.getLaterality()) || StringUtils.isEmpty((CharSequence)i2.getLaterality())) {
                    return result;
                }
                if (!Arrays.asList("1", "2", "5").containsAll(Arrays.asList(i1.getLaterality(), i2.getLaterality()))) {
                    result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                } else if (!i1.getLaterality().equals(i2.getLaterality())) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Do the melanomas have different lateralities?");
        rule.setReason("Abstract multiple primaries when there are separate, non-contiguous melanomas with different lateralities.");
        rule.getExamples().add("A midline melanoma is a different laterality than right or left.");
        rule.getExamples().add("If the laterality of one or both melanomas is unknown, then continue through the rules");
        rule.getExamples().add("If one or more of the sites is not in the required laterality table, then continue through the rules. See Table 1.");
        rule.getExamples().add("Melanoma of the right side of the chest and a melanoma at midline of the chest are different laterality, multiple primaries.");
        rule.getExamples().add("A melanoma of the right side of the chest and a melanoma of the left side of the chest are multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2021_cutaneous_melanoma", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String subtype2;
                TempRuleResult result = new TempRuleResult();
                String subtype1 = MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.containsKey(i1.getHistology()) ? MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.get(i1.getHistology()) : MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.get(i1.getIcdCode());
                String string = subtype2 = MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.containsKey(i2.getHistology()) ? MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.get(i2.getHistology()) : MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES.get(i2.getIcdCode());
                if (subtype1 != null && subtype2 != null && !subtype1.equals(subtype2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors different subtypes/variants in Column 3, Table 2?");
        rule.setReason("Abstract multiple primaries when separate/non-contiguous tumors are two or more different subtypes/variants in Column 3, Table 2 in the Equivalent Terms and Definitions.");
        rule.getExamples().add("Epithelioid cell melanoma 8771/3 and nodular melanoma 8721/3 are both subtypes/variants of melanoma, NOS 8720/3");
        this._rules.add(rule);
        rule = new MphRule("mp_2021_cutaneous_melanoma", "M6"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                boolean icd2InTable;
                TempRuleResult result = new TempRuleResult();
                boolean icd1InTable = MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_ROWS.contains(i1.getHistology()) || MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_ROWS.contains(i1.getIcdCode());
                boolean bl = icd2InTable = MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_ROWS.contains(i2.getHistology()) || MphConstants.CUTANEOUS_MELANOMA_2021_TABLE2_ROWS.contains(i2.getIcdCode());
                if (icd1InTable && icd2InTable) {
                    List<String> lateralityNotRequiredSites = Arrays.asList("C440", "C448", "C449");
                    if (!lateralityNotRequiredSites.contains(i1.getPrimarySite()) && !Arrays.asList("1", "2", "5").containsAll(Arrays.asList(i1.getLaterality(), i2.getLaterality()))) {
                        result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                        result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                        return result;
                    }
                    if (lateralityNotRequiredSites.contains(i1.getPrimarySite()) || i1.getLaterality().equals(i2.getLaterality())) {
                        int sixtyDaysApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                        if (-1 == sixtyDaysApart) {
                            result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                            result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                        } else if (0 == sixtyDaysApart) {
                            result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        }
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are tumors synchronous, on the same row in Table 2 and have same site and laterality?");
        rule.setReason("Abstract a single primary when synchronous, separate/non-contiguous tumors are on the same row in Table 2 in the Equivalent Terms and Definitions. And they have same site and laterality.");
        this._rules.add(rule);
        rule = new MphRule("mp_2021_cutaneous_melanoma", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                int sixtyDaysApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                if (-1 == sixtyDaysApart) {
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                } else if (1 == sixtyDaysApart) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there melanomas diagnosed more than 60 days apart?");
        rule.setReason("Melanomas diagnosed more than 60 days apart are multiple primaries.");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2021_cutaneous_melanoma", "M8");
        rule.setReason("Melanomas that do not meet any of the above criteria are abstracted as a single primary.");
        rule.getNotes().add("Use the data item \"Multiplicity Counter\" to record the number of melanomas abstracted as a single primary.");
        rule.getNotes().add("When an invasive melanoma follows an in situ melanoma within 60 days, abstract as a single primary.");
        rule.getNotes().add("All cases covered by this rule are the same site and histology.");
        this._rules.add(rule);
    }
}

