/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleInsituAfterInvasiveSameSide;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituLessThan60DaysSameSide;
import com.imsweb.mph.mprules.MpRuleLaterality;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRuleThreeYearsApart;

public class Mp2022KidneyGroup
extends MphGroup {
    public Mp2022KidneyGroup() {
        super("mp_2022_kidney", "2022 Kidney", "C649", null, null, "9590-9992, 9140", "2-3,6", "2022-9999");
        MphRule rule = new MphRule("mp_2022_kidney", "M3"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if (!i1.getPrimarySite().equals(i2.getPrimarySite())) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.getNotes().add("When codes differ at the second, third, or fourth characters, the tumors are in different primary sites.");
        this._rules.add(rule);
        rule = new MphRule("mp_2022_kidney", "M4"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                TempRuleResult result = new TempRuleResult();
                if ("3".equals(i1.getBehavior()) && "3".equals(i2.getBehavior()) && "8960".equals(i1.getHistology()) && "8960".equals(i2.getHistology())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there bilateral nephroblastomas (previously called Wilms tumors)?");
        rule.setReason("Bilateral nephroblastomas are a single primary.");
        rule.getNotes().add("Timing is irrelevant; the tumors may occur simultaneously OR the contralateral tumor may be diagnosed later (no time limit)");
        this._rules.add(rule);
        rule = new MpRuleLaterality("mp_2022_kidney", "M5");
        rule.setQuestion("Are there tumors in both the left and right kidney?");
        rule.setReason("Tumors in both the right kidney and in the left kidney are multiple primaries.");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("ONLY abstract a single primary when pathology proves the tumor(s) in one kidney is/are metastatic from the other kidney.");
        this._rules.add(rule);
        rule = new MpRuleThreeYearsApart("mp_2022_kidney", "M6");
        rule.getNotes().add("Clinically disease-free means that there was no evidence of recurrence on follow-up.");
        rule.getNotes().add("  - Scans are NED");
        rule.getNotes().add("  - Urine cytology is negative");
        rule.getNotes().add("  - All other work-up is NED");
        rule.getNotes().add("When there is a recurrence less than or equal to three years of diagnosis, the \"clock\" starts over. The time interval is calculated from the date of last recurrence. In other words, the patient must have been disease-free for greater than three years from the date of the last recurrence.");
        rule.getNotes().add("When it is unknown/not documented whether the patient had a recurrence, default to date of diagnosis to compute the time interval.");
        rule.getNotes().add("The physician may state this is a recurrence, meaning the patient had a previous kidney tumor and now has another kidney tumor. Follow the rules; do not attempt to interpret the physician\u2019s statement.");
        rule.getNotes().add("The location and histology of the subsequent tumor is irrelevant. Kidney tumors that occur more than 3 years apart are always multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2022_kidney", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String subtype2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String subtype1 = MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.containsKey(h1) ? MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.get(h1) : MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.get(icd1);
                String string = subtype2 = MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.containsKey(h2) ? MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.get(h2) : MphConstants.KIDNEY_2018_TABLE1_SUBTYPES.get(icd2);
                if (subtype1 != null && subtype2 != null && !subtype1.contains(subtype2) && !subtype2.contains(subtype1)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors two or more different subtypes/variants in Column 3, Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney)?");
        rule.setReason("Separate/non-contiguous tumors that are two or more different subtypes/variants in Column 3, Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney), are multiple primaries.");
        rule.getNotes().add("Note: The tumors may be subtypes/variants of the same or different NOS histologies.");
        rule.getNotes().add("- Same NOS: Clear cell renal cell carcinoma (ccRCC) 8310/3 and papillary renal cell carcinoma 8260/3 are both subtypes of renal cell carcinoma NOS 8312/3 but are distinctly different histologies. Abstract multiple primaries.");
        rule.getNotes().add("- Different NOS: Pleomorphic rhabdomyosarcoma 8901/3 is a subtype/variant of rhabdomyosarcoma 8900/3; large cell neuroendocrine carcinoma 8013/3 is a subtype of small cell neuroendocrine tumor 8041/3. They are distinctly different histologies. Abstract multiple primaries.");
        this._rules.add(rule);
        rule = new MphRule("mp_2022_kidney", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.KIDNEY_2018_TABLE1_ROWS.containsKey(h1) ? MphConstants.KIDNEY_2018_TABLE1_ROWS.get(h1) : MphConstants.KIDNEY_2018_TABLE1_ROWS.get(icd1);
                String string = row2 = MphConstants.KIDNEY_2018_TABLE1_ROWS.containsKey(h2) ? MphConstants.KIDNEY_2018_TABLE1_ROWS.get(h2) : MphConstants.KIDNEY_2018_TABLE1_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (row1.equals(row2)) {
                    int sixtyDaysApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                    if (1 == sixtyDaysApart) {
                        return result;
                    }
                    if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        if (-1 == sixtyDaysApart) {
                            result.setMessageUnknownLatAndDate(this.getStep(), this.getGroupId());
                        } else {
                            result.setMessageUnknownLaterality(this.getStep(), this.getGroupId());
                        }
                    } else if (-1 == sixtyDaysApart) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
                    } else if (GroupUtility.areSameSide(i1.getLaterality(), i2.getLaterality())) {
                        if ("8311".equals(h1) && h1.equals(h2)) {
                            result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                            result.setMessage("8311 can be abstracted as multiple primaries if you have any of the following combinations (all coded 8311):\n- MiT family translocation renal cell carcinoma and Hereditary leiomyomatosis\n- MiT family translocation renal cell carcinoma and Renal cell carcinoma-associated renal cell carcinoma\n- MiT family translocation renal cell carcinoma and Succinate dehydrogenase-deficient renal cell carcinoma (SDHS)\n- Hereditary leiomyomatosis and Succinate dehydrogenase-deficient renal cell carcinoma (SDHS)\n- Renal cell carcinoma-associated renal cell carcinoma and Succinate dehydrogenase-deficient renal cell carcinoma (SDHS)");
                        } else {
                            result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        }
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are synchronous, separate/non-contiguous tumors on the same row in Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney)?");
        rule.setReason("Synchronous, separate/non-contiguous tumors that are on the same row in Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney), are multiple primaries.");
        rule.getNotes().add("The same row means the tumors are:");
        rule.getNotes().add("  - The same histology (same four-digit ICD-O code) OR");
        rule.getNotes().add("  - One is the preferred term (column 1) and the other is a synonym for the preferred term (column 2) OR");
        rule.getNotes().add("  - A NOS (column 1/column 2) and the other is a subtype/variant of that NOS (column 3)");
        this._rules.add(rule);
        rule = new MphRule("mp_2022_kidney", "M9"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2) {
                String row2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = h1 + "/" + i1.getBehavior();
                String h2 = i2.getHistology();
                String icd2 = h2 + "/" + i2.getBehavior();
                String row1 = MphConstants.KIDNEY_2018_TABLE1_ROWS.containsKey(h1) ? MphConstants.KIDNEY_2018_TABLE1_ROWS.get(h1) : MphConstants.KIDNEY_2018_TABLE1_ROWS.get(icd1);
                String string = row2 = MphConstants.KIDNEY_2018_TABLE1_ROWS.containsKey(h2) ? MphConstants.KIDNEY_2018_TABLE1_ROWS.get(h2) : MphConstants.KIDNEY_2018_TABLE1_ROWS.get(icd2);
                if (row1 == null || row2 == null) {
                    String histologyNotInTable;
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    boolean bothNotInTable = false;
                    if (row1 == null && row2 == null) {
                        bothNotInTable = true;
                        histologyNotInTable = "Both " + icd1 + " and " + icd2;
                    } else {
                        histologyNotInTable = row1 == null ? icd1 : icd2;
                    }
                    result.setMessageNotInTable(this.getStep(), this.getGroupId(), histologyNotInTable, bothNotInTable);
                } else if (!row1.equals(row2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors on different rows in Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney)?");
        rule.setReason("Separate/non-contiguous tumors that are on different rows in Table 1 in the Equivalent Terms and Definitions (Tumors must be in the same kidney), are multiple primaries.");
        rule.getNotes().add("Each row in the table is a distinctly different histology.");
        this._rules.add(rule);
        rule = new MpRuleInsituAfterInvasiveSameSide("mp_2022_kidney", "M10");
        rule.setQuestion("Is there an in situ tumor following an invasive tumor and tumors are in the same kidney?");
        rule.setReason("An in situ tumor diagnosed following an invasive tumor and tumors are in the same kidney is a single primary.");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("The tumors may be a NOS and a subtype/variant of that NOS. See Table 1 in the Equivalent Terms and Definitions for listings of NOS and subtype/variants.");
        rule.getNotes().add("Once the patient has an invasive tumor, the in situ is recorded as a recurrence for those registrars who collect recurrence data.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituLessThan60DaysSameSide("mp_2022_kidney", "M11");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("The tumors may be a NOS and a subtype/variant of that NOS.");
        rule.getNotes().add("When the case has been abstracted, change behavior code on original abstract from /2 to /3.");
        rule.getNotes().add("Do not change date of diagnosis.");
        rule.getNotes().add("If the case has already been submitted to the central registry, report all changes.");
        rule.getNotes().add("The physician may stage both tumors because staging and determining multiple primaries are done for different reasons. Staging determines which treatment would be most effective. Determining multiple primaries is done to stabilize the data for the study of epidemiology (long-term studies done on incidence, mortality, and causation of a disease with the goal of reducing or eliminating that disease).");
        rule.getNotes().add("See the COC and SEER manuals for instructions on coding other data items such as Date of Diagnosis, Accession Year and Sequence Number.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("mp_2022_kidney", "M12");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when none of the previous rules apply.");
        rule.getNotes().add("Abstract both the invasive and in situ tumors.");
        rule.getNotes().add("Abstract as multiple primaries even if physician states the invasive tumor is disease recurrence or progression.");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("mp_2022_kidney", "M13");
        rule.getNotes().add("Use this rule as a last resort.  Please confirm that you have not overlooked an applicable rule.");
        rule.getExamples().add("Patient presents in 2018 with renal cell carcinoma in the right kidney.  Patient has a history of a previous renal cell carcinoma in the right kidney diagnosed in 2016.  This is a single primary because it is the same primary site and the same histology.");
        rule.getExamples().add("Patient presents in 2020 with a clear cell renal cell carcinoma 8310/3 in the left kidney.  The patient was diagnosed with renal cell carcinoma 8312/3 in 2018.  This is a single primary because it is the same primary site and a NOS and subtype/variant of that NOS.");
        this._rules.add(rule);
    }
}

