/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Collections;

public class MpRuleInsituAfterInvasive
extends MphRule {
    public MpRuleInsituAfterInvasive(String groupId, String step) {
        super(groupId, step);
        this.setQuestion("Is there an in situ tumor following an invasive tumor?");
        this.setReason("An in situ tumor diagnosed following an invasive tumor is a single primary.");
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2) {
        String beh2;
        TempRuleResult result = new TempRuleResult();
        String beh1 = i1.getBehavior();
        if (GroupUtility.differentCategory(beh1, beh2 = i2.getBehavior(), Collections.singletonList("2"), Collections.singletonList("3"))) {
            int latestDx = GroupUtility.compareDxDate(i1, i2);
            if (-1 == latestDx) {
                result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupId());
            } else if (1 == latestDx && "2".equals(beh1) || 2 == latestDx && "2".equals(beh2)) {
                result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
            }
        }
        return result;
    }
}

