/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphInput;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class GroupUtility {
    private GroupUtility() {
    }

    public static boolean validateProperties(String primarySite, String histology, String behavior, int year) {
        return GroupUtility.validateSite(primarySite) && GroupUtility.validateHistology(histology) && GroupUtility.validateBehavior(behavior) && GroupUtility.validateYear(year);
    }

    public static boolean validateSite(String site) {
        return site != null && site.length() == 4 && site.startsWith("C") && NumberUtils.isDigits((String)site.substring(1)) && !"C809".equalsIgnoreCase(site);
    }

    public static boolean validateHistology(String hist) {
        return NumberUtils.isDigits((String)hist) && Integer.parseInt(hist) >= 8000 && Integer.parseInt(hist) <= 9999;
    }

    public static boolean validateBehavior(String behavior) {
        return Arrays.asList("0", "1", "2", "3", "6").contains(behavior);
    }

    public static boolean validateYear(int year) {
        return year >= 0 && year <= LocalDate.now().getYear();
    }

    public static boolean sameValidDates(Integer year1, Integer month1, Integer day1, Integer year2, Integer month2, Integer day2) {
        if (year1 == null || year2 == null || month1 == null || month2 == null || day1 == null || day2 == null) {
            return false;
        }
        try {
            return LocalDate.of((int)year1, month1, (int)day1).isEqual(LocalDate.of((int)year2, month2, (int)day2));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean sameHistologies(String icd1, String icd2) {
        return icd1 != null && icd1.equals(icd2) && !icd1.startsWith("8000") && !icd1.startsWith("8010");
    }

    public static boolean sameKnownDateParts(MphInput i1, MphInput i2) {
        DateFieldParts date = new DateFieldParts(i1, i2);
        return date.getYear1() != null && date.getYear1().equals(date.getYear2()) && (date.getMonth1() == null || date.getMonth2() == null || date.getMonth1().equals(date.getMonth2()) && (date.getDay1() == null || date.getDay2() == null || date.getDay1().equals(date.getDay2())));
    }

    public static boolean isContained(List<Range<Integer>> list, Integer value) {
        if (list != null && !list.isEmpty()) {
            for (Range<Integer> range : list) {
                if (!range.contains((Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Range<Integer>> computeRange(String rawValue, boolean isSite) {
        if (rawValue == null) {
            return Collections.emptyList();
        }
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        for (String item : StringUtils.split((String)rawValue, (char)',')) {
            String[] parts = StringUtils.split((String)item.trim(), (char)'-');
            if (parts.length == 1) {
                if (isSite) {
                    result.add((Range<Integer>)Range.is((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim().substring(1)))));
                    continue;
                }
                result.add((Range<Integer>)Range.is((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim()))));
                continue;
            }
            if (isSite) {
                result.add((Range<Integer>)Range.of((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim().substring(1))), (Comparable)Integer.valueOf(Integer.parseInt(parts[1].trim().substring(1)))));
                continue;
            }
            result.add((Range<Integer>)Range.of((Comparable)Integer.valueOf(Integer.parseInt(parts[0].trim())), (Comparable)Integer.valueOf(Integer.parseInt(parts[1].trim()))));
        }
        return result;
    }

    public static List<String> expandList(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (String item : list) {
            String[] ranges;
            for (String range : ranges = StringUtils.split((String)item.trim(), (char)',')) {
                String[] parts = StringUtils.split((String)range.trim(), (char)'-');
                if (parts.length <= 1) {
                    result.add(range);
                    continue;
                }
                int start = Integer.parseInt(parts[0]);
                int end = Integer.parseInt(parts[1]);
                while (start <= end) {
                    result.add(String.valueOf(start++));
                }
            }
        }
        return result;
    }

    public static List<String> expandList(String rawValue) {
        return GroupUtility.expandList(Collections.singletonList(rawValue));
    }

    public static boolean isSiteContained(String list, String site) {
        return GroupUtility.isContained(GroupUtility.computeRange(list, true), Integer.valueOf(site.substring(1)));
    }

    public static boolean differentCategory(String prop1, String prop2, List<String> cat1, List<String> cat2) {
        return cat1 != null && cat2 != null && !cat1.isEmpty() && !cat2.isEmpty() && (cat1.contains(prop1) && cat2.contains(prop2) || cat1.contains(prop2) && cat2.contains(prop1));
    }

    public static boolean isPairedSites(String site1, String site2, List<String> pairedSites) {
        if (pairedSites != null && !pairedSites.isEmpty()) {
            for (String pairedSite : pairedSites) {
                if (!GroupUtility.isContained(GroupUtility.computeRange(pairedSite, true), Integer.parseInt(site1.substring(1))) || !GroupUtility.isContained(GroupUtility.computeRange(pairedSite, true), Integer.parseInt(site2.substring(1)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean validPairedSiteLaterality(String lat1, String lat2) {
        return !(!"1".equals(lat1) && !"2".equals(lat1) || !"1".equals(lat2) && !"2".equals(lat2));
    }

    public static boolean validateLaterality(String lat) {
        return Arrays.asList("0", "1", "2", "3", "4", "5", "9").contains(lat);
    }

    public static boolean areOppositeSides(String lat1, String lat2) {
        return "1".equals(lat1) && "2".equals(lat2) || "1".equals(lat2) && "2".equals(lat1);
    }

    public static boolean areSameSide(String lat1, String lat2) {
        return "1".equals(lat1) && "1".equals(lat2) || "2".equals(lat2) && "2".equals(lat1);
    }

    public static boolean sameAndValidMainFields(MphInput i1, MphInput i2) {
        DateFieldParts date = new DateFieldParts(i1, i2);
        String site1 = i1.getPrimarySite();
        String site2 = i2.getPrimarySite();
        String hist1 = i1.getHistology();
        String hist2 = i2.getHistology();
        String beh1 = i1.getBehavior();
        String beh2 = i2.getBehavior();
        String lat1 = i1.getLaterality();
        String lat2 = i2.getLaterality();
        return date.getYear1() != null && date.getYear2() != null && GroupUtility.validateProperties(site1, hist1, beh1, date.getYear1()) && GroupUtility.validateProperties(site2, hist2, beh2, date.getYear2()) && GroupUtility.validateLaterality(lat1) && GroupUtility.validateLaterality(lat2) && Objects.equals(site1, site2) && Objects.equals(hist1, hist2) && Objects.equals(beh1, beh2) && GroupUtility.sameValidDates(date.getYear1(), date.getMonth1(), date.getDay1(), date.getYear2(), date.getMonth2(), date.getDay2()) && Objects.equals(lat1, lat2);
    }

    public static int compareDxDate(MphInput input1, MphInput input2) {
        DateFieldParts date = new DateFieldParts(input1, input2);
        int currYear = LocalDate.now().getYear();
        if (date.getYear1() == null || date.getYear2() == null || date.getYear1() > currYear || date.getYear2() > currYear) {
            return -1;
        }
        if (date.getYear1() > date.getYear2()) {
            return 1;
        }
        if (date.getYear2() > date.getYear1()) {
            return 2;
        }
        if (date.getMonth1() == null || date.getMonth2() == null) {
            return -1;
        }
        if (date.getMonth1() > date.getMonth2()) {
            return 1;
        }
        if (date.getMonth2() > date.getMonth1()) {
            return 2;
        }
        if (date.getDay1() == null || date.getDay2() == null) {
            return -1;
        }
        if (date.getDay1() > date.getDay2()) {
            return 1;
        }
        if (date.getDay2() > date.getDay1()) {
            return 2;
        }
        return 0;
    }

    public static int verifyYearsApart(MphInput input1, MphInput input2, int yearsApart) {
        DateFieldParts date = new DateFieldParts(input1, input2);
        int currYear = LocalDate.now().getYear();
        if (date.getYear1() == null || date.getYear2() == null || date.getYear1() > currYear || date.getYear2() > currYear) {
            return -1;
        }
        if (Math.abs(date.getYear1() - date.getYear2()) > yearsApart) {
            return 1;
        }
        if (Math.abs(date.getYear1() - date.getYear2()) < yearsApart) {
            return 0;
        }
        if (date.getMonth1() == null || date.getMonth2() == null) {
            return -1;
        }
        if (date.getYear1() > date.getYear2() && date.getMonth1() > date.getMonth2() || date.getYear2() > date.getYear1() && date.getMonth2() > date.getMonth1()) {
            return 1;
        }
        if (date.getYear1() > date.getYear2() && date.getMonth1() < date.getMonth2() || date.getYear2() > date.getYear1() && date.getMonth2() < date.getMonth1()) {
            return 0;
        }
        if (date.getDay1() == null || date.getDay2() == null) {
            return -1;
        }
        return Math.abs(ChronoUnit.YEARS.between(LocalDate.of((int)date.getYear1(), date.getMonth1(), (int)date.getDay1()), LocalDate.of((int)date.getYear2(), date.getMonth2(), (int)date.getDay2()))) >= (long)yearsApart ? 1 : 0;
    }

    public static int verifyDaysApart(MphInput input1, MphInput input2, int days) {
        int latestDx = GroupUtility.compareDxDate(input1, input2);
        if (latestDx == 0) {
            return 0;
        }
        DateFieldParts date = new DateFieldParts(input1, input2);
        int currYear = LocalDate.now().getYear();
        if (date.getYear1() == null || date.getYear2() == null || date.getYear1() > currYear || date.getYear2() > currYear) {
            return -1;
        }
        int minDaysInBetween = GroupUtility.daysInBetween(date.getYear2(), date.getMonth2(), date.getDay2(), date.getYear1(), date.getMonth1(), date.getDay1(), true);
        int maxDaysInBetween = GroupUtility.daysInBetween(date.getYear2(), date.getMonth2(), date.getDay2(), date.getYear1(), date.getMonth1(), date.getDay1(), false);
        if (-1 == latestDx) {
            return Math.max(Math.abs(minDaysInBetween), Math.abs(maxDaysInBetween)) <= days ? 0 : -1;
        }
        if (2 == latestDx) {
            minDaysInBetween = GroupUtility.daysInBetween(date.getYear1(), date.getMonth1(), date.getDay1(), date.getYear2(), date.getMonth2(), date.getDay2(), true);
            maxDaysInBetween = GroupUtility.daysInBetween(date.getYear1(), date.getMonth1(), date.getDay1(), date.getYear2(), date.getMonth2(), date.getDay2(), false);
        }
        if (minDaysInBetween > days) {
            return 1;
        }
        if (maxDaysInBetween <= days) {
            return 0;
        }
        return -1;
    }

    private static int daysInBetween(Integer startYr, Integer startMon, Integer startDay, Integer endYr, Integer endMon, Integer endDay, boolean minimum) {
        LocalDate startDateMin = LocalDate.of((int)startYr, 1, 1);
        LocalDate startDateMax = LocalDate.of((int)startYr, 12, 31);
        LocalDate endDateMin = LocalDate.of((int)endYr, 1, 1);
        LocalDate endDateMax = LocalDate.of((int)endYr, 12, 31);
        if (startDay != null) {
            startDateMin = LocalDate.of((int)startYr, startMon, (int)startDay);
            startDateMax = LocalDate.of((int)startYr, startMon, (int)startDay);
        } else if (startMon != null) {
            startDateMin = LocalDate.of((int)startYr, startMon, 1);
            startDateMax = LocalDate.of((int)startYr, startMon, YearMonth.of((int)startYr, startMon).lengthOfMonth());
        }
        if (endDay != null) {
            endDateMin = LocalDate.of((int)endYr, endMon, (int)endDay);
            endDateMax = LocalDate.of((int)endYr, endMon, (int)endDay);
        } else if (endMon != null) {
            endDateMin = LocalDate.of((int)endYr, endMon, 1);
            endDateMax = LocalDate.of((int)endYr, endMon, YearMonth.of((int)endYr, endMon).lengthOfMonth());
        }
        return minimum ? (int)ChronoUnit.DAYS.between(startDateMax, endDateMin) : (int)ChronoUnit.DAYS.between(startDateMin, endDateMax);
    }

    public static String getSiteHistInfo(String site, String hist, String beh, int year) {
        return (StringUtils.isBlank((CharSequence)site) ? "Unknown Site" : site) + ", " + (StringUtils.isBlank((CharSequence)hist) ? "Unknown Histology" : hist) + "/" + (StringUtils.isBlank((CharSequence)beh) ? "Unknown Behavior" : beh) + " " + (String)(GroupUtility.validateYear(year) ? "with year of diagnosis " + year : "with unknown year of diagnosis");
    }

    static class DateFieldParts {
        private final Integer _year1;
        private Integer _month1;
        private Integer _day1;
        private final Integer _year2;
        private Integer _month2;
        private Integer _day2;

        public DateFieldParts(MphInput input1, MphInput input2) {
            this._year1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisYear()) ? Integer.valueOf(Integer.parseInt(input1.getDateOfDiagnosisYear())) : null;
            this._year2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisYear()) ? Integer.valueOf(Integer.parseInt(input2.getDateOfDiagnosisYear())) : null;
            Integer n = this._month1 = NumberUtils.isDigits((String)input1.getDateOfDiagnosisMonth()) ? Integer.valueOf(Integer.parseInt(input1.getDateOfDiagnosisMonth())) : null;
            if (this._month1 != null && (this._month1 < 1 || this._month1 > 12)) {
                this._month1 = null;
            }
            Integer n2 = this._month2 = NumberUtils.isDigits((String)input2.getDateOfDiagnosisMonth()) ? Integer.valueOf(Integer.parseInt(input2.getDateOfDiagnosisMonth())) : null;
            if (this._month2 != null && (this._month2 < 1 || this._month2 > 12)) {
                this._month2 = null;
            }
            Integer n3 = this._day1 = this._month1 != null && NumberUtils.isDigits((String)input1.getDateOfDiagnosisDay()) ? Integer.valueOf(Integer.parseInt(input1.getDateOfDiagnosisDay())) : null;
            if (this._year1 != null && this._day1 != null && (this._day1 < 1 || this._day1 > LocalDate.of((int)this._year1, this._month1, 1).lengthOfMonth())) {
                this._day1 = null;
            }
            Integer n4 = this._day2 = this._month2 != null && NumberUtils.isDigits((String)input2.getDateOfDiagnosisDay()) ? Integer.valueOf(Integer.parseInt(input2.getDateOfDiagnosisDay())) : null;
            if (this._year2 != null && this._day2 != null && (this._day2 < 1 || this._day2 > LocalDate.of((int)this._year2, this._month2, 1).lengthOfMonth())) {
                this._day2 = null;
            }
        }

        public Integer getYear1() {
            return this._year1;
        }

        public Integer getMonth1() {
            return this._month1;
        }

        public Integer getDay1() {
            return this._day1;
        }

        public Integer getYear2() {
            return this._year2;
        }

        public Integer getMonth2() {
            return this._month2;
        }

        public Integer getDay2() {
            return this._day2;
        }
    }
}

