/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph;

import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MphConstants {
    public static final String USE_FOR_MULTIPLE_RULES = "Use this rule only for multiple tumors.";
    public static final String TIMING_IS_IRRELEVANT = "Timing is irrelevant.";
    public static final String HISTOLOGY_IS_IRRELEVANT = "Histology is irrelevant.";
    public static final String HIERARCHICAL_RULES = "The rules are hierarchical. Only use this rule when none of the previous rules apply.";
    public static final String AND_CONNECTOR = " and ";
    public static final String TRANSFORMATION_NOTE = "Transformations to (acute neoplasms) and Transformations from (chronic neoplasms) are defined for each applicable histology in the database.";
    public static final String HODGKIN_NOTE = "For the purpose of using the rules, a non-Hodgkin lymphoma is any lymphoma (including the leukemia/lymphomas) not stated to be Hodgkin lymphoma, NOS or a type of Hodgkin lymphoma.\n - Hodgkin lymphomas are: 9650/-9653/3, 9655/3, 9659/3, 9663/3";
    public static final int COMPARE_DX_UNKNOWN = -1;
    public static final int COMPARE_DX_EQUAL = 0;
    public static final int COMPARE_DX_FIRST_LATEST = 1;
    public static final int COMPARE_DX_SECOND_LATEST = 2;
    public static final int DATE_VERIFY_UNKNOWN = -1;
    public static final int DATE_VERIFY_WITHIN = 0;
    public static final int DATE_VERIFY_APART = 1;
    public static final String HEMATO_2000_AND_EARLIER = "hemato_2000_and_earlier";
    public static final String HEMATO_2001_TO_2009 = "hemato_2001_to_2009";
    public static final String HEMATO_2010_AND_LATER = "hemato_2010_and_later";
    public static final String MP_2004_SOLID_MALIGNANT_GROUP_ID = "2006_and_earlier_solid_malignant";
    public static final String MP_2004_BENIGN_BRAIN_GROUP_ID = "2006_and_earlier_benign_brain";
    public static final String MPH_2007_BENIGN_BRAIN_GROUP_ID = "mph_2007_to_2017_benign_brain";
    public static final String MPH_2007_BREAST_GROUP_ID = "mph_2007_to_2017_breast";
    public static final String MPH_2007_COLON_GROUP_ID = "mph_2007_to_2017_colon";
    public static final String MPH_2007_HEAD_AND_NECK_GROUP_ID = "mph_2007_to_2017_head_and_neck";
    public static final String MPH_2007_KIDNEY_GROUP_ID = "mph_2007_to_2017_kidney";
    public static final String MPH_2007_LUNG_GROUP_ID = "mph_2007_to_2017_lung";
    public static final String MPH_2007_MALIGNANT_BRAIN_GROUP_ID = "mph_2007_to_2017_malignant_brain";
    public static final String MPH_2007_MELANOMA_GROUP_ID = "mph_2007_to_2017_melanoma";
    public static final String MPH_2007_OTHER_SITES_GROUP_ID = "mph_2007_to_2022_other_sites";
    public static final String MPH_2007_URINARY_GROUP_ID = "mph_2007_to_2017_urinary";
    public static final String STR_2018_AND_LATER_BREAST = "str_2018_and_later_breast";
    public static final String STR_2018_AND_LATER_COLON = "str_2018_and_later_colon";
    public static final String STR_2018_AND_LATER_HEAD_AND_NECK = "str_2018_and_later_head_and_neck";
    public static final String STR_2018_AND_LATER_KIDNEY = "str_2018_and_later_kidney";
    public static final String STR_2018_AND_LATER_LUNG = "str_2018_and_later_lung";
    public static final String STR_2018_AND_LATER_MALIGNANT_CNS = "str_2018_and_later_malignant_cns";
    public static final String STR_2018_AND_LATER_NON_MALIGNANT_CNS = "str_2018_and_later_non_malignant_cns";
    public static final String STR_2023_AND_LATER_OTHER_SITES = "str_2023_and_later_other_sites";
    public static final String STR_2018_AND_LATER_URINARY = "str_2018_and_later_urinary";
    public static final String STR_2021_AND_LATER_CUTANEOUS_MELANOMA = "str_2021_and_later_cutaneous_melanoma";
    public static final String HEMATOPOIETIC_AND_LYMPHOID_2000_AND_EARLIER = "Hematopoietic and Lymphoid 2000 and earlier";
    public static final String HEMATOPOIETIC_AND_LYMPHOID_2001_2009 = "Hematopoietic and Lymphoid 2001-2009";
    public static final String HEMATOPOIETIC_AND_LYMPHOID_2010 = "Hematopoietic and Lymphoid 2010+";
    public static final String MP_2004_SOLID_MALIGNANT = "2006 and earlier Solid Malignant";
    public static final String MP_2004_BENIGN_BRAIN = "2006 and earlier Benign Brain";
    public static final String MPH_2007_2017_BENIGN_BRAIN = "MPH 2007-2017 Benign Brain";
    public static final String MPH_2007_2017_BREAST = "MPH 2007-2017 Breast";
    public static final String MPH_2007_2017_COLON = "MPH 2007-2017 Colon";
    public static final String MPH_2007_2017_HEAD_AND_NECK = "MPH 2007-2017 Head and Neck";
    public static final String MPH_2007_2017_KIDNEY = "MPH 2007-2017 Kidney";
    public static final String MPH_2007_2017_LUNG = "MPH 2007-2017 Lung";
    public static final String MPH_2007_2017_MALIGNANT_BRAIN = "MPH 2007-2017 Malignant Brain";
    public static final String MPH_2007_2020_MELANOMA = "MPH 2007-2020 Melanoma";
    public static final String MPH_2007_2022_OTHER_SITES = "MPH 2007-2022 Other Sites";
    public static final String MPH_2007_2017_URINARY = "MPH 2007-2017 Urinary";
    public static final String SOLID_TUMOR_2018_BREAST = "Solid Tumor 2018+ Breast";
    public static final String SOLID_TUMOR_2018_COLON = "Solid Tumor 2018+ Colon";
    public static final String SOLID_TUMOR_2018_HEAD_AND_NECK = "Solid Tumor 2018+ Head And Neck";
    public static final String SOLID_TUMOR_2018_KIDNEY = "Solid Tumor 2018+ Kidney";
    public static final String SOLID_TUMOR_2018_LUNG = "Solid Tumor 2018+ Lung";
    public static final String SOLID_TUMOR_2018_MALIGNANT_CNS = "Solid Tumor 2018+ Malignant CNS";
    public static final String SOLID_TUMOR_2018_NON_MALIGNANT_CNS = "Solid Tumor 2018+ Non Malignant CNS";
    public static final String SOLID_TUMOR_2023_OTHER_SITES = "Solid Tumor 2023+ Other Sites";
    public static final String SOLID_TUMOR_2018_URINARY = "Solid Tumor 2018+ Urinary";
    public static final String SOLID_TUMOR_2021_CUTANEOUS_MELANOMA = "Solid Tumor 2021+ Cutaneous Melanoma";
    public static final String SMALL_BOWEL = "C17";
    public static final String COLON = "C18";
    public static final String RECTOSIGMOID = "C199";
    public static final String RECTUM = "C209";
    public static final String BREAST = "C50";
    public static final String OVARY = "C569";
    public static final String PROSTATE = "C619";
    public static final String RENAL_PELVIS = "C659";
    public static final String URETER = "C669";
    public static final String BLADDER = "C67";
    public static final String URETHRA = "C680";
    public static final String THYROID = "C739";
    public static final String LYMPH_NODE = "C77";
    public static final String PERITONEUM = "C482";
    public static final String FALLOPIAN = "C570";
    public static final String VAGINA = "C529";
    public static final List<String> EXACT_MATCH_SITES = Collections.unmodifiableList(Arrays.asList("C18", "C21", "C38", "C40", "C41", "C44", "C47", "C49"));
    public static final List<String> TONGUE = Collections.unmodifiableList(Arrays.asList("C01", "C02"));
    public static final List<String> MOUTH = Collections.unmodifiableList(Arrays.asList("C05", "C06"));
    public static final List<String> SALIVARY = Collections.unmodifiableList(Arrays.asList("C07", "C08"));
    public static final List<String> OROPHARYNX = Collections.unmodifiableList(Arrays.asList("C09", "C10"));
    public static final List<String> HYPOPHARYNX = Collections.unmodifiableList(Arrays.asList("C12", "C13"));
    public static final List<String> BILIARY = Collections.unmodifiableList(Arrays.asList("C23", "C24"));
    public static final List<String> SINUS = Collections.unmodifiableList(Arrays.asList("C30", "C31"));
    public static final List<String> LUNG = Collections.unmodifiableList(Arrays.asList("C33", "C34"));
    public static final String MEDIASTINUM = "C370-C383,C388";
    public static final String FEMALE_GENITAL = "C510-C529,C577-C579";
    public static final String OVARY_OR_FEMALE_GENITAL = "C569-C574";
    public static final List<String> MALE_GENITAL = Collections.unmodifiableList(Arrays.asList("C60", "C63"));
    public static final List<String> KIDNEY_OR_URINARY = Collections.unmodifiableList(Arrays.asList("C64", "C65", "C66", "C68"));
    public static final List<String> ENDOCRINE = Collections.unmodifiableList(Arrays.asList("C74", "C75"));
    public static final List<String> AORTIC_BODY = Collections.singletonList("C755");
    public static final List<String> CAROTIC_BODY = Collections.singletonList("C754");
    public static final List<String> UPPER_LIP = Collections.unmodifiableList(Arrays.asList("C000", "C003"));
    public static final List<String> LOWER_LIP = Collections.unmodifiableList(Arrays.asList("C001", "C004"));
    public static final List<String> UPPER_GUM = Collections.singletonList("C030");
    public static final List<String> LOWER_GUM = Collections.singletonList("C031");
    public static final List<String> NASAL_CAVITY = Collections.singletonList("C300");
    public static final List<String> MIDDLE_EAR = Collections.singletonList("C301");
    public static final List<String> SUBMANDIBULAR_GLAND = Collections.singletonList("C080");
    public static final List<String> SUBLINGUAL_GLAND = Collections.singletonList("C081");
    public static final List<String> HARD_PALATE = Collections.singletonList("C050");
    public static final List<String> SOFT_PALATE = Collections.singletonList("C051");
    public static final List<String> UVULA = Collections.singletonList("C052");
    public static final List<String> MAXILLARY_SINUS = Collections.singletonList("C310");
    public static final List<String> ETHMOID_SINUS = Collections.singletonList("C311");
    public static final List<String> FRONTAL_SINUS = Collections.singletonList("C312");
    public static final List<String> SPHENOID_SINUS = Collections.singletonList("C313");
    public static final List<String> GLOTTIS_AND_LARYNGEAL_SITES = Collections.unmodifiableList(Arrays.asList("C320", "C321", "C322", "C323"));
    public static final List<String> MAXILLA = Collections.singletonList("C410");
    public static final List<String> MANDIBLE = Collections.singletonList("C411");
    public static final List<String> POSTCRICOID = Collections.singletonList("C130");
    public static final List<String> HYPOPHARYNGEAL_ASPECT_OF_ARYEPIGLOTTIC_FOLD = Collections.singletonList("C131");
    public static final List<String> POSTERIOR_WALL_OF_HYPOPHARYNX = Collections.singletonList("C132");
    public static final String ALL_PAIRED_SITES = "C079,C080-C081,C090-C099,C300-C301,C310,C312,C340-C349,C384,C400-C403,C413-C414,C441-C443,C445-C447,C471-C472,C491-C492,C500-C509,C569,C570,C620-C629,C630-C631,C649,C659,C669,C690-C699,C700,C710-C714,C722-C725,C740-C749,C754";
    public static final String BENIGN = "0";
    public static final String UNCERTAIN = "1";
    public static final String INSITU = "2";
    public static final String MALIGNANT = "3";
    public static final String NOT_PAIRED = "0";
    public static final String RIGHT = "1";
    public static final String LEFT = "2";
    public static final String ONLY_ONE_SIDE_NS = "3";
    public static final String BOTH = "4";
    public static final String MID_LINE = "5";
    public static final String PAIRED_NO_INFORMATION = "9";
    public static final List<String> ANAPLASTIC_CARCINOMA = Collections.singletonList("8021/3");
    public static final List<String> OTHER_THYROID_HISTOLOGIES = Collections.unmodifiableList(Arrays.asList("8330/3", "8339/3", "8335/3", "8331/3", "8332/3", "8345/3", "8290/3", "8260/3", "8344/3", "8350/3", "8343/3", "8340/3", "8343/2", "8337/3"));
    public static final List<String> CARCINOMA_NOS = GroupUtility.expandList("8010");
    public static final List<String> CARCINOMA_SPECIFIC = GroupUtility.expandList("8000-8005,8011-8015,8020-8022,8030-8035,8041-8046,8050-8052,8070-8078,8080-8084,8090-8098,8102,8110,8120-8124,8130-8131,8140-8148,8150-8157,8160-8162,8170-8175,8180,8190,8200-8201,8210-8211,8214-8215,8220-8221,8230-8231,8240-8247,8249,8250-8256,8260-8263,8270-8272,8280-8281,8290,8300,8310,8312-8319,8320-8323,8330-8333,8335,8337,8340-8347,8350,8370,8380-8384,8390,8400-8403,8407-8410,8413,8420,8430,8440-8442,8450-8453,8460-8462,8470-8473,8480-8482,8490,8500-8504,8507-8508,8510,8512-8514,8520-8525,8530,8540-8543,8550-8551,8560-8562,8570-8576,8580-8586,8588-8589,9070,9100,9110");
    public static final List<String> NON_SMALL_CELL_CARCINOMA = GroupUtility.expandList("8046");
    public static final List<String> SPECIFIC_NON_SMALL_CELL_CARCINOMA = GroupUtility.expandList("8012-8014,8022,8031-8033,8052,8070-8073,8082-8084,8123,8140,8200,8230,8250-8255,8260,8310,8333,8430,8470,8480-8481,8490,8550,8560,8972,8980");
    public static final List<String> SMALL_CELL_CARCINOMA = GroupUtility.expandList("8041-8045");
    public static final String INFLAMMATORY_CARCINOMA = "8530";
    public static final List<String> ADENOCARCINOMA_NOS = GroupUtility.expandList("8140");
    public static final List<String> ADENOCARCINOMA_PROSTATE_SUBTYPES = Collections.unmodifiableList(Arrays.asList("8140", "8572/3", "8500", "8201/3", "8260/3", "8230/3", "8480/3", "8490/3"));
    public static final List<String> ADENOCARCINOMA_SPECIFIC = GroupUtility.expandList("8000-8005,8010-8011,8020-8022,8046,8141-8148,8154,8160-8162,8190,8200-8201,8210-8211,8214-8215,8220-8221,8230-8231,8244-8245,8250-8255,8260-8263,8270-8272,8280-8281,8290,8300,8310,8312-8320,8322-8323,8330-8333,8335,8337,8350,8370,8380-8384,8390,8400-8403,8407-8409,8410,8413,8420,8440-8442,8450-8453,8460-8462,8470-8473,8480-8482,8490,8500-8504,8507-8508,8510,8512-8514,8520-8525,8530,8540-8543,8550-8551,8561-8562,8570-8576");
    public static final List<String> ADENOCARCINOMA_WITH_MIXED_SUBTYPES = GroupUtility.expandList("8255");
    public static final List<String> BRONCHIOALVEOLAR = GroupUtility.expandList("8250-8254");
    public static final List<String> MELANOMA_NOS = GroupUtility.expandList("8720");
    public static final List<String> MELANOMA_SPECIFIC = GroupUtility.expandList("8000-8005,8721-8790");
    public static final List<String> SARCOMA_NOS = GroupUtility.expandList("8800");
    public static final List<String> SARCOMA_SPECIFIC = GroupUtility.expandList("8000-8005,8801-8806,8810-8815,8830,8832-8833,8840,8842,8850-8855,8857-8858,8890-8891,8894-8896,8900-8902,8910,8912,8920-8921,8930-8931,8933,8935-8936,8990-8991,9040-9044,9180-9243,9260-9261");
    public static final List<String> FOLLICULAR = Collections.unmodifiableList(Arrays.asList("8330/3", "8339/3", "8335/3", "8331/3", "8332/3"));
    public static final List<String> PAPILLARY = Collections.unmodifiableList(Arrays.asList("8260/3", "8344/3", "8350/3", "8343/3", "8340/3"));
    public static final List<String> FOLLICULAR_NOS = Collections.singletonList("8330/3");
    public static final List<String> PAPILLARY_NOS = Collections.singletonList("8260/3");
    public static final String PAPILLARY_CARCINOMA = "8050";
    public static final String KAPOSI_SARCOMA = "9140";
    public static final List<String> TRANSITIONAL_CELL_CARCINOMA = GroupUtility.expandList("8120-8124");
    public static final List<String> PAPILLARY_TRANSITIONAL_CELL_CARCINOMA = GroupUtility.expandList("8130-8131");
    public static final List<String> PAGET_DISEASE = GroupUtility.expandList("8540-8543");
    public static final List<String> INTRADUCTAL_CARCINOMA = GroupUtility.expandList("8201,8230,8401,8500-8501,8503-8504,8507");
    public static final List<String> DUCT_CARCINOMA = GroupUtility.expandList("8022,8035,8500-8503,8508");
    public static final List<String> LOBULAR_CARCINOMA = GroupUtility.expandList("8520,8522,8524");
    public static final List<String> LYMPHOMA_NOS_AND_NON_HODGKIN_LYMPHOMA = GroupUtility.expandList("9590-9591,9673,9678,9679,9687,9735-9738,9823,9827");
    public static final List<String> NON_HODGKIN_LYMPHOMA = GroupUtility.expandList("9591,9670-9729");
    public static final List<String> HODGKIN_LYMPHOMA = GroupUtility.expandList("9650-9653,9655,9659,9663");
    public static final List<String> POLYP = GroupUtility.expandList("8210-8211,8213,8220-8221,8261-8263");
    public static final List<String> FAMILLIAL_POLYPOSIS = GroupUtility.expandList("8220-8221");
    public static final List<String> FAMILIAL_ADENOMATOUS_POLYPOSIS = GroupUtility.expandList("8220");
    public static final List<String> PTLD = GroupUtility.expandList("9971");
    public static final List<String> BCELL = GroupUtility.expandList("9671,9673,9678-9680,9687-9691,9695,9698,9699");
    public static final List<String> TCELL = GroupUtility.expandList("9702,9705,9708,9709,9716-9719,9724,9726,9827,9831,9834,9837");
    public static final List<String> PLASMACYTOMA = GroupUtility.expandList("9731-9732,9734");
    public static final List<String> MAST_CELL_SARCOMA = GroupUtility.expandList("9740");
    public static final List<String> MAST_CELL_LEUKEMIA = GroupUtility.expandList("9742");
    public static final List<String> MYELOID_SARCOMA = GroupUtility.expandList("9930");
    public static final List<String> MYELOID_LEUKEMIA = GroupUtility.expandList("9840,9861,9865-9867,9869-9874,9891,9895-9898,9910-9911,9931");
    public static final List<String> RETINO_BLASTOMA = GroupUtility.expandList("9510-9513");
    public static final String WILMS = "8960";
    public static final String NEUROFIBROMATOSIS = "9540";
    public static final List<String> SPECIFIC_RENAL_CELL_HISTOLOGIES = GroupUtility.expandList("8260,8310,8316-8320,8510,8959");
    public static final String GLIOBLASTOMA_NOS_AND_MULTIFORME = "9440";
    public static final List<String> GLIAL_TUMOR = GroupUtility.expandList("9380-9382,9400-9401,9410-9411,9420-9421,9423-9424,9430,9440-9442");
    public static final List<String> UROTHELIAL = GroupUtility.expandList("8120,8130,8131,8082,8122,8031,8020");
    public static final List<String> GLIAL_TUMOR_2018 = GroupUtility.expandList("9380,9385,9391,9392,9393,9396,9400,9401,9411,9424,9430,9440,9441,9442,9445,9450,9451");
    public static final String MALT = "9699/3";
    public static final Map<String, List<String>> NOS_VS_SPECIFIC;
    public static final Map<String, String> BENIGN_BRAIN_2004_HISTOLOGY_GROUPING;
    private static final String _EPENDYMOMAS = "Ependymomas";
    private static final String _NEURONAL = "Neuronal and neuronal-glial neoplasms";
    private static final String _NEUROFIBROMAS = "Neurofibromas";
    public static final Map<String, String> BENIGN_BRAIN_2007_CHART1;
    public static final Map<String, List<String>> MALIGNANT_BRAIN_2007_CHART1;
    public static final Map<String, List<String>> MALIGNANT_BRAIN_2007_CHART2;
    public static final List<String> BREAST_NST_DUCT_CARCINOMA_2018;
    public static final List<String> BREAST_LOBULAR_CARCINOMA_2018;
    public static final List<String> BREAST_DUCT_2018;
    public static final List<String> BREAST_LOBULAR_2018;
    public static final List<String> BREAST_2018_TABLE2;
    public static final Map<String, String> BREAST_2018_TABLE3_SUBTYPES;
    public static final Map<String, String> BREAST_2018_TABLE3_ROWS;
    public static final List<String> COLON_2018_TABLE1_SUBTYPES;
    public static final Map<String, String> COLON_2018_TABLE1_ROWS;
    public static final Map<String, String> KIDNEY_2018_TABLE1_SUBTYPES;
    public static final Map<String, String> KIDNEY_2018_TABLE1_ROWS;
    public static final List<String> URINARY_2018_URINARY_SITES;
    public static final List<String> URINARY_2018_UROTHELIAL_CARCINOMAS;
    public static final List<String> URINARY_2018_UROTHELIAL_CARCINOMAS_EXCLUDE_MICROPAPILLARY;
    public static final Map<String, String> URINARY_2018_TABLE2_SUBTYPES;
    public static final Map<String, String> URINARY_2018_TABLE2_ROWS;
    public static final List<String> LUNG_2018_TABLE2;
    public static final Map<String, String> LUNG_2018_TABLE3_SUBTYPES;
    public static final Map<String, String> LUNG_2018_TABLE3_ROWS;
    public static final String CNS_2018_BRAIN_SITES = "C710-C719";
    public static final String CNS_2018_CAUDA_EQUINA = "C721";
    public static final String CNS_2018_CEREBRAL_MENINGES_SITES = "C700";
    public static final String CNS_2018_SPINAL_MENINGES_SITES = "C701";
    public static final String CNS_2018_SPINAL_CORD_SITES = "C720";
    public static final String CNS_2018_CRANIAL_NERVES_SITES_NON_CAUDA_EQUINA = "C722-C725";
    public static final String CNS_2018_MENINGES_OF_CRANIAL_OR_PERIPH_NERVES_SITES = "C709";
    public static final List<String> CNS_2018_MENINGIOMAS;
    public static final List<String> NON_MALIGNANT_CNS_2018_TABLE6_SUBTYPES;
    public static final Map<String, String> NON_MALIGNANT_CNS_2018_TABLE6_ROWS;
    public static final Map<String, String> NON_MALIGNANT_CNS_2023_TABLE6_ROWS;
    public static final Map<String, String> MALIGNANT_CNS_2018_TABLE3_SUBTYPES;
    public static final Map<String, String> MALIGNANT_CNS_2018_TABLE3_ROWS;
    public static final List<String> HEAD_AND_NECK_2018_PAIRED_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE1_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE2_SITES;
    public static final List<String> HEAD_AND_NECK_2018_TABLE3_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE4_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE5_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE6_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE7_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLE8_SITES;
    public static final List<String> HEAD_AND_NECK_2018_TABLE9_SITES;
    private static final List<String> HEAD_AND_NECK_2018_TABLEC111_SITES;
    public static final Map<String, Map<String, String>> HEAD_AND_NECK_2018_SUBTYPES_FOR_SITE;
    public static final Map<String, Map<String, String>> HEAD_AND_NECK_2018_TABLE_FOR_SITE;
    public static final Map<String, String> CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES;
    public static final List<String> CUTANEOUS_MELANOMA_2021_TABLE2_ROWS;
    public static final List<String> TESTIS_SITES;
    public static final List<String> ESOPHAGUS_SITES;
    public static final List<String> STOMACH_SITES;
    public static final List<String> INTESTINE_SITES;
    public static final List<String> ANUS_SITES;
    public static final List<String> LIVER_SITES;
    public static final List<String> BLADDER_SITES;
    public static final List<String> PANCREAS_SITES;
    public static final List<String> UTERINE_CORPUS_SITES;
    public static final List<String> UTERINE_CERVIX_SITES;
    public static final List<String> VULVA_SITES;
    public static final List<String> SOFT_TISSUES_SITES;
    public static final List<String> BONE_SITES;
    public static final String THYMUS = "C379";
    public static final List<String> PENIS_AND_SCROTUM_SITES;
    public static final Map<String, Map<String, String>> OTHER_SITES_2023_TABLE_ROWS_FOR_SITE;
    public static final List<String> OTHER_SITES_2023_TABLE_2;
    public static final Map<String, Map<String, String>> OTHER_SITES_2023_TABLE_SUBTYPES_FOR_SITE;

    private MphConstants() {
    }

    static {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("8000", GroupUtility.expandList("8001-9999"));
        content.put("8010", GroupUtility.expandList("8011-8015"));
        content.put("8140", GroupUtility.expandList("8141-8145,8147-8148"));
        content.put("8070", GroupUtility.expandList("8071-8078,8080-8084"));
        content.put("8720", GroupUtility.expandList("8721-8723,8726,8728,8730,8740,8741-8746,8761,8770-8774,8780"));
        content.put("8800", GroupUtility.expandList("8801-8806"));
        content.put("8312", GroupUtility.expandList("8313-8320"));
        NOS_VS_SPECIFIC = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("9390", "Choroid plexus neoplasms");
        content.put("9383", _EPENDYMOMAS);
        content.put("9394", _EPENDYMOMAS);
        content.put("9444", _EPENDYMOMAS);
        content.put("9384", _NEURONAL);
        content.put("9412", _NEURONAL);
        content.put("9413", _NEURONAL);
        content.put("9442", _NEURONAL);
        content.put("9505/1", _NEURONAL);
        content.put("9506", _NEURONAL);
        content.put(NEUROFIBROMATOSIS, _NEUROFIBROMAS);
        content.put("9541", _NEUROFIBROMAS);
        content.put("9550", _NEUROFIBROMAS);
        content.put("9560/0", _NEUROFIBROMAS);
        content.put("9560/1", "Neurinomatosis ");
        content.put("9562", "Neurothekeoma");
        content.put("9570", "Neuroma");
        content.put("9571/0", "Perineurioma, NOS");
        BENIGN_BRAIN_2004_HISTOLOGY_GROUPING = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("9383/1", _EPENDYMOMAS);
        content.put("9394/1", _EPENDYMOMAS);
        content.put("9444/1", _EPENDYMOMAS);
        content.put("9384/1", _NEURONAL);
        content.put("9412/1", _NEURONAL);
        content.put("9413/0", _NEURONAL);
        content.put("9442/1", _NEURONAL);
        content.put("9505/1", _NEURONAL);
        content.put("9506/1", _NEURONAL);
        content.put("9540/0", _NEUROFIBROMAS);
        content.put("9540/1", _NEUROFIBROMAS);
        content.put("9541/0", _NEUROFIBROMAS);
        content.put("9550/0", _NEUROFIBROMAS);
        content.put("9560/0", _NEUROFIBROMAS);
        content.put("9560/1", "Neurinomatosis");
        content.put("9562", "Neurothekeoma");
        content.put("9570", "Neuroma");
        content.put("9571/0", "Perineurioma, NOS");
        BENIGN_BRAIN_2007_CHART1 = Collections.unmodifiableMap(content);
        content = new HashMap();
        String branch1 = "branch_1";
        Iterator<String> branch2 = "branch_2";
        String string = "branch_3";
        String string2 = "branch_4";
        String string3 = "branch_5";
        String string4 = "branch_6";
        String string5 = "branch_7";
        String string6 = "branch_8";
        String string7 = "branch_9";
        String string8 = "branch_10";
        String branch11 = "branch_11";
        String branch12 = "branch_12";
        String branch13 = "branch_13";
        String branch14 = "branch_14";
        String branch15 = "branch_15";
        String string9 = "branch_16";
        content.put("9503", Arrays.asList(branch1, branch2, string, string2, string3, string4, string5, string6, string7, string8, branch11, branch12, branch13, branch14, branch15, string9));
        content.put("9508", Collections.singletonList(branch1));
        content.put("9392", Arrays.asList(branch2, string4));
        content.put("9501", Collections.singletonList(string));
        content.put("9502", Collections.singletonList(string));
        content.put("9470", Collections.singletonList(string2));
        content.put("9471", Collections.singletonList(string2));
        content.put("9474", Collections.singletonList(string2));
        content.put("9472", Collections.singletonList(string2));
        content.put("9473", Collections.singletonList(string3));
        content.put("9500", Collections.singletonList(string3));
        content.put("9490", Collections.singletonList(string3));
        content.put("9391", Collections.singletonList(string4));
        content.put("9393", Collections.singletonList(string4));
        content.put("9362", Collections.singletonList(string5));
        content.put("9390", Collections.singletonList(string6));
        content.put("9505", Collections.singletonList(string7));
        content.put("9522", Collections.singletonList(string8));
        content.put("9521", Collections.singletonList(string8));
        content.put("9523", Collections.singletonList(string8));
        content.put("9380", Arrays.asList(branch11, branch12, branch13, branch14, branch15));
        content.put("9430", Collections.singletonList(branch11));
        content.put("9381", Collections.singletonList(branch11));
        content.put("9423", Collections.singletonList(branch11));
        content.put("9382", Collections.singletonList(branch12));
        content.put("9400", Collections.singletonList(branch13));
        content.put("9401", Collections.singletonList(branch13));
        content.put("9420", Collections.singletonList(branch13));
        content.put("9411", Collections.singletonList(branch13));
        content.put("9410", Collections.singletonList(branch13));
        content.put("9421", Collections.singletonList(branch14));
        content.put("9424", Collections.singletonList(branch15));
        content.put(GLIOBLASTOMA_NOS_AND_MULTIFORME, Collections.singletonList(branch15));
        content.put("9441", Collections.singletonList(branch15));
        content.put("9442", Collections.singletonList(branch15));
        content.put("9450", Collections.singletonList(string9));
        content.put("9451", Collections.singletonList(string9));
        content.put("9460", Collections.singletonList(string9));
        MALIGNANT_BRAIN_2007_CHART1 = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put(NEUROFIBROMATOSIS, Collections.singletonList("Periphera Nerve"));
        content.put("9561", Collections.singletonList("Periphera Nerve"));
        content.put("9560", Collections.singletonList("Periphera Nerve"));
        content.put("9571", Collections.singletonList("Periphera Nerve"));
        content.put("9100", Collections.singletonList("Germ Cell Tumors"));
        content.put("9070", Collections.singletonList("Germ Cell Tumors"));
        content.put("9064", Collections.singletonList("Germ Cell Tumors"));
        content.put("9080", Collections.singletonList("Germ Cell Tumors"));
        content.put("9085", Collections.singletonList("Germ Cell Tumors"));
        content.put("9084", Collections.singletonList("Germ Cell Tumors"));
        content.put("9071", Collections.singletonList("Germ Cell Tumors"));
        content.put("9539", Collections.singletonList("Meningioma, malignant"));
        content.put("9538", Collections.singletonList("Meningioma, malignant"));
        MALIGNANT_BRAIN_2007_CHART2 = Collections.unmodifiableMap(content);
        BREAST_NST_DUCT_CARCINOMA_2018 = GroupUtility.expandList("8500/2,8500/3,8035/3,8201/3,8022/3");
        BREAST_LOBULAR_CARCINOMA_2018 = GroupUtility.expandList("8520/2,8519/2,8520/3");
        BREAST_DUCT_2018 = GroupUtility.expandList("8500/2,8500/3,8035/3,8520/2,8519/2,8520/3");
        BREAST_LOBULAR_2018 = GroupUtility.expandList("8522/3,8522/2");
        BREAST_2018_TABLE2 = Collections.unmodifiableList(Arrays.asList("8500", "8520", "8522", "8540", "8519/2", "8523", "8524", "8575", "8543", "8541/3", "8255/3"));
        content = new HashMap();
        content.put("8035", "8035");
        content.put("8562", "8562");
        content.put("8201", "8201");
        content.put("8022/3", "8022/3");
        content.put("8230/2", "8230/2");
        content.put("8230/3", "8230/3");
        content.put("8310", "8310");
        content.put("8519/2", "8519/2");
        content.put("8513", "8513");
        content.put("8980/3", "8980/3");
        content.put("8572", "8572");
        content.put("8570", "8570");
        content.put("8032", "8032");
        content.put("8571", "8571");
        content.put("8982", "8982");
        content.put("8070", "8070");
        content.put("8574/3", "8574/3");
        content.put("8013/3", "8013/3");
        content.put("8041/3", "8041/3");
        content.put("8249/3", "8249/3");
        content.put("8504", "8504");
        content.put("8507", "8507");
        content.put("8509", "8509");
        content.put("9120/3", "9170/3,9130/3");
        content.put("9170/3", "9170/3");
        content.put("9130/3", "9130/3");
        content.put("8850/3", "8850/3");
        content.put("8890/3", "8890/3");
        content.put("9180/3", "9180/3");
        content.put("8900/3", "8920/3,8910/3,8901/3");
        content.put("8920/3", "8920/3");
        content.put("8910/3", "8910/3");
        content.put("8901/3", "8901/3");
        BREAST_2018_TABLE3_SUBTYPES = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8550", "8550");
        content.put("8200", "8200");
        content.put("8983", "8983");
        content.put("8562", "8983");
        content.put("8401", "8401");
        content.put("8500", "8500");
        content.put("8035", "8500");
        content.put("8201", "8500");
        content.put("8022/3", "8500");
        content.put("8230/2", "8500");
        content.put("8230/3", "8500");
        content.put("8315", "8315");
        content.put("8310", "8315");
        content.put(INFLAMMATORY_CARCINOMA, INFLAMMATORY_CARCINOMA);
        content.put("8314", "8314");
        content.put("8520", "8520");
        content.put("8519/2", "8520");
        content.put("8510", "8510");
        content.put("8513", "8510");
        content.put("8575", "8575");
        content.put("8980/3", "8575");
        content.put("8572", "8575");
        content.put("8570", "8575");
        content.put("8032", "8575");
        content.put("8571", "8575");
        content.put("8982", "8575");
        content.put("8070", "8575");
        content.put("8480", "8480");
        content.put("8430", "8430");
        content.put("8246/3", "8246/3");
        content.put("8574/3", "8246/3");
        content.put("8013/3", "8246/3");
        content.put("8041/3", "8246/3");
        content.put("8240/3", "8240/3");
        content.put("8249/3", "8240/3");
        content.put("8290", "8290");
        content.put("8540", "8540");
        content.put("8503", "8503");
        content.put("8504", "8503");
        content.put("8507", "8503");
        content.put("8509", "8503");
        content.put("9020/3", "9020/3");
        content.put("8525", "8525");
        content.put("8800/3", "8800/3");
        content.put("9120/3", "8800/3");
        content.put("9170/3", "8800/3");
        content.put("8850/3", "8800/3");
        content.put("8890/3", "8800/3");
        content.put("9180/3", "8800/3");
        content.put("8900/3", "8800/3");
        content.put("8920/3", "8800/3");
        content.put("8910/3", "8800/3");
        content.put("8901/3", "8800/3");
        content.put("9130/3", "8800/3");
        content.put("8410", "8410");
        content.put("8502", "8502");
        content.put("8490", "8490");
        content.put("8211", "8211");
        BREAST_2018_TABLE3_ROWS = Collections.unmodifiableMap(content);
        COLON_2018_TABLE1_SUBTYPES = Collections.unmodifiableList(Arrays.asList("8200", "8201", "8145", "8142/3", "8510", "8265", "8480", "8430", "8213", "8490", "8143", "8263", "8020", "8243", "8013", "8041", "8241", "8249", "8156", "9120/3", "8890/3"));
        content = new HashMap();
        content.put("8140", "8140");
        content.put("8200", "8140");
        content.put("8201", "8140");
        content.put("8145", "8140");
        content.put("8142/3", "8140");
        content.put("8510", "8140");
        content.put("8265", "8140");
        content.put("8480", "8140");
        content.put("8430", "8140");
        content.put("8213", "8140");
        content.put("8490", "8140");
        content.put("8143", "8140");
        content.put("8263", "8140");
        content.put("8020", "8140");
        content.put("8560", "8560");
        content.put("8045", "8045");
        content.put("8153", "8153");
        content.put("8936/3", "8936/3");
        content.put("8244", "8244");
        content.put("8243", "8244");
        content.put("8154", "8154");
        content.put("8246", "8246");
        content.put("8013", "8246");
        content.put("8041", "8246");
        content.put("8240", "8240");
        content.put("8241", "8240");
        content.put("8249", "8240");
        content.put("8156", "8240");
        content.put("8800/3", "8800/3");
        content.put("9120/3", "8800/3");
        content.put("8890/3", "8800/3");
        content.put("8032", "8032");
        content.put("8070", "8070");
        COLON_2018_TABLE1_ROWS = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8693/3", "8693/3");
        content.put("8013/3", "8013/3");
        content.put("8041/3", "8041/3");
        content.put("8316", "8316");
        content.put("8317", "8317");
        content.put("8323/3", "8323/3");
        content.put("8310", "8310");
        content.put("8319", "8319");
        content.put("8311", "8311");
        content.put("8480", "8480");
        content.put("8260", "8260");
        content.put("9120/3", "9120/3");
        content.put("8964/3", "8964/3");
        content.put("8890/3", "8890/3");
        content.put("9180/3", "9180/3");
        content.put("9364/3", "9364/3");
        content.put("8900/3", "8920/3,8910/3,8901/3,8912/3");
        content.put("8920/3", "8920/3");
        content.put("8910/3", "8910/3");
        content.put("8901/3", "8901/3");
        content.put("8912/3", "8912/3");
        content.put("9040/3", "9040/3");
        KIDNEY_2018_TABLE1_SUBTYPES = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8510", "8510");
        content.put(WILMS, WILMS);
        content.put("8693/3", "8240/3");
        content.put("8041/3", "8240/3");
        content.put("8013/3", "8240/3");
        content.put("8240/3", "8240/3");
        content.put("8700/3", "8700/3");
        content.put("8312", "8312");
        content.put("8316", "8312");
        content.put("8317", "8312");
        content.put("8323/3", "8312");
        content.put("8310", "8312");
        content.put("8319", "8312");
        content.put("8311", "8312");
        content.put("8480", "8312");
        content.put("8260", "8312");
        content.put("8800/3", "8800/3");
        content.put("9120/3", "8800/3");
        content.put("8964/3", "8800/3");
        content.put("8890/3", "8800/3");
        content.put("9180/3", "8800/3");
        content.put("9364/3", "8800/3");
        content.put("8900/3", "8800/3");
        content.put("8920/3", "8800/3");
        content.put("8910/3", "8800/3");
        content.put("8901/3", "8800/3");
        content.put("8912/3", "8800/3");
        content.put("9040/3", "8800/3");
        KIDNEY_2018_TABLE1_ROWS = Collections.unmodifiableMap(content);
        URINARY_2018_URINARY_SITES = Collections.unmodifiableList(Arrays.asList(RENAL_PELVIS, URETER, "C670", "C671", "C672", "C673", "C674", "C675", "C676", "C677", "C678", "C679", URETHRA));
        URINARY_2018_UROTHELIAL_CARCINOMAS = Collections.unmodifiableList(Arrays.asList("8120", "8031", "8082", "8130", "8131", "8020", "8122"));
        URINARY_2018_UROTHELIAL_CARCINOMAS_EXCLUDE_MICROPAPILLARY = Collections.unmodifiableList(Arrays.asList("8120", "8031", "8082", "8130", "8020", "8122"));
        content = new HashMap();
        content.put("8310", "8310");
        content.put("8380", "8380");
        content.put("8144", "8144");
        content.put("8480", "8480");
        content.put("8746/3", "8746/3");
        content.put("8721/3", "8721/3");
        content.put("8013/3", "8013/3");
        content.put("8041/3", "8041/3");
        content.put("8249/3", "8249/3");
        content.put("9120/3", "9120/3");
        content.put("9220/3", "9220/3");
        content.put("8890/3", "8890/3");
        content.put("8850/3", "8850/3");
        content.put("9540/3", "9540/3");
        content.put("8802/3", "8802/3");
        content.put("8900/3", "8910/3");
        content.put("8051", "8051");
        content.put("8031/3", "8031/3");
        content.put("8082/3", "8082/3");
        content.put("8130", "8130");
        content.put("8131/3", "8131/3");
        content.put("8020/3", "8020/3");
        content.put("8122/3", "8122/3");
        URINARY_2018_TABLE2_SUBTYPES = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8140", "8140");
        content.put("8310", "8140");
        content.put("8380", "8140");
        content.put("8144", "8140");
        content.put("8480", "8140");
        content.put("8720/3", "8720/3");
        content.put("8746/3", "8720/3");
        content.put("8721/3", "8720/3");
        content.put("8714/3", "8714/3");
        content.put("8323/3", "8323/3");
        content.put("8154/3", "8154/3");
        content.put("8246/3", "8246/3");
        content.put("8013/3", "8246/3");
        content.put("8041/3", "8246/3");
        content.put("8240/3", "8240/3");
        content.put("8249/3", "8240/3");
        content.put("8693/3", "8693/3");
        content.put("8800/3", "8800/3");
        content.put("9120/3", "8800/3");
        content.put("9220/3", "8800/3");
        content.put("8890/3", "8800/3");
        content.put("8850/3", "8800/3");
        content.put("9540/3", "8800/3");
        content.put("8802/3", "8800/3");
        content.put("8900/3", "8800/3");
        content.put("8910/3", "8800/3");
        content.put("8070", "8070");
        content.put("8051", "8070");
        content.put("8120", "8120");
        content.put("8031/3", "8120");
        content.put("8082/3", "8120");
        content.put("8130/2", "8120");
        content.put("8130/3", "8120");
        content.put("8131/3", "8120");
        content.put("8020/3", "8120");
        content.put("8122/3", "8120");
        URINARY_2018_TABLE2_ROWS = Collections.unmodifiableMap(content);
        LUNG_2018_TABLE2 = Collections.unmodifiableList(Arrays.asList("8560", "8033", "8562", "8013", "8254/3", "8045", "8072", "8073", "8070", "8074", "8255/3"));
        content = new HashMap();
        content.put("8551", "8551");
        content.put("8200", "8200");
        content.put("8480", "8480");
        content.put("8144", "8144");
        content.put("8333", "8333");
        content.put("8250/3", "8250/3");
        content.put("8253", "8253");
        content.put("8257/3", "8257/3");
        content.put("8265", "8265");
        content.put("8254", "8254");
        content.put("8256/3", "8256/3");
        content.put("8250/2", "8250/2");
        content.put("8260", "8260");
        content.put("8230", "8230");
        content.put("8045", "8045");
        content.put("8041", "8041");
        content.put("8249", "8249");
        content.put("9043/3", "9043/3");
        content.put("9042/3", "9042/3");
        content.put("9137/3", "9137/3");
        content.put("8842/3", "8842/3");
        content.put("9041/3", "9041/3");
        content.put("9040/3", "9040/3");
        content.put("8083", "8083");
        content.put("8071", "8071");
        content.put("8072", "8072");
        LUNG_2018_TABLE3_SUBTYPES = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8140", "8140");
        content.put("8551", "8140");
        content.put("8200", "8140");
        content.put("8480", "8140");
        content.put("8144", "8140");
        content.put("8333", "8140");
        content.put("8250/3", "8140");
        content.put("8253/2", "8140");
        content.put("8253/3", "8140");
        content.put("8257/3", "8140");
        content.put("8265", "8140");
        content.put("8254", "8140");
        content.put("8250/2", "8140");
        content.put("8256/3", "8140");
        content.put("8260", "8140");
        content.put("8230", "8140");
        content.put("8560", "8560");
        content.put("8980/3", "8980/3");
        content.put("9170/3", "9170/3");
        content.put("8562", "8562");
        content.put("9133", "9133");
        content.put("8031", "8031");
        content.put("8310", "8310");
        content.put("8580/3", "8580/3");
        content.put("8012", "8012");
        content.put("9174/3", "9174/3");
        content.put("8013", "8013");
        content.put("8082", "8082");
        content.put("8720", "8720");
        content.put("8430", "8430");
        content.put("8982", "8982");
        content.put("8246", "8246");
        content.put("8045", "8246");
        content.put("8041", "8246");
        content.put("8240", "8240");
        content.put("8249", "8240");
        content.put("8023/3", "8023/3");
        content.put("8714/3", "8714/3");
        content.put("8022", "8022");
        content.put("8973/3", "8973/3");
        content.put("8972/3", "8972/3");
        content.put("8800/3", "8800/3");
        content.put("9043/3", "8800/3");
        content.put("9042/3", "8800/3");
        content.put("9137/3", "8800/3");
        content.put("8842/3", "8800/3");
        content.put("9041/3", "8800/3");
        content.put("9040/3", "8800/3");
        content.put("8032", "8032");
        content.put("8070", "8070");
        content.put("8083", "8070");
        content.put("8071", "8070");
        content.put("8072", "8070");
        content.put("8044/3", "8044/3");
        LUNG_2018_TABLE3_ROWS = Collections.unmodifiableMap(content);
        CNS_2018_MENINGIOMAS = Collections.unmodifiableList(Arrays.asList("9530/0", "9534/0", "9539/1", "9538/1", "9532/0", "9531/0", "9537/0"));
        NON_MALIGNANT_CNS_2018_TABLE6_SUBTYPES = Collections.unmodifiableList(Arrays.asList("9390/1", "9351/1", "9352/1", "9431/1", "9493/0", "9121/0", "9122/0", "8880/0", "8728/1", "9534/0", "9539/1", "9538/1", "9532/0", "9531/0", "9533/0", "9537/0", "8825/1", "9550/0", "9560/1"));
        content = new HashMap();
        content.put("8830/0", "8830/0");
        content.put("9506/1", "9506/1");
        content.put("9220/0", "9220/0");
        content.put("9444/1", "9444/1");
        content.put("9390/0", "9390/0");
        content.put("9390/1", "9390/0");
        content.put("9350/1", "9350/1");
        content.put("9351/1", "9350/1");
        content.put("9352/1", "9350/1");
        content.put("9412/1", "9412/1");
        content.put("9421/1", "9421/1");
        content.put("9431/1", "9421/1");
        content.put("9413/0", "9413/0");
        content.put("9492/0", "9492/0");
        content.put("9493/0", "9492/0");
        content.put("9505/1", "9505/1");
        content.put("9582/0", "9582/0");
        content.put("9161/1", "9161/1");
        content.put("9121/0", "9120/0");
        content.put("9122/0", "9120/0");
        content.put("9120/0", "9120/0");
        content.put("9749/1", "9749/1");
        content.put("8890/0", "8890/0");
        content.put("8850/0", "8850/0");
        content.put("9380/1", "9380/1");
        content.put("8880/0", "8850/0");
        content.put("8728/0", "8728/0");
        content.put("8728/1", "8728/0");
        content.put("9530/0", "9530/0");
        content.put("9534/0", "9530/0");
        content.put("9539/1", "9530/0");
        content.put("9538/1", "9530/0");
        content.put("9532/0", "9530/0");
        content.put("9531/0", "9530/0");
        content.put("9533/0", "9530/0");
        content.put("9537/0", "9530/0");
        content.put("9509/0", "9509/0");
        content.put("8825/0", "8825/0");
        content.put("8825/1", "8825/0");
        content.put("9394/1", "9394/1");
        content.put("9506/1", "9506/1");
        content.put("8000/0", "8000/0");
        content.put("8000/1", "8000/0");
        content.put("9540/0", "9540/0");
        content.put("9550/0", "9540/0");
        content.put("9421/1", "9421/1");
        content.put("9509/1", "9509/1");
        content.put("9180/0", "9180/0");
        content.put("9509/1", "9509/1");
        content.put("8693/1", "8693/1");
        content.put("9571/0", "9571/0");
        content.put("9361/1", "9361/1");
        content.put("9432/1", "9432/1");
        content.put("8272/0", "8272/0");
        content.put("9413/0", "9413/0");
        content.put("8271/0", "8271/0");
        content.put("8900/0", "8900/0");
        content.put("9560/0", "9560/0");
        content.put("9560/1", "9560/0");
        content.put("8815/1", "8815/1");
        content.put("8290/0", "8290/0");
        content.put("9384/1", "9384/1");
        content.put("9383/1", "9383/1");
        content.put("9080/1", "9080/1");
        NON_MALIGNANT_CNS_2018_TABLE6_ROWS = Collections.unmodifiableMap(content);
        content.remove("9180/0");
        NON_MALIGNANT_CNS_2023_TABLE6_ROWS = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("9401", "9401");
        content.put("9411", "9411");
        content.put("9424", "9424");
        content.put("9473", "9473");
        content.put("9071", "9071");
        content.put("9392", "9392");
        content.put("9396", "9396");
        content.put("9393", "9393");
        content.put("9441", "9441");
        content.put("9445", "9445");
        content.put("9442", "9442");
        content.put("9085", "9085");
        content.put("9084", "9084");
        content.put("9538", "9538");
        content.put("9542", "9542");
        content.put("9474", "9474");
        content.put("9471", "9471");
        content.put("9477", "9477");
        content.put("9476", "9476");
        content.put("9475", "9475");
        content.put("9451", "9451");
        content.put("9425", "9425");
        content.put("9395", "9395");
        content.put("9120", "9120");
        content.put("9220", "9220");
        content.put("9240", "9220");
        content.put("8890", "8891,8896");
        content.put("8891", "8891");
        content.put("8896", "8896");
        content.put("8859", "8859");
        content.put("9180", "9180");
        content.put("9480", "9480");
        content.put("9366", "9366");
        content.put("9268", "9268");
        content.put("8802", "8802");
        MALIGNANT_CNS_2018_TABLE3_SUBTYPES = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("9505", "9505");
        content.put("9430", "9430");
        content.put("9400", "9400");
        content.put("9401", "9400");
        content.put("9411", "9400");
        content.put("9424", "9400");
        content.put("8693/3", "8693/3");
        content.put("9100", "9100");
        content.put("9390", "9390");
        content.put("9508", "9508");
        content.put("9490", "9490");
        content.put("9473", "9490");
        content.put("9500", "9500");
        content.put("9509", "9509");
        content.put("9385", "9385");
        content.put("9070", "9070");
        content.put("9071", "9070");
        content.put("9478", "9478");
        content.put("9391", "9391");
        content.put("9392", "9391");
        content.put("9396", "9391");
        content.put("9393", "9391");
        content.put("9133", "9133");
        content.put("9064", "9064");
        content.put(GLIOBLASTOMA_NOS_AND_MULTIFORME, GLIOBLASTOMA_NOS_AND_MULTIFORME);
        content.put("9441", GLIOBLASTOMA_NOS_AND_MULTIFORME);
        content.put("9445", "9440,9400");
        content.put("9442", GLIOBLASTOMA_NOS_AND_MULTIFORME);
        content.put("9380", "9380");
        content.put("9421/3", "9421/3");
        content.put("9080", "9080");
        content.put("9085", "9080");
        content.put("9084", "9080");
        content.put("9530", "9530");
        content.put("9538", "9530");
        content.put(NEUROFIBROMATOSIS, NEUROFIBROMATOSIS);
        content.put("9542", NEUROFIBROMATOSIS);
        content.put("9470", "9470");
        content.put("9474", "9470");
        content.put("9471", "9470");
        content.put("9477", "9470");
        content.put("9476", "9470");
        content.put("9475", "9470");
        content.put("9501", "9501");
        content.put("8720", "8720");
        content.put("8000/3", "8000/3");
        content.put("9382", "9382");
        content.put("9450", "9450");
        content.put("9451", "9450");
        content.put("9364", "9364");
        content.put("9421", "9421");
        content.put("9425", "9421");
        content.put("9362", "9362");
        content.put("9365", "9362");
        content.put("8272/3", "8272/3");
        content.put("8800", "8800");
        content.put("9120", "8800");
        content.put("9220", "8800");
        content.put("9240", "8800");
        content.put("8890", "8800");
        content.put("8891", "8800");
        content.put("8896", "8800");
        content.put("8859", "8800");
        content.put("9180", "8800");
        content.put("9480", "8800");
        content.put("9366", "8800");
        content.put("9268", "8800");
        content.put("8802", "8800");
        content.put("8815/3", "8815/3");
        MALIGNANT_CNS_2018_TABLE3_ROWS = Collections.unmodifiableMap(content);
        HEAD_AND_NECK_2018_PAIRED_SITES = Collections.unmodifiableList(Arrays.asList("C079", "C080,C081", "C098,C099", "C300", "C301", "C310,C312", "C754"));
        HEAD_AND_NECK_2018_TABLE1_SITES = Collections.unmodifiableList(Arrays.asList("C300", "C310", "C311", "C312", "C313", "C318", "C319"));
        HEAD_AND_NECK_2018_TABLE2_SITES = Collections.unmodifiableList(Arrays.asList("C110", "C112", "C113", "C118", "C119"));
        HEAD_AND_NECK_2018_TABLE3_SITES = Collections.unmodifiableList(Arrays.asList("C129", "C130", "C131", "C132", "C138", "C139", "C320", "C321", "C322", "C323", "C328", "C329", "C339"));
        HEAD_AND_NECK_2018_TABLE4_SITES = Collections.unmodifiableList(Arrays.asList("C020", "C021", "C022", "C023", "C028", "C029", "C030", "C031", "C039", "C040", "C041", "C048", "C049", "C050", "C051", "C052", "C058", "C059", "C060", "C061", "C062", "C068", "C069"));
        HEAD_AND_NECK_2018_TABLE5_SITES = Collections.unmodifiableList(Arrays.asList("C024", "C100", "C101", "C102", "C103", "C104", "C108", "C109", "C019", "C090", "C091", "C098", "C099"));
        HEAD_AND_NECK_2018_TABLE6_SITES = Collections.unmodifiableList(Arrays.asList("C079", "C080", "C081", "C088", "C089"));
        HEAD_AND_NECK_2018_TABLE7_SITES = Collections.unmodifiableList(Arrays.asList("C410", "C411"));
        HEAD_AND_NECK_2018_TABLE8_SITES = Collections.singletonList("C301");
        HEAD_AND_NECK_2018_TABLE9_SITES = Collections.unmodifiableList(Arrays.asList("C479", "C754", "C755"));
        HEAD_AND_NECK_2018_TABLEC111_SITES = Collections.singletonList("C111");
        content = new HashMap();
        HashMap<String, String> thisTableSubTypes = new HashMap<String, String>();
        thisTableSubTypes.put("8144", "8144");
        thisTableSubTypes.put("9560/3", "9560/3");
        thisTableSubTypes.put("8745/3", "8745/3");
        thisTableSubTypes.put("8746/3", "8746/3");
        thisTableSubTypes.put("8721/3", "8721/3");
        thisTableSubTypes.put("9521/3", "9521/3");
        thisTableSubTypes.put("9523/3", "9523/3");
        thisTableSubTypes.put("9120/3", "9120/3");
        thisTableSubTypes.put("9045/3", "9045/3");
        thisTableSubTypes.put("9133/3", "9133/3");
        thisTableSubTypes.put("8810/3", "8810/3");
        thisTableSubTypes.put("8890/3", "8890/3");
        thisTableSubTypes.put("9130/3", "9130/3");
        thisTableSubTypes.put("8900/3", "8920/3,8910/3,8901/3,8912/3");
        thisTableSubTypes.put("8920/3", "8920/3");
        thisTableSubTypes.put("8910/3", "8910/3");
        thisTableSubTypes.put("8901/3", "8901/3");
        thisTableSubTypes.put("8912/3", "8912/3");
        thisTableSubTypes.put("9040/3", "9040/3");
        thisTableSubTypes.put("8802/3", "8802/3");
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8085", "8085");
        thisTableSubTypes.put("8086", "8086");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8052", "8052");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8121", "8121");
        thisTableSubTypes.put("8074", "8074");
        thisTableSubTypes.put("8051", "8051");
        for (String string10 : HEAD_AND_NECK_2018_TABLE1_SITES) {
            content.put(string10, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8082", "8082");
        thisTableSubTypes.put("8020", "8020");
        for (String string11 : HEAD_AND_NECK_2018_TABLE2_SITES) {
            content.put(string11, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("9222/3", "9222/3");
        thisTableSubTypes.put("9242/3", "9242/3");
        thisTableSubTypes.put("9243/3", "9243/3");
        thisTableSubTypes.put("8851/3", "8851/3");
        thisTableSubTypes.put("8013/3", "8013/3");
        thisTableSubTypes.put("8249/3", "8249/3");
        thisTableSubTypes.put("8041/3", "8041/3");
        thisTableSubTypes.put("8560", "8560");
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8082", "8082");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8052", "8052");
        thisTableSubTypes.put("8074", "8074");
        thisTableSubTypes.put("8051", "8051");
        for (String string12 : HEAD_AND_NECK_2018_TABLE3_SITES) {
            content.put(string12, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("8745/3", "8745/3");
        thisTableSubTypes.put("8746/3", "8746/3");
        thisTableSubTypes.put("8721/3", "8721/3");
        thisTableSubTypes.put("8075", "8075");
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8082", "8082");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8052", "8052");
        thisTableSubTypes.put("8074", "8074");
        thisTableSubTypes.put("8051", "8051");
        for (String string13 : HEAD_AND_NECK_2018_TABLE4_SITES) {
            content.put(string13, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8082", "8082");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8052", "8052");
        thisTableSubTypes.put("8086", "8086");
        thisTableSubTypes.put("8085", "8085");
        thisTableSubTypes.put("8074", "8074");
        thisTableSubTypes.put("8051", "8051");
        for (String string14 : HEAD_AND_NECK_2018_TABLE5_SITES) {
            content.put(string14, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("8147", "8147");
        thisTableSubTypes.put("8941", "8941");
        thisTableSubTypes.put("8310", "8310");
        thisTableSubTypes.put("8144", "8144");
        thisTableSubTypes.put("8480", "8480");
        thisTableSubTypes.put("8430", "8430");
        thisTableSubTypes.put("8450", "8450");
        thisTableSubTypes.put("8013", "8013");
        thisTableSubTypes.put("8041", "8041");
        thisTableSubTypes.put("8265/3", "8265/3");
        thisTableSubTypes.put("8481/3", "8481/3");
        thisTableSubTypes.put("8290/3", "8290/3");
        thisTableSubTypes.put("8033/3", "8033/3");
        for (String string15 : HEAD_AND_NECK_2018_TABLE6_SITES) {
            content.put(string15, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("9310/3", "9310/3");
        thisTableSubTypes.put("9330/3", "9330/3");
        thisTableSubTypes.put("9222/3", "9222/3");
        thisTableSubTypes.put("9220/3", "9220/3");
        thisTableSubTypes.put("9240/3", "9220/3");
        thisTableSubTypes.put("9221/3", "9221/3");
        thisTableSubTypes.put("9242/3", "9242/3");
        thisTableSubTypes.put("9243/3", "9243/3");
        thisTableSubTypes.put("9180/3", "9181/3,9186/3,9194/3,9187/3,9192/3,9193/3,9184/3,9185/3,9183/3");
        thisTableSubTypes.put("9181/3", "9181/3");
        thisTableSubTypes.put("9186/3", "9186/3");
        thisTableSubTypes.put("9194/3", "9194/3");
        thisTableSubTypes.put("9187/3", "9187/3");
        thisTableSubTypes.put("9192/3", "9192/3");
        thisTableSubTypes.put("9193/3", "9193/3");
        thisTableSubTypes.put("9184/3", "9184/3");
        thisTableSubTypes.put("9185/3", "9185/3");
        thisTableSubTypes.put("9183/3", "9183/3");
        thisTableSubTypes.put("8900/3", "8900/3");
        for (String string16 : HEAD_AND_NECK_2018_TABLE7_SITES) {
            content.put(string16, thisTableSubTypes);
        }
        thisTableSubTypes = new HashMap();
        thisTableSubTypes.put("8083", "8083");
        thisTableSubTypes.put("8071", "8071");
        thisTableSubTypes.put("8072", "8072");
        thisTableSubTypes.put("8086", "8086");
        thisTableSubTypes.put("8085", "8085");
        thisTableSubTypes.put("8082", "8082");
        thisTableSubTypes.put("8020", "8020");
        for (String string17 : HEAD_AND_NECK_2018_TABLEC111_SITES) {
            content.put(string17, thisTableSubTypes);
        }
        HEAD_AND_NECK_2018_SUBTYPES_FOR_SITE = Collections.unmodifiableMap(content);
        content = new HashMap();
        HashMap<String, String> thisTableRows = new HashMap<String, String>();
        thisTableRows.put("8140", "8140");
        thisTableRows.put("8144", "8140");
        thisTableRows.put("8483/3", "8483/3");
        thisTableRows.put("8082", "8082");
        thisTableRows.put("9540/3", "9540/3");
        thisTableRows.put("9560/3", "9540/3");
        thisTableRows.put("8430", "8430");
        thisTableRows.put("8720", "8720");
        thisTableRows.put("8745/3", "8720");
        thisTableRows.put("8746/3", "8720");
        thisTableRows.put("8721/3", "8720");
        thisTableRows.put("8982", "8982");
        thisTableRows.put("8023", "8023");
        thisTableRows.put("9522/3", "9522/3");
        thisTableRows.put("9521/3", "9522/3");
        thisTableRows.put("9523/3", "9522/3");
        thisTableRows.put("9364", "9364");
        thisTableRows.put("8800/3", "8800/3");
        thisTableRows.put("9120/3", "8800/3");
        thisTableRows.put("9045/3", "8800/3");
        thisTableRows.put("9133/3", "8800/3");
        thisTableRows.put("8810/3", "8800/3");
        thisTableRows.put("8890/3", "8800/3");
        thisTableRows.put("9130/3", "8800/3");
        thisTableRows.put("8900/3", "8800/3");
        thisTableRows.put("8920/3", "8800/3");
        thisTableRows.put("8910/3", "8800/3");
        thisTableRows.put("8901/3", "8800/3");
        thisTableRows.put("8912/3", "8800/3");
        thisTableRows.put("9040/3", "8800/3");
        thisTableRows.put("8802/3", "8800/3");
        thisTableRows.put("8020", "8020");
        thisTableRows.put("8044", "8044");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8085", "8070");
        thisTableRows.put("8086", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8052", "8070");
        thisTableRows.put("8072", "8070");
        thisTableRows.put("8121", "8070");
        thisTableRows.put("8074", "8070");
        thisTableRows.put("8051", "8070");
        thisTableRows.put("9081", "9081");
        for (String string18 : HEAD_AND_NECK_2018_TABLE1_SITES) {
            content.put(string18, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8200", "8200");
        thisTableRows.put("9370", "9370");
        thisTableRows.put("8260", "8260");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8072", "8070");
        thisTableRows.put("8082", "8070");
        thisTableRows.put("8020", "8070");
        for (String string19 : HEAD_AND_NECK_2018_TABLE2_SITES) {
            content.put(string19, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8200", "8200");
        thisTableRows.put("9220/3", "9220/3");
        thisTableRows.put("9222/3", "9220/3");
        thisTableRows.put("9242/3", "9220/3");
        thisTableRows.put("9243/3", "9220/3");
        thisTableRows.put("8850/3", "8850/3");
        thisTableRows.put("8851/3", "8850/3");
        thisTableRows.put("8240/3", "8240/3");
        thisTableRows.put("8013/3", "8240/3");
        thisTableRows.put("8249/3", "8240/3");
        thisTableRows.put("8041/3", "8240/3");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8560", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8082", "8070");
        thisTableRows.put("8052", "8070");
        thisTableRows.put("8074", "8070");
        thisTableRows.put("8051", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8072", "8070");
        for (String string20 : HEAD_AND_NECK_2018_TABLE3_SITES) {
            content.put(string20, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8560", "8560");
        thisTableRows.put("9580", "9580");
        thisTableRows.put("8430", "8430");
        thisTableRows.put("8720", "8720");
        thisTableRows.put("8745/3", "8720");
        thisTableRows.put("8746/3", "8720");
        thisTableRows.put("8721/3", "8720");
        thisTableRows.put("8825", "8825");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8075", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8082", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8072", "8070");
        thisTableRows.put("8052", "8070");
        thisTableRows.put("8074", "8070");
        thisTableRows.put("8051", "8070");
        for (String string21 : HEAD_AND_NECK_2018_TABLE4_SITES) {
            content.put(string21, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8200", "8200");
        thisTableRows.put("8525", "8525");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8082", "8070");
        thisTableRows.put("8072", "8070");
        thisTableRows.put("8052", "8070");
        thisTableRows.put("8086", "8070");
        thisTableRows.put("8085", "8070");
        thisTableRows.put("8074", "8070");
        thisTableRows.put("8051", "8070");
        for (String string22 : HEAD_AND_NECK_2018_TABLE5_SITES) {
            content.put(string22, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8550", "8550");
        thisTableRows.put("8140", "8140");
        thisTableRows.put("8147", "8140");
        thisTableRows.put("8941", "8140");
        thisTableRows.put("8310", "8140");
        thisTableRows.put("8144", "8140");
        thisTableRows.put("8480", "8140");
        thisTableRows.put("8430", "8140");
        thisTableRows.put("8450", "8140");
        thisTableRows.put("8200", "8200");
        thisTableRows.put("8980", "8980");
        thisTableRows.put("8440", "8440");
        thisTableRows.put("8562", "8562");
        thisTableRows.put("8082", "8082");
        thisTableRows.put("8982", "8982");
        thisTableRows.put("8246", "8246");
        thisTableRows.put("8013", "8246");
        thisTableRows.put("8041", "8246");
        thisTableRows.put("8525", "8525");
        thisTableRows.put("8500", "8500");
        thisTableRows.put("8265/3", "8500");
        thisTableRows.put("8481/3", "8500");
        thisTableRows.put("8290/3", "8500");
        thisTableRows.put("8033/3", "8500");
        thisTableRows.put("8410", "8410");
        thisTableRows.put("8502", "8502");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8020/3", "8020/3");
        for (String string23 : HEAD_AND_NECK_2018_TABLE6_SITES) {
            content.put(string23, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("9270/3", "9270/3");
        thisTableRows.put("9310/3", "9270/3");
        thisTableRows.put("9341", "9341");
        thisTableRows.put("9302", "9302");
        thisTableRows.put("8980/3", "8980/3");
        thisTableRows.put("9330/3", "8980/3,8800/3");
        thisTableRows.put("8800/3", "8800/3");
        thisTableRows.put("9222/3", "8800/3");
        thisTableRows.put("9220/3", "8800/3");
        thisTableRows.put("9240/3", "8800/3");
        thisTableRows.put("9221/3", "8800/3");
        thisTableRows.put("9242/3", "8800/3");
        thisTableRows.put("9243/3", "8800/3");
        thisTableRows.put("9180/3", "8800/3");
        thisTableRows.put("9181/3", "8800/3");
        thisTableRows.put("9186/3", "8800/3");
        thisTableRows.put("9194/3", "8800/3");
        thisTableRows.put("9187/3", "8800/3");
        thisTableRows.put("9192/3", "8800/3");
        thisTableRows.put("9193/3", "8800/3");
        thisTableRows.put("9184/3", "8800/3");
        thisTableRows.put("9185/3", "8800/3");
        thisTableRows.put("9183/3", "8800/3");
        thisTableRows.put("8900/3", "8800/3");
        for (String string24 : HEAD_AND_NECK_2018_TABLE7_SITES) {
            content.put(string24, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8140", "8140");
        thisTableRows.put("8420/3", "8420/3");
        thisTableRows.put("8240/3", "8240/3");
        thisTableRows.put("8070", "8070");
        for (String string25 : HEAD_AND_NECK_2018_TABLE8_SITES) {
            content.put(string25, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8690", "8690");
        thisTableRows.put("8691", "8691");
        thisTableRows.put("8692", "8692");
        thisTableRows.put("8693", "8693");
        thisTableRows.put("8680", "8680");
        thisTableRows.put("8681", "8681");
        thisTableRows.put("8682", "8682");
        for (String string26 : HEAD_AND_NECK_2018_TABLE9_SITES) {
            content.put(string26, thisTableRows);
        }
        thisTableRows = new HashMap();
        thisTableRows.put("8200", "8200");
        thisTableRows.put("9370", "9370");
        thisTableRows.put("8260", "8260");
        thisTableRows.put("8525", "8525");
        thisTableRows.put("8070", "8070");
        thisTableRows.put("8083", "8070");
        thisTableRows.put("8071", "8070");
        thisTableRows.put("8072", "8070");
        thisTableRows.put("8086", "8070");
        thisTableRows.put("8085", "8070");
        thisTableRows.put("8082", "8070");
        thisTableRows.put("8020", "8070");
        for (String string27 : HEAD_AND_NECK_2018_TABLEC111_SITES) {
            content.put(string27, thisTableRows);
        }
        HEAD_AND_NECK_2018_TABLE_FOR_SITE = Collections.unmodifiableMap(content);
        content = new HashMap();
        content.put("8744/3", "8744/3");
        content.put("8730/3", "8730/3");
        content.put("8722/3", "8722/3");
        content.put("8745/3", "8745/3");
        content.put("8771/3", "8771/3");
        content.put("8742", "8742");
        content.put("8743/3", "8743/3");
        content.put("8780/3", "8780/3");
        content.put("8761/3", "8761/3");
        content.put("8741/3", "8741/3");
        content.put("8723/3", "8723/3");
        content.put("8770/3", "8770/3");
        content.put("8721/3", "8721/3");
        content.put("8772/3", "8772/3");
        content.put("8773/3", "8773/3");
        content.put("8774/3", "8774/3");
        CUTANEOUS_MELANOMA_2021_TABLE2_SUBTYPES = Collections.unmodifiableMap(content);
        CUTANEOUS_MELANOMA_2021_TABLE2_ROWS = Collections.unmodifiableList(Arrays.asList("8720", "8744/3", "8730/3", "8722/3", "8745/3", "8771/3", "8742", "8743/3", "8780/3", "8761/3", "8741/3", "8723/3", "8770/3", "8721/3", "8772/3", "8773/3", "8774/3"));
        TESTIS_SITES = Collections.unmodifiableList(Arrays.asList("C620", "C621", "C629"));
        ESOPHAGUS_SITES = Collections.unmodifiableList(Arrays.asList("C150", "C151", "C152", "C153", "C154", "C155", "C158", "C159"));
        STOMACH_SITES = Collections.unmodifiableList(Arrays.asList("C160", "C161", "C162", "C163", "C164", "C165", "C166", "C168", "C169"));
        INTESTINE_SITES = Collections.unmodifiableList(Arrays.asList("C170", "C171", "C172", "C173", "C178", "C179", "C241"));
        ANUS_SITES = Collections.unmodifiableList(Arrays.asList("C210", "C211", "C212", "C218"));
        LIVER_SITES = Collections.unmodifiableList(Arrays.asList("C220", "C221"));
        BLADDER_SITES = Collections.unmodifiableList(Arrays.asList("C239", "C240", "C248", "C249"));
        PANCREAS_SITES = Collections.unmodifiableList(Arrays.asList("C250", "C251", "C252", "C253", "C254", "C257", "C258", "C259"));
        UTERINE_CORPUS_SITES = Collections.unmodifiableList(Arrays.asList("C540", "C541", "C542", "C543", "C548", "C549", "C559"));
        UTERINE_CERVIX_SITES = Collections.unmodifiableList(Arrays.asList("C530", "C531", "C538", "C539"));
        VULVA_SITES = Collections.unmodifiableList(Arrays.asList("C510", "C511", "C512", "C518", "C519"));
        SOFT_TISSUES_SITES = Collections.unmodifiableList(Arrays.asList("C490", "C491", "C492", "C493", "C494", "C495", "C496", "C498", "C499"));
        BONE_SITES = Collections.unmodifiableList(Arrays.asList("C400", "C401", "C402", "C403", "C408", "C409", "C412", "C413", "C414", "C418", "C419"));
        PENIS_AND_SCROTUM_SITES = Collections.unmodifiableList(Arrays.asList("C600", "C601", "C602", "C608", "C609", "C630", "C632"));
        content = new HashMap();
        HashMap<String, String> prostateRows = new HashMap<String, String>();
        prostateRows.put("8140", "8140");
        prostateRows.put("8201", "8140");
        prostateRows.put("8260", "8140");
        prostateRows.put("8230", "8140");
        prostateRows.put("8500", "8140");
        prostateRows.put("8572", "8140");
        prostateRows.put("8480", "8140");
        prostateRows.put("8490", "8140");
        prostateRows.put("8574/3", "8574/3");
        prostateRows.put("8560", "8560");
        prostateRows.put("8147", "8147");
        prostateRows.put("8552", "8552");
        prostateRows.put("8240/3", "8240/3");
        prostateRows.put("8013/3", "8240/3");
        prostateRows.put("8041/3", "8240/3");
        prostateRows.put("8800/3", "8800/3");
        prostateRows.put("8935/3", "8800/3");
        prostateRows.put("8890/3", "8800/3");
        prostateRows.put("8900/3", "8800/3");
        prostateRows.put("9120/3", "8800/3");
        prostateRows.put("9040/3", "8800/3");
        prostateRows.put("9180/3", "8800/3");
        prostateRows.put("8802/3", "8800/3");
        prostateRows.put("8815/3", "8800/3");
        prostateRows.put("8070", "8070");
        prostateRows.put("8120", "8120");
        content.put(PROSTATE, prostateRows);
        HashMap<String, String> testisRows = new HashMap<String, String>();
        testisRows.put("9064", "9064");
        testisRows.put("9100", "9064");
        testisRows.put("9070", "9064");
        testisRows.put("9063", "9064");
        testisRows.put("9071", "9064");
        testisRows.put("9084", "9064");
        testisRows.put("8650/3", "8650/3");
        testisRows.put("8640/3", "8640/3");
        testisRows.put("9061", "9061");
        for (String string28 : TESTIS_SITES) {
            content.put(string28, testisRows);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("8140", "8140");
        hashMap.put("8200", "8200");
        hashMap.put("8560", "8560");
        hashMap.put("8936", "8936");
        hashMap.put("8430", "8430");
        hashMap.put("8720/3", "8720/3");
        hashMap.put("8070", "8070");
        hashMap.put("8083", "8070");
        hashMap.put("8074", "8070");
        hashMap.put("8051", "8070");
        hashMap.put("8020/3", "8020/3");
        hashMap.put("8240/3", "8240/3");
        hashMap.put("8246/3", "8240/3");
        hashMap.put("8013/3", "8240/3");
        hashMap.put("8041/3", "8240/3");
        hashMap.put("8154/3", "8154/3");
        for (String string29 : ESOPHAGUS_SITES) {
            content.put(string29, hashMap);
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("8140", "8140");
        hashMap2.put("8145/3", "8140");
        hashMap2.put("8144", "8140");
        hashMap2.put("8576", "8140");
        hashMap2.put("8512", "8140");
        hashMap2.put("8265", "8140");
        hashMap2.put("8480", "8140");
        hashMap2.put("8430", "8140");
        hashMap2.put("8260", "8140");
        hashMap2.put("8214", "8140");
        hashMap2.put("8490", "8140");
        hashMap2.put("8211", "8140");
        hashMap2.put("8210/2", "8210/2");
        hashMap2.put("8560", "8560");
        hashMap2.put("8936", "8936");
        hashMap2.put("8976/3", "8976/3");
        hashMap2.put("8148/2", "8148/2");
        hashMap2.put("8244/3", "8244/3");
        hashMap2.put("8154/3", "8154/3");
        hashMap2.put("8246/3", "8246/3");
        hashMap2.put("8013/3", "8246/3");
        hashMap2.put("8041/3", "8246/3");
        hashMap2.put("8240/3", "8240/3");
        hashMap2.put("8242/3", "8240/3");
        hashMap2.put("8241/3", "8240/3");
        hashMap2.put("8153/3", "8240/3");
        hashMap2.put("8249/3", "8240/3");
        hashMap2.put("8213/2", "8213/2");
        hashMap2.put("8070", "8070");
        hashMap2.put("8020/3", "8020/3");
        hashMap2.put("8035/3", "8020/3");
        hashMap2.put("8014/3", "8020/3");
        hashMap2.put("8022/3", "8020/3");
        hashMap2.put("8033/3", "8020/3");
        for (String string30 : STOMACH_SITES) {
            content.put(string30, hashMap2);
        }
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("8140", "8140");
        hashMap3.put("8144", "8140");
        hashMap3.put("8510", "8140");
        hashMap3.put("8480", "8140");
        hashMap3.put("8163", "8140");
        hashMap3.put("8490", "8140");
        hashMap3.put("8211", "8140");
        hashMap3.put("8210/2", "8210/2");
        hashMap3.put("8936", "8936");
        hashMap3.put("8154/3", "8154/3");
        hashMap3.put("8246/3", "8246/3");
        hashMap3.put("8013/3", "8246/3");
        hashMap3.put("8041/3", "8246/3");
        hashMap3.put("8240/3", "8240/3");
        hashMap3.put("8249/3", "8240/3");
        hashMap3.put("8213/2", "8213/2");
        for (String string31 : INTESTINE_SITES) {
            content.put(string31, hashMap3);
        }
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("8140", "8140");
        hashMap4.put("8154/3", "8154/3");
        hashMap4.put("8720/3", "8720/3");
        hashMap4.put("8246/3", "8246/3");
        hashMap4.put("8013/3", "8246/3");
        hashMap4.put("8041/3", "8246/3");
        hashMap4.put("8240/3", "8240/3");
        hashMap4.put("8249/3", "8240/3");
        hashMap4.put("8070", "8070");
        hashMap4.put("8086", "8070");
        hashMap4.put("8085", "8070");
        hashMap4.put("8051", "8070");
        hashMap4.put("8077/2", "8077/2");
        for (String string32 : ANUS_SITES) {
            content.put(string32, hashMap4);
        }
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        hashMap5.put("8020/3", "8020/3");
        hashMap5.put("8160", "8160");
        hashMap5.put("8180", "8180");
        hashMap5.put("8970/3", "8970/3");
        hashMap5.put("8170", "8170");
        hashMap5.put("8171", "8170");
        hashMap5.put("8172", "8170");
        hashMap5.put("8174", "8170");
        hashMap5.put("8503", "8503");
        hashMap5.put("8154/3", "8154/3");
        hashMap5.put("8470", "8470");
        hashMap5.put("8246/3", "8246/3");
        hashMap5.put("8013/3", "8246/3");
        hashMap5.put("8041/3", "8246/3");
        hashMap5.put("8240/3", "8240/3");
        hashMap5.put("8249/3", "8240/3");
        for (String string33 : LIVER_SITES) {
            content.put(string33, hashMap5);
        }
        HashMap<String, String> hashMap6 = new HashMap<String, String>();
        hashMap6.put("8140", "8140");
        hashMap6.put("8144", "8140");
        hashMap6.put("8310", "8140");
        hashMap6.put("8480", "8140");
        hashMap6.put("8163", "8140");
        hashMap6.put("8490", "8140");
        hashMap6.put("8560", "8560");
        hashMap6.put("8160", "8160");
        hashMap6.put("8161", "8160");
        hashMap6.put("8162", "8160");
        hashMap6.put("8148/2", "8148/2");
        hashMap6.put("8010", "8010");
        hashMap6.put("8020", "8010");
        hashMap6.put("8503", "8503");
        hashMap6.put("8154/3", "8154/3");
        hashMap6.put("8470/3", "8470/3");
        hashMap6.put("8246/3", "8246/3");
        hashMap6.put("8013/3", "8246/3");
        hashMap6.put("8041/3", "8246/3");
        hashMap6.put("8240/3", "8240/3");
        hashMap6.put("8249/3", "8240/3");
        hashMap6.put("8070", "8070");
        for (String string34 : BLADDER_SITES) {
            content.put(string34, hashMap6);
        }
        HashMap<String, String> hashMap7 = new HashMap<String, String>();
        hashMap7.put("8140", "8140");
        hashMap7.put("8550", "8140");
        hashMap7.put("8480", "8140");
        hashMap7.put("8500", "8140");
        hashMap7.put("8576", "8140");
        hashMap7.put("8265", "8140");
        hashMap7.put("8510", "8140");
        hashMap7.put("8552", "8140");
        hashMap7.put("8154/3", "8140");
        hashMap7.put("8490", "8140");
        hashMap7.put("8560", "8560");
        hashMap7.put("8148/2", "8148/2");
        hashMap7.put("8455", "8455");
        hashMap7.put("8453", "8453");
        hashMap7.put("8503", "8503");
        hashMap7.put("8154", "8154");
        hashMap7.put("8470", "8470");
        hashMap7.put("8246", "8246");
        hashMap7.put("8013", "8246");
        hashMap7.put("8041", "8246");
        hashMap7.put("8240", "8240");
        hashMap7.put("8158", "8240");
        hashMap7.put("8241", "8240");
        hashMap7.put("8153", "8240");
        hashMap7.put("8152", "8240");
        hashMap7.put("8151", "8240");
        hashMap7.put("8249", "8240");
        hashMap7.put("8150", "8240");
        hashMap7.put("8156", "8240");
        hashMap7.put("8155", "8240");
        hashMap7.put("8971/3", "8971/3");
        hashMap7.put("8452", "8452");
        hashMap7.put("8070", "8070");
        hashMap7.put("8020/3", "8020/3");
        hashMap7.put("8035/3", "8020/3");
        hashMap7.put("8014/3", "8020/3");
        for (String site : PANCREAS_SITES) {
            content.put(site, hashMap7);
        }
        HashMap<String, String> hashMap8 = new HashMap<String, String>();
        hashMap8.put("8021/3", "8021/3");
        hashMap8.put("8020/3", "8021/3");
        hashMap8.put("8330", "8330");
        hashMap8.put("8339/3", "8330");
        hashMap8.put("8335/3", "8330");
        hashMap8.put("8331", "8330");
        hashMap8.put("8332", "8330");
        hashMap8.put("8345", "8345");
        hashMap8.put("8290", "8290");
        hashMap8.put("8260", "8260");
        hashMap8.put("8344", "8260");
        hashMap8.put("8350", "8260");
        hashMap8.put("8343/3", "8260");
        hashMap8.put("8340", "8260");
        hashMap8.put("8342", "8260");
        hashMap8.put("8337/3", "8337/3");
        content.put(THYROID, hashMap8);
        HashMap<String, String> ovaryRows = new HashMap<String, String>();
        ovaryRows.put("8140", "8140");
        ovaryRows.put("8310", "8140");
        ovaryRows.put("8380", "8140");
        ovaryRows.put("8480", "8140");
        ovaryRows.put("9110/3", "9110/3");
        ovaryRows.put("8933/3", "8933/3");
        ovaryRows.put("8620/3", "8620/3");
        ovaryRows.put("8980/3", "8980/3");
        ovaryRows.put("9100", "9100");
        ovaryRows.put("9064", "9064");
        ovaryRows.put("9080", "9064");
        ovaryRows.put("9060", "9064");
        ovaryRows.put("9071/3", "9064");
        ovaryRows.put("9070", "9064");
        ovaryRows.put("9085", "9064");
        ovaryRows.put("9000/3", "9000/3");
        ovaryRows.put("9111/3", "9111/3");
        ovaryRows.put("8800/3", "8800/3");
        ovaryRows.put("8930/3", "8800/3");
        ovaryRows.put("8931/3", "8800/3");
        ovaryRows.put("8890/3", "8800/3");
        ovaryRows.put("8810/3", "8800/3");
        ovaryRows.put("8441", "8441");
        ovaryRows.put("8461/3", "8441");
        ovaryRows.put("8460", "8441");
        ovaryRows.put("8044/3", "8044/3");
        ovaryRows.put("8670/3", "8670/3");
        ovaryRows.put("9090/3", "9090/3");
        ovaryRows.put("9084/3", "9084/3");
        ovaryRows.put("8020/3", "8020/3");
        content.put(OVARY, ovaryRows);
        HashMap<String, String> peritoneumRows = new HashMap<String, String>();
        peritoneumRows.put("8936/3", "8936/3");
        peritoneumRows.put("8461/3", "8461/3");
        peritoneumRows.put("8460/3", "8460/3");
        peritoneumRows.put("9050/3", "9050/3");
        peritoneumRows.put("9051/3", "9050/3");
        peritoneumRows.put("9052/3", "9050/3");
        peritoneumRows.put("9053/3", "9050/3");
        peritoneumRows.put("8800/3", "8800/3");
        peritoneumRows.put("8806/3", "8800/3");
        peritoneumRows.put("8930/3", "8800/3");
        peritoneumRows.put("8931/3", "8800/3");
        peritoneumRows.put("8815/3", "8815/3");
        content.put(PERITONEUM, peritoneumRows);
        HashMap<String, String> fallopianRows = new HashMap<String, String>();
        fallopianRows.put("8933/3", "8933/3");
        fallopianRows.put("8980/3", "8980/3");
        fallopianRows.put("8380", "8380");
        fallopianRows.put("8441", "8441");
        fallopianRows.put("8460/3", "8441");
        fallopianRows.put("8461/3", "8441");
        fallopianRows.put("9080/3", "9080/3");
        content.put(FALLOPIAN, fallopianRows);
        HashMap<String, String> uterineCorpusRows = new HashMap<String, String>();
        uterineCorpusRows.put("8933/3", "8933/3");
        uterineCorpusRows.put("8020/3", "8020/3");
        uterineCorpusRows.put("8980/3", "8980/3");
        uterineCorpusRows.put("8310", "8310");
        uterineCorpusRows.put("8380", "8380");
        uterineCorpusRows.put("8570/3", "8380");
        uterineCorpusRows.put("9110/3", "9110/3");
        uterineCorpusRows.put("9111/3", "9110/3");
        uterineCorpusRows.put("8323", "8323");
        uterineCorpusRows.put("8480", "8480");
        uterineCorpusRows.put("8144", "8480");
        uterineCorpusRows.put("8246/3", "8246/3");
        uterineCorpusRows.put("8013/3", "8246/3");
        uterineCorpusRows.put("8154/3", "8246/3");
        uterineCorpusRows.put("8041/3", "8246/3");
        uterineCorpusRows.put("8714/3", "8714/3");
        uterineCorpusRows.put("9473/3", "9473/3");
        uterineCorpusRows.put("8800/3", "8800/3");
        uterineCorpusRows.put("8930/3", "8800/3");
        uterineCorpusRows.put("8931/3", "8800/3");
        uterineCorpusRows.put("8891/3", "8800/3");
        uterineCorpusRows.put("8890/3", "8800/3");
        uterineCorpusRows.put("8896/3", "8800/3");
        uterineCorpusRows.put("8805/3", "8800/3");
        uterineCorpusRows.put("8441", "8441");
        uterineCorpusRows.put("8070", "8070");
        for (String string35 : UTERINE_CORPUS_SITES) {
            content.put(string35, uterineCorpusRows);
        }
        HashMap<String, String> uterineCervixRows = new HashMap<String, String>();
        uterineCervixRows.put("8140/3", "8140/3");
        uterineCervixRows.put("8483/3", "8140/3");
        uterineCervixRows.put("8484/3", "8140/3");
        uterineCervixRows.put("8482/3", "8140/3");
        uterineCervixRows.put("8310/3", "8140/3");
        uterineCervixRows.put("9110/3", "8140/3");
        uterineCervixRows.put("8098/3", "8098/3");
        uterineCervixRows.put("8933/3", "8933/3");
        uterineCervixRows.put("8560/3", "8560/3");
        uterineCervixRows.put("8980/3", "8980/3");
        uterineCervixRows.put("8380/3", "8380/3");
        uterineCervixRows.put("9064/3", "9064/3");
        uterineCervixRows.put("9100/3", "9064/3");
        uterineCervixRows.put("9071/3", "9064/3");
        uterineCervixRows.put("8430/3", "8430/3");
        uterineCervixRows.put("8246/3", "8246/3");
        uterineCervixRows.put("8013/3", "8246/3");
        uterineCervixRows.put("8154/3", "8246/3");
        uterineCervixRows.put("8041/3", "8246/3");
        uterineCervixRows.put("8240/3", "8240/3");
        uterineCervixRows.put("8249/3", "8240/3");
        uterineCervixRows.put("8714/3", "8714/3");
        uterineCervixRows.put("8800/3", "8800/3");
        uterineCervixRows.put("8930/3", "8800/3");
        uterineCervixRows.put("8931/3", "8800/3");
        uterineCervixRows.put("8891/3", "8800/3");
        uterineCervixRows.put("8890/3", "8800/3");
        uterineCervixRows.put("8896/3", "8800/3");
        uterineCervixRows.put("8805/3", "8800/3");
        uterineCervixRows.put("8070/3", "8070/3");
        uterineCervixRows.put("8085/3", "8070/3");
        uterineCervixRows.put("8086/3", "8070/3");
        for (String site : UTERINE_CERVIX_SITES) {
            content.put(site, uterineCervixRows);
        }
        HashMap<String, String> hashMap9 = new HashMap<String, String>();
        hashMap9.put("8140", "8140");
        hashMap9.put("8483", "8140");
        hashMap9.put("8098", "8098");
        hashMap9.put("8933/3", "8933/3");
        hashMap9.put("8560", "8560");
        hashMap9.put("8980/3", "8980/3");
        hashMap9.put("8310", "8310");
        hashMap9.put("8380", "8380");
        hashMap9.put("9064/3", "9064/3");
        hashMap9.put("9071/3", "9064/3");
        hashMap9.put("9110/3", "9110/3");
        hashMap9.put("8480", "8480");
        hashMap9.put("8482", "8480");
        hashMap9.put("8144", "8480");
        hashMap9.put("8720/3", "8720/3");
        hashMap9.put("8246/3", "8246/3");
        hashMap9.put("8045/3", "8246/3");
        hashMap9.put("8013/3", "8246/3");
        hashMap9.put("8041/3", "8246/3");
        hashMap9.put("8240/3", "8240/3");
        hashMap9.put("8070", "8070");
        hashMap9.put("8077/2", "8070");
        hashMap9.put("8085", "8070");
        hashMap9.put("8086", "8070");
        hashMap9.put("8020/3", "8020/3");
        content.put(VAGINA, hashMap9);
        HashMap<String, String> vulvaRows = new HashMap<String, String>();
        vulvaRows.put("8140", "8140");
        vulvaRows.put("8144", "8140");
        vulvaRows.put("8200", "8200");
        vulvaRows.put("8560", "8560");
        vulvaRows.put("8090", "8090");
        vulvaRows.put("8020/3", "8020/3");
        vulvaRows.put("8562/3", "8562/3");
        vulvaRows.put("9064/3", "9064/3");
        vulvaRows.put("9071/3", "9064/3");
        vulvaRows.put("8720/3", "8720/3");
        vulvaRows.put("8982/3", "8982/3");
        vulvaRows.put("8246/3", "8246/3");
        vulvaRows.put("8045/3", "8246/3");
        vulvaRows.put("8013/3", "8246/3");
        vulvaRows.put("8041/3", "8246/3");
        vulvaRows.put("8240/3", "8240/3");
        vulvaRows.put("8249/3", "8240/3");
        vulvaRows.put("8542/3", "8542/3");
        vulvaRows.put("9020/3", "9020/3");
        vulvaRows.put("8070", "8070");
        vulvaRows.put("8085", "8070");
        vulvaRows.put("8086", "8070");
        vulvaRows.put("8071", "8070");
        vulvaRows.put("8072", "8070");
        vulvaRows.put("8077/2", "8070");
        vulvaRows.put("8400", "8400");
        vulvaRows.put("8200", "8400");
        vulvaRows.put("8401", "8400");
        vulvaRows.put("8413", "8400");
        vulvaRows.put("8409", "8400");
        for (String string36 : VULVA_SITES) {
            content.put(string36, vulvaRows);
        }
        HashMap<String, String> softTissueRows = new HashMap<String, String>();
        softTissueRows.put("9120/3", "9120/3");
        softTissueRows.put("9133/3", "9133/3");
        softTissueRows.put("8810/3", "8810/3");
        softTissueRows.put("8814/3", "8810/3");
        softTissueRows.put("8840/3", "8810/3");
        softTissueRows.put("8825/3", "8810/3");
        softTissueRows.put("8811/3", "8810/3");
        softTissueRows.put("8815/3", "8810/3");
        softTissueRows.put("8890/3", "8890/3");
        softTissueRows.put("8850/3", "8850/3");
        softTissueRows.put("8859/3", "8850/3");
        softTissueRows.put("8858/3", "8850/3");
        softTissueRows.put("8854/3", "8850/3");
        softTissueRows.put("8852/3", "8850/3");
        softTissueRows.put("8851/3", "8850/3");
        softTissueRows.put("9180/3", "9180/3");
        softTissueRows.put("8900/3", "8900/3");
        softTissueRows.put("8920/3", "8900/3");
        softTissueRows.put("8921/3", "8900/3");
        softTissueRows.put("8910/3", "8900/3");
        softTissueRows.put("8901/3", "8900/3");
        softTissueRows.put("8912/3", "8900/3");
        softTissueRows.put("8800/3", "8800/3");
        softTissueRows.put("9044/3", "8800/3");
        softTissueRows.put("9043/3", "8800/3");
        softTissueRows.put("9367/3", "8800/3");
        softTissueRows.put("8804/3", "8800/3");
        softTissueRows.put("9364/3", "8800/3");
        softTissueRows.put("9231/3", "8800/3");
        softTissueRows.put("8940/3", "8800/3");
        softTissueRows.put("8982/3", "8800/3");
        softTissueRows.put("8842/3", "8800/3");
        softTissueRows.put("8990/3", "8800/3");
        softTissueRows.put("9366/3", "8800/3");
        softTissueRows.put("9368/3", "8800/3");
        softTissueRows.put("9040/3", "8800/3");
        softTissueRows.put("9043/3", "8800/3");
        softTissueRows.put("8805/3", "8805/3");
        softTissueRows.put("8802/3", "8805/3");
        softTissueRows.put("8803/3", "8805/3");
        softTissueRows.put("8801/3", "8805/3");
        for (String string37 : SOFT_TISSUES_SITES) {
            content.put(string37, softTissueRows);
        }
        HashMap<String, String> hashMap10 = new HashMap<String, String>();
        hashMap10.put("9261/3", "9261/3");
        hashMap10.put("9120/3", "9120/3");
        hashMap10.put("9220/3", "9220/3");
        hashMap10.put("9222/3", "9220/3");
        hashMap10.put("9242/3", "9220/3");
        hashMap10.put("9243/3", "9220/3");
        hashMap10.put("9240/3", "9220/3");
        hashMap10.put("9221/3", "9220/3");
        hashMap10.put("9370/3", "9370/3");
        hashMap10.put("9371/3", "9370/3");
        hashMap10.put("9372/3", "9370/3");
        hashMap10.put("9133/3", "9133/3");
        hashMap10.put("8810/3", "8810/3");
        hashMap10.put("9250/3", "9250/3");
        hashMap10.put("8890/3", "8890/3");
        hashMap10.put("9180/3", "9180/3");
        hashMap10.put("9194/3", "9180/3");
        hashMap10.put("9192/3", "9180/3");
        hashMap10.put("9193/3", "9180/3");
        hashMap10.put("9184/3", "9180/3");
        hashMap10.put("8800/3", "8800/3");
        hashMap10.put("9367/3", "8800/3");
        hashMap10.put("9364/3", "8800/3");
        hashMap10.put("9366/3", "8800/3");
        hashMap10.put("9368/3", "8800/3");
        hashMap10.put("8802/3", "8802/3");
        hashMap10.put("8830/3", "8830/3");
        for (String site : BONE_SITES) {
            content.put(site, hashMap10);
        }
        HashMap<String, String> hashMap11 = new HashMap<String, String>();
        hashMap11.put("8144/3", "8140");
        hashMap11.put("8260/2", "8140");
        hashMap11.put("8200/3", "8140");
        hashMap11.put("8140", "8140");
        hashMap11.put("8560/3", "8560/3");
        hashMap11.put("8980/3", "8980/3");
        hashMap11.put("8310/3", "8310/3");
        hashMap11.put("8430/3", "8430/3");
        hashMap11.put("8045/3", "8246/3");
        hashMap11.put("8013/3", "8246/3");
        hashMap11.put("8041/3", "8246/3");
        hashMap11.put("8246/3", "8246/3");
        hashMap11.put("8249/3", "8240/3");
        hashMap11.put("8240/3", "8240/3");
        hashMap11.put("8023/3", "8023/3");
        hashMap11.put("8033/3", "8033/3");
        hashMap11.put("8123/3", "8070");
        hashMap11.put("8083/3", "8070");
        hashMap11.put("8082/3", "8070");
        hashMap11.put("8070", "8070");
        hashMap11.put("8586/3", "8586/3");
        hashMap11.put("8580/3", "8580/3");
        hashMap11.put("8581/3", "8580/3");
        hashMap11.put("8582/3", "8580/3");
        hashMap11.put("8583/3", "8580/3");
        hashMap11.put("8584/3", "8580/3");
        hashMap11.put("8585/3", "8580/3");
        hashMap11.put("8020/3", "8020/3");
        content.put(THYMUS, hashMap11);
        HashMap<String, String> penisAndScrotumRows = new HashMap<String, String>();
        penisAndScrotumRows.put("8140", "8140");
        penisAndScrotumRows.put("8560", "8140");
        penisAndScrotumRows.put("8430", "8140");
        penisAndScrotumRows.put("8720/3", "8720/3");
        penisAndScrotumRows.put("8542/3", "8542/3");
        penisAndScrotumRows.put("8070", "8070");
        penisAndScrotumRows.put("8083", "8070");
        penisAndScrotumRows.put("8084", "8070");
        penisAndScrotumRows.put("8071/2", "8070");
        penisAndScrotumRows.put("8077/2", "8070");
        penisAndScrotumRows.put("8082", "8070");
        penisAndScrotumRows.put("8052", "8070");
        penisAndScrotumRows.put("8075", "8070");
        penisAndScrotumRows.put("8074", "8070");
        penisAndScrotumRows.put("8085", "8070");
        penisAndScrotumRows.put("8086", "8070");
        penisAndScrotumRows.put("8051", "8070");
        penisAndScrotumRows.put("8054", "8070");
        for (String site : PENIS_AND_SCROTUM_SITES) {
            content.put(site, penisAndScrotumRows);
        }
        OTHER_SITES_2023_TABLE_ROWS_FOR_SITE = Collections.unmodifiableMap(content);
        OTHER_SITES_2023_TABLE_2 = Collections.unmodifiableList(Arrays.asList("8045", "8013", "8094", "8552", "8154", "8180", "8244", "8255", "8323", "8340", "8346", "8347", "8560", "8855", "8902", "9081", "9085", "9101"));
        content = new HashMap();
        HashMap<String, String> prostateSubtypes = new HashMap<String, String>();
        prostateSubtypes.put("8572", "8572");
        prostateSubtypes.put("8500", "8201,8260,8230");
        prostateSubtypes.put("8201", "8201");
        prostateSubtypes.put("8260", "8260");
        prostateSubtypes.put("8230", "8230");
        prostateSubtypes.put("8480", "8480");
        prostateSubtypes.put("8490", "8490");
        prostateSubtypes.put("8013/3", "8013/3");
        prostateSubtypes.put("8041/3", "8041/3");
        prostateSubtypes.put("8935/3", "8935/3");
        prostateSubtypes.put("8890/3", "8890/3");
        prostateSubtypes.put("8900/3", "8900/3");
        prostateSubtypes.put("9120/3", "9120/3");
        prostateSubtypes.put("9040/3", "9040/3");
        prostateSubtypes.put("9180/3", "9180/3");
        prostateSubtypes.put("8802/3", "8802/3");
        prostateSubtypes.put("8815/3", "8815/3");
        content.put(PROSTATE, prostateSubtypes);
        HashMap<String, String> testisSubtypes = new HashMap<String, String>();
        testisSubtypes.put("9100", "9100");
        testisSubtypes.put("9070", "9070");
        testisSubtypes.put("9063", "9063");
        testisSubtypes.put("9071", "9071");
        testisSubtypes.put("9084", "9084");
        for (String string38 : TESTIS_SITES) {
            content.put(string38, testisSubtypes);
        }
        HashMap<String, String> hashMap12 = new HashMap<String, String>();
        hashMap12.put("8083", "8083");
        hashMap12.put("8074", "8074");
        hashMap12.put("8051", "8051");
        hashMap12.put("8246/3", "8246/3");
        hashMap12.put("8013/3", "8013/3");
        hashMap12.put("8041/3", "8041/3");
        for (String string39 : ESOPHAGUS_SITES) {
            content.put(string39, hashMap12);
        }
        HashMap<String, String> hashMap13 = new HashMap<String, String>();
        hashMap13.put("8145/3", "8145/3");
        hashMap13.put("8144", "8144");
        hashMap13.put("8576", "8576");
        hashMap13.put("8512", "8512");
        hashMap13.put("8265", "8265");
        hashMap13.put("8480", "8480");
        hashMap13.put("8430", "8430");
        hashMap13.put("8260", "8260");
        hashMap13.put("8214", "8214");
        hashMap13.put("8490", "8490");
        hashMap13.put("8211", "8211");
        hashMap13.put("8013/3", "8013/3");
        hashMap13.put("8041/3", "8041/3");
        hashMap13.put("8242/3", "8242/3");
        hashMap13.put("8241/3", "8241/3");
        hashMap13.put("8153/3", "8153/3");
        hashMap13.put("8249/3", "8249/3");
        hashMap13.put("8035/3", "8035/3");
        hashMap13.put("8014/3", "8014/3");
        hashMap13.put("8022/3", "8022/3");
        hashMap13.put("8033/3", "8033/3");
        for (String string40 : STOMACH_SITES) {
            content.put(string40, hashMap13);
        }
        HashMap<String, String> hashMap14 = new HashMap<String, String>();
        hashMap14.put("8144", "8144");
        hashMap14.put("8510", "8510");
        hashMap14.put("8480", "8480");
        hashMap14.put("8163", "8163");
        hashMap14.put("8490", "8490");
        hashMap14.put("8211", "8211");
        hashMap14.put("8013/3", "8013/3");
        hashMap14.put("8041/3", "8041/3");
        hashMap14.put("8249/3", "8249/3");
        for (String string41 : INTESTINE_SITES) {
            content.put(string41, hashMap14);
        }
        HashMap<String, String> hashMap15 = new HashMap<String, String>();
        hashMap15.put("8013/3", "8013/3");
        hashMap15.put("8041/3", "8041/3");
        hashMap15.put("8249/3", "8249/3");
        hashMap15.put("8086", "8086");
        hashMap15.put("8085", "8085");
        hashMap15.put("8051", "8051");
        for (String string42 : ANUS_SITES) {
            content.put(string42, hashMap15);
        }
        HashMap<String, String> hashMap16 = new HashMap<String, String>();
        hashMap16.put("8171", "8171");
        hashMap16.put("8172", "8172");
        hashMap16.put("8174", "8174");
        hashMap16.put("8013/3", "8013/3");
        hashMap16.put("8041/3", "8041/3");
        hashMap16.put("8249/3", "8249/3");
        for (String string43 : LIVER_SITES) {
            content.put(string43, hashMap16);
        }
        HashMap<String, String> hashMap17 = new HashMap<String, String>();
        hashMap17.put("8144", "8144");
        hashMap17.put("8310", "8310");
        hashMap17.put("8480", "8480");
        hashMap17.put("8163", "8163");
        hashMap17.put("8490", "8490");
        hashMap17.put("8161", "8161");
        hashMap17.put("8162", "8162");
        hashMap17.put("8020", "8020");
        hashMap17.put("8013/3", "8013/3");
        hashMap17.put("8041/3", "8041/3");
        hashMap17.put("8249/3", "8249/3");
        for (String string44 : BLADDER_SITES) {
            content.put(string44, hashMap17);
        }
        HashMap<String, String> hashMap18 = new HashMap<String, String>();
        hashMap18.put("8550", "8550");
        hashMap18.put("8480", "8480");
        hashMap18.put("8500", "8500");
        hashMap18.put("8576", "8576");
        hashMap18.put("8265", "8265");
        hashMap18.put("8510", "8510");
        hashMap18.put("8552", "8552");
        hashMap18.put("8154/3", "8154/3");
        hashMap18.put("8490", "8490");
        hashMap18.put("8013", "8013");
        hashMap18.put("8041", "8041");
        hashMap18.put("8158", "8158");
        hashMap18.put("8241", "8241");
        hashMap18.put("8153", "8153");
        hashMap18.put("8152", "8152");
        hashMap18.put("8151", "8151");
        hashMap18.put("8249", "8249");
        hashMap18.put("8150", "8150");
        hashMap18.put("8156", "8156");
        hashMap18.put("8155", "8155");
        hashMap18.put("8035/3", "8035/3");
        hashMap18.put("8014/3", "8014/3");
        for (String site : PANCREAS_SITES) {
            content.put(site, hashMap18);
        }
        HashMap<String, String> hashMap19 = new HashMap<String, String>();
        hashMap19.put("8020/3", "8021/3");
        hashMap19.put("8339/3", "8339/3");
        hashMap19.put("8335/3", "8335/3");
        hashMap19.put("8331", "8331");
        hashMap19.put("8332", "8332");
        hashMap19.put("8344", "8344");
        hashMap19.put("8350", "8350");
        hashMap19.put("8343/3", "8343/3");
        hashMap19.put("8340", "8340");
        hashMap19.put("8342", "8342");
        content.put(THYROID, hashMap19);
        HashMap<String, String> ovarySubtypes = new HashMap<String, String>();
        ovarySubtypes.put("8310", "8310");
        ovarySubtypes.put("8380", "8380");
        ovarySubtypes.put("8480", "8480");
        ovarySubtypes.put("9080", "9080");
        ovarySubtypes.put("9060", "9060");
        ovarySubtypes.put("9071/3", "9071/3");
        ovarySubtypes.put("9070", "9070");
        ovarySubtypes.put("9085", "9085");
        ovarySubtypes.put("8930/3", "8930/3");
        ovarySubtypes.put("8931/3", "8931/3");
        ovarySubtypes.put("8890/3", "8890/3");
        ovarySubtypes.put("8810/3", "8810/3");
        ovarySubtypes.put("8461/3", "8461/3");
        ovarySubtypes.put("8460/3", "8460/3");
        ovarySubtypes.put("8460/2", "8460/2");
        content.put(OVARY, ovarySubtypes);
        HashMap<String, String> peritoneumSubtypes = new HashMap<String, String>();
        peritoneumSubtypes.put("9051/3", "9051/3");
        peritoneumSubtypes.put("9052/3", "9052/3");
        peritoneumSubtypes.put("9053/3", "9053/3");
        peritoneumSubtypes.put("8806/3", "8806/3");
        peritoneumSubtypes.put("8930/3", "8930/3");
        peritoneumSubtypes.put("8931/3", "8931/3");
        content.put(PERITONEUM, peritoneumSubtypes);
        HashMap<String, String> fallopianSubtypes = new HashMap<String, String>();
        fallopianSubtypes.put("8461/3", "8461/3");
        fallopianSubtypes.put("8460/3", "8460/3");
        content.put(FALLOPIAN, fallopianSubtypes);
        HashMap<String, String> uterineCorpusSubtypes = new HashMap<String, String>();
        uterineCorpusSubtypes.put("8570/3", "8570/3");
        uterineCorpusSubtypes.put("9111/3", "9111/3");
        uterineCorpusSubtypes.put("8144", "8144");
        uterineCorpusSubtypes.put("8013/3", "8013/3");
        uterineCorpusSubtypes.put("8154/3", "8154/3");
        uterineCorpusSubtypes.put("8041/3", "8041/3");
        uterineCorpusSubtypes.put("8930/3", "8930/3");
        uterineCorpusSubtypes.put("8931/3", "8931/3");
        uterineCorpusSubtypes.put("8891/3", "8891/3");
        uterineCorpusSubtypes.put("8890/3", "8890/3");
        uterineCorpusSubtypes.put("8896/3", "8896/3");
        uterineCorpusSubtypes.put("8805/3", "8805/3");
        for (String string45 : UTERINE_CORPUS_SITES) {
            content.put(string45, uterineCorpusSubtypes);
        }
        HashMap<String, String> uterineCervixSubtypes = new HashMap<String, String>();
        uterineCervixSubtypes.put("8483/3", "8483/3");
        uterineCervixSubtypes.put("8484/3", "8484/3");
        uterineCervixSubtypes.put("8482/3", "8482/3");
        uterineCervixSubtypes.put("8310/3", "8310/3");
        uterineCervixSubtypes.put("9110/3", "9110/3");
        uterineCervixSubtypes.put("9100/3", "9100/3");
        uterineCervixSubtypes.put("9071/3", "9071/3");
        uterineCervixSubtypes.put("8013/3", "8013/3");
        uterineCervixSubtypes.put("8154/3", "8154/3");
        uterineCervixSubtypes.put("8041/3", "8041/3");
        uterineCervixSubtypes.put("8249/3", "8249/3");
        uterineCervixSubtypes.put("8930/3", "8930/3");
        uterineCervixSubtypes.put("8931/3", "8931/3");
        uterineCervixSubtypes.put("8891/3", "8891/3");
        uterineCervixSubtypes.put("8890/3", "8890/3");
        uterineCervixSubtypes.put("8896/3", "8896/3");
        uterineCervixSubtypes.put("8805/3", "8805/3");
        uterineCervixSubtypes.put("8085/3", "8085/3");
        uterineCervixSubtypes.put("8086/3", "8086/3");
        for (String site : UTERINE_CERVIX_SITES) {
            content.put(site, uterineCervixSubtypes);
        }
        HashMap<String, String> hashMap20 = new HashMap<String, String>();
        hashMap20.put("8483", "8483");
        hashMap20.put("9071/3", "9071/3");
        hashMap20.put("8482", "8482");
        hashMap20.put("8144", "8144");
        hashMap20.put("8045/3", "8045/3");
        hashMap20.put("8013/3", "8013/3");
        hashMap20.put("8041/3", "8041/3");
        hashMap20.put("8077/2", "8077/2");
        hashMap20.put("8085", "8085");
        hashMap20.put("8086", "8086");
        content.put(VAGINA, hashMap20);
        HashMap<String, String> vulvaSubtypes = new HashMap<String, String>();
        vulvaSubtypes.put("8144", "8144");
        vulvaSubtypes.put("9071/3", "9071/3");
        vulvaSubtypes.put("8045/3", "8045/3");
        vulvaSubtypes.put("8013/3", "8013/3");
        vulvaSubtypes.put("8041/3", "8041/3");
        vulvaSubtypes.put("8249/3", "8249/3");
        vulvaSubtypes.put("8085", "8085");
        vulvaSubtypes.put("8086", "8086");
        vulvaSubtypes.put("8071", "8071");
        vulvaSubtypes.put("8072", "8072");
        vulvaSubtypes.put("8077/2", "8077/2");
        vulvaSubtypes.put("8200", "8200");
        vulvaSubtypes.put("8401", "8401");
        vulvaSubtypes.put("8413", "8413");
        vulvaSubtypes.put("8409", "8409");
        for (String string46 : VULVA_SITES) {
            content.put(string46, vulvaSubtypes);
        }
        HashMap<String, String> softTissueSubtypes = new HashMap<String, String>();
        softTissueSubtypes.put("8814/3", "8814/3");
        softTissueSubtypes.put("8840/3", "8840/3");
        softTissueSubtypes.put("8825/3", "8825/3");
        softTissueSubtypes.put("8811/3", "8811/3");
        softTissueSubtypes.put("8815/3", "8815/3");
        softTissueSubtypes.put("8858/3", "8858/3");
        softTissueSubtypes.put("8859/3", "8859/3");
        softTissueSubtypes.put("8854/3", "8854/3");
        softTissueSubtypes.put("8852/3", "8852/3");
        softTissueSubtypes.put("8851/3", "8851/3");
        softTissueSubtypes.put("8920/3", "8920/3");
        softTissueSubtypes.put("8921/3", "8921/3");
        softTissueSubtypes.put("8910/3", "8910/3");
        softTissueSubtypes.put("8901/3", "8901/3");
        softTissueSubtypes.put("8912/3", "8912/3");
        softTissueSubtypes.put("9367/3", "9367/3");
        softTissueSubtypes.put("9044/3", "9044/3");
        softTissueSubtypes.put("8804/3", "8804/3");
        softTissueSubtypes.put("9364/3", "9364/3");
        softTissueSubtypes.put("9231/3", "9231/3");
        softTissueSubtypes.put("8940/3", "8940/3");
        softTissueSubtypes.put("8982/3", "8982/3");
        softTissueSubtypes.put("8842/3", "8842/3");
        softTissueSubtypes.put("8990/3", "8990/3");
        softTissueSubtypes.put("9366/3", "9366/3");
        softTissueSubtypes.put("9368/3", "9368/3");
        softTissueSubtypes.put("9040/3", "9040/3,9043/3");
        softTissueSubtypes.put("9043/3", "9043/3");
        softTissueSubtypes.put("8802/3", "8802/3");
        softTissueSubtypes.put("8803/3", "8803/3");
        softTissueSubtypes.put("8801/3", "8801/3");
        for (String string47 : SOFT_TISSUES_SITES) {
            content.put(string47, softTissueSubtypes);
        }
        HashMap<String, String> hashMap21 = new HashMap<String, String>();
        hashMap21.put("9222/3", "9222/3");
        hashMap21.put("9242/3", "9242/3");
        hashMap21.put("9243/3", "9243/3");
        hashMap21.put("9240/3", "9240/3");
        hashMap21.put("9221/3", "9221/3");
        hashMap21.put("9371/3", "9371/3");
        hashMap21.put("9372/3", "9372/3");
        hashMap21.put("9194/3", "9194/3");
        hashMap21.put("9192/3", "9192/3");
        hashMap21.put("9193/3", "9193/3");
        hashMap21.put("9184/3", "9184/3");
        hashMap21.put("9367/3", "9367/3");
        hashMap21.put("9364/3", "9364/3");
        hashMap21.put("9366/3", "9366/3");
        hashMap21.put("9368/3", "9368/3");
        for (String site : BONE_SITES) {
            content.put(site, hashMap21);
        }
        HashMap<String, String> hashMap22 = new HashMap<String, String>();
        hashMap22.put("8144/3", "8144/3");
        hashMap22.put("8260/2", "8260/2");
        hashMap22.put("8200/3", "8200/3");
        hashMap22.put("8045/3", "8045/3");
        hashMap22.put("8013/3", "8013/3");
        hashMap22.put("8041/3", "8041/3");
        hashMap22.put("8249/3", "8249/3");
        hashMap22.put("8123/3", "8123/3");
        hashMap22.put("8083/3", "8083/3");
        hashMap22.put("8082/3", "8082/3");
        hashMap22.put("8581/3", "8581/3");
        hashMap22.put("8582/3", "8582/3");
        hashMap22.put("8583/3", "8583/3");
        hashMap22.put("8584/3", "8584/3");
        hashMap22.put("8585/3", "8585/3");
        content.put(THYMUS, hashMap22);
        HashMap<String, String> penisAndScrotumSubtypes = new HashMap<String, String>();
        penisAndScrotumSubtypes.put("8560", "8560");
        penisAndScrotumSubtypes.put("8430", "8430");
        penisAndScrotumSubtypes.put("8083", "8083");
        penisAndScrotumSubtypes.put("8084", "8084");
        penisAndScrotumSubtypes.put("8071/2", "8071/2");
        penisAndScrotumSubtypes.put("8077/2", "8077/2");
        penisAndScrotumSubtypes.put("8082", "8082");
        penisAndScrotumSubtypes.put("8052", "8052");
        penisAndScrotumSubtypes.put("8075", "8075");
        penisAndScrotumSubtypes.put("8074", "8074");
        penisAndScrotumSubtypes.put("8085", "8085");
        penisAndScrotumSubtypes.put("8086", "8086");
        penisAndScrotumSubtypes.put("8051", "8051");
        penisAndScrotumSubtypes.put("8054", "8054");
        for (String site : PENIS_AND_SCROTUM_SITES) {
            content.put(site, penisAndScrotumSubtypes);
        }
        OTHER_SITES_2023_TABLE_SUBTYPES_FOR_SITE = Collections.unmodifiableMap(content);
    }
}

