/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Map;

public class MpRuleDifferentRowInTable
extends MphRule {
    private Map<String, String> _table;

    public MpRuleDifferentRowInTable(String groupName, String step, Map<String, String> table) {
        super(groupName, step);
        this._table = table;
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        String row2;
        TempRuleResult result = new TempRuleResult();
        String h1 = i1.getHistology();
        String icd1 = i1.getIcdCode();
        String h2 = i2.getHistology();
        String icd2 = i2.getIcdCode();
        if (GroupUtility.sameHistologies(icd1, icd2)) {
            return result;
        }
        String row1 = this._table.containsKey(h1) ? this._table.get(h1) : this._table.get(icd1);
        String string = row2 = this._table.containsKey(h2) ? this._table.get(h2) : this._table.get(icd2);
        if (row1 == null || row2 == null) {
            result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
            result.setMessageNotInTable(this.getStep(), this.getGroupName(), row1, row2, icd1, icd2);
        } else if (!row1.equals(row2)) {
            result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
        }
        return result;
    }
}

