/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph;

import com.imsweb.mph.HematoDataProvider;
import com.imsweb.mph.internal.HematoDTO;
import de.siegmar.fastcsv.reader.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class DefaultHematoDataProvider
implements HematoDataProvider {
    private final Map<String, List<HematoDTO>> _samePrimaryDto = new HashMap<String, List<HematoDTO>>();
    private final Map<String, List<HematoDTO>> _transformToDto;
    private final Map<String, List<HematoDTO>> _transformFromDto;

    public DefaultHematoDataProvider() {
        CsvReader csvReader;
        InputStreamReader reader;
        InputStream is;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010SamePrimaryPairs.csv");
            try {
                if (is == null) {
                    throw new IllegalStateException("Unable to get Hematopoietic2010SamePrimaryPairs.csv");
                }
                reader = new InputStreamReader(is, StandardCharsets.US_ASCII);
                try {
                    csvReader = CsvReader.builder().ofNamedCsvRecord((Reader)reader);
                    try {
                        csvReader.stream().forEach(line -> {
                            Short endYear;
                            Short validStartYear = StringUtils.isNotBlank((CharSequence)line.getField(1)) ? Short.valueOf(line.getField(1)) : null;
                            Short validEndYear = StringUtils.isNotBlank((CharSequence)line.getField(2)) ? Short.valueOf(line.getField(2)) : null;
                            Short startYear = StringUtils.isNotBlank((CharSequence)line.getField(3)) ? Short.valueOf(line.getField(3)) : null;
                            Short s = endYear = StringUtils.isNotBlank((CharSequence)line.getField(4)) ? Short.valueOf(line.getField(4)) : null;
                            if (this._samePrimaryDto.containsKey(line.getField(0))) {
                                this._samePrimaryDto.get(line.getField(0)).add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                            } else {
                                ArrayList<HematoDTO> list = new ArrayList<HematoDTO>();
                                list.add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                                this._samePrimaryDto.put(line.getField(0), list);
                            }
                        });
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this._transformToDto = new HashMap<String, List<HematoDTO>>();
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010TransformToPairs.csv");
            try {
                if (is == null) {
                    throw new IllegalStateException("Unable to get Hematopoietic2010TransformToPairs.csv");
                }
                reader = new InputStreamReader(is, StandardCharsets.US_ASCII);
                try {
                    csvReader = CsvReader.builder().ofNamedCsvRecord((Reader)reader);
                    try {
                        csvReader.stream().forEach(line -> {
                            Short endYear;
                            Short validStartYear = StringUtils.isNotBlank((CharSequence)line.getField(1)) ? Short.valueOf(line.getField(1)) : null;
                            Short validEndYear = StringUtils.isNotBlank((CharSequence)line.getField(2)) ? Short.valueOf(line.getField(2)) : null;
                            Short startYear = StringUtils.isNotBlank((CharSequence)line.getField(3)) ? Short.valueOf(line.getField(3)) : null;
                            Short s = endYear = StringUtils.isNotBlank((CharSequence)line.getField(4)) ? Short.valueOf(line.getField(4)) : null;
                            if (this._transformToDto.containsKey(line.getField(0))) {
                                this._transformToDto.get(line.getField(0)).add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                            } else {
                                ArrayList<HematoDTO> list = new ArrayList<HematoDTO>();
                                list.add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                                this._transformToDto.put(line.getField(0), list);
                            }
                        });
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this._transformFromDto = new HashMap<String, List<HematoDTO>>();
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic2010TransformFromPairs.csv");
            try {
                if (is == null) {
                    throw new IllegalStateException("Unable to get Hematopoietic2010TransformFromPairs.csv");
                }
                reader = new InputStreamReader(is, StandardCharsets.US_ASCII);
                try {
                    csvReader = CsvReader.builder().ofNamedCsvRecord((Reader)reader);
                    try {
                        csvReader.stream().forEach(line -> {
                            Short endYear;
                            Short validStartYear = StringUtils.isNotBlank((CharSequence)line.getField(1)) ? Short.valueOf(line.getField(1)) : null;
                            Short validEndYear = StringUtils.isNotBlank((CharSequence)line.getField(2)) ? Short.valueOf(line.getField(2)) : null;
                            Short startYear = StringUtils.isNotBlank((CharSequence)line.getField(3)) ? Short.valueOf(line.getField(3)) : null;
                            Short s = endYear = StringUtils.isNotBlank((CharSequence)line.getField(4)) ? Short.valueOf(line.getField(4)) : null;
                            if (this._transformFromDto.containsKey(line.getField(0))) {
                                this._transformFromDto.get(line.getField(0)).add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                            } else {
                                ArrayList<HematoDTO> list = new ArrayList<HematoDTO>();
                                list.add(new HematoDTO(validStartYear, validEndYear, startYear, endYear, line.getField(5)));
                                this._transformFromDto.put(line.getField(0), list);
                            }
                        });
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<HematoDTO> getSamePrimary(String morphology) {
        return this._samePrimaryDto.getOrDefault(morphology, Collections.emptyList());
    }

    @Override
    public List<HematoDTO> getTransformTo(String morphology) {
        return this._transformToDto.getOrDefault(morphology, Collections.emptyList());
    }

    @Override
    public List<HematoDTO> getTransformFrom(String morphology) {
        return this._transformFromDto.getOrDefault(morphology, Collections.emptyList());
    }

    @Override
    public Date getDataLastUpdated() {
        Date date;
        block9: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("hemato_data_info.properties");
            try {
                if (is == null) {
                    throw new IllegalStateException("Unable to get info properties");
                }
                Properties prop = new Properties();
                prop.load(is);
                String lastUpdateDate = prop.getProperty("last_updated");
                date = new SimpleDateFormat("yyyyMMddHHmm").parse(lastUpdateDate);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    return null;
                }
            }
            is.close();
        }
        return date;
    }
}

