/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import de.siegmar.fastcsv.reader.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Mp1998HematopoieticGroup
extends MphGroup {
    private static final List<String[]> _HEMATOPOIETIC_1998 = new ArrayList<String[]>();

    public Mp1998HematopoieticGroup() {
        super("hemato_2000_and_earlier", "Hematopoietic and Lymphoid 2000 and earlier", "C000-C809", null, "9590-9993", null, "2-3,6", "0000-2000");
        Mp1998HematopoieticGroup.initializeLookup();
        MphRule rule = new MphRule("Hematopoietic and Lymphoid 2000 and earlier", ""){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                if (i1.getHistology().equals(i2.getHistology())) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    result.setMessage("Single primary based on SEER 1998 multiple primary rules for hematopoietic cancer.");
                    return result;
                }
                int laterDx = GroupUtility.compareDxDate(i1, i2);
                if (-1 == laterDx) {
                    result.setFinalResult(MphUtils.MpResult.QUESTIONABLE);
                    result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupName());
                    return result;
                }
                String firstDx = 1 == laterDx ? i2.getHistology() : i1.getHistology();
                String secondDx = 1 == laterDx ? i1.getHistology() : i2.getHistology();
                for (String[] row : _HEMATOPOIETIC_1998) {
                    if ((firstDx.compareTo(row[0]) < 0 || firstDx.compareTo(row[1]) > 0 || secondDx.compareTo(row[2]) < 0 || secondDx.compareTo(row[3]) > 0) && (0 != laterDx || secondDx.compareTo(row[0]) < 0 || secondDx.compareTo(row[1]) > 0 || firstDx.compareTo(row[2]) < 0 || firstDx.compareTo(row[3]) > 0)) continue;
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    result.setMessage("Single primary based on SEER 1998 multiple primary rules for hematopoietic cancer.");
                    return result;
                }
                result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                result.setMessage("Multiple primaries based on SEER 1998 multiple primary rules for hematopoietic cancer.");
                return result;
            }
        };
        this._rules.add(rule);
    }

    private static synchronized void initializeLookup() {
        if (_HEMATOPOIETIC_1998.isEmpty()) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("Hematopoietic1998HistologyPairs.csv");){
                if (is == null) {
                    throw new IllegalStateException("Unable to read Hematopoietic1998HistologyPairs.csv");
                }
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.US_ASCII);
                     CsvReader csvReader = CsvReader.builder().ofNamedCsvRecord((Reader)reader);){
                    csvReader.stream().forEach(line -> _HEMATOPOIETIC_1998.add(line.getFields().toArray(new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

