/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mpgroups;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphGroup;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import com.imsweb.mph.mprules.MpRuleDifferentRowInTable;
import com.imsweb.mph.mprules.MpRuleInsituAfterInvasive;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituGreaterThan60Days;
import com.imsweb.mph.mprules.MpRuleInvasiveAfterInsituLessThan60Days;
import com.imsweb.mph.mprules.MpRuleNoCriteriaSatisfied;
import com.imsweb.mph.mprules.MpRulePrimarySite;
import com.imsweb.mph.mprules.MpRuleRenalPelvis;
import com.imsweb.mph.mprules.MpRuleSameRowInTable;
import com.imsweb.mph.mprules.MpRuleUreter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class Mp2018UrinarySitesGroup
extends MphGroup {
    public Mp2018UrinarySitesGroup() {
        super("str_2018_and_later_urinary", "Solid Tumor 2018+ Urinary", "C659, C669, C670-C679, C680-C689", null, null, "9590-9993, 9140", "2-3,6", "2018-9999");
        MphRule rule = new MpRuleRenalPelvis("Solid Tumor 2018+ Urinary", "M3");
        rule.setQuestion("Are there separate/non-contiguous tumors in both the right renal pelvis and the left renal pelvis and no other urinary sites are involved with separate/non-contiguous tumors?");
        rule.setReason("When no other urinary sites are involved with separate/non-contiguous tumors, and separate/non-contiguous tumors in in the right renal pelvis AND tumor(s) in the left renal pelvis are multiple primaries.");
        rule.getNotes().add("Only abstract a single primary when pathology confirms tumor(s) in the contralateral renal pelvis are metastatic.");
        rule.getNotes().add("This rule is used only when there is no involvement by separate/non-contiguous tumors in the ureter(s), bladder, or urethra.");
        this._rules.add(rule);
        rule = new MpRuleUreter("Solid Tumor 2018+ Urinary", "M4");
        rule.setQuestion("Are there separate/non-contiguous tumors in both the right ureter and the left ureter and no other urinary sites are involved with separate/non-contiguous tumors?");
        rule.setReason("When no other urinary sites are involved with separate/non-contiguous tumors, and there are separate/non-contiguous tumors in both the right ureter AND tumor(s) in the left ureter are multiple primaries.");
        rule.getNotes().add("Only abstract a single primary when pathology confirms tumor(s) in contralateral ureter are metastatic.");
        rule.getNotes().add("This rule is used only when there is no involvement by separate/non-contiguous tumors in the renal pelvis, bladder, and urethra.");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M5"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                String icd1 = i1.getIcdCode();
                String icd2 = i2.getIcdCode();
                String s1 = i1.getPrimarySite();
                String s2 = i2.getPrimarySite();
                if ("8120/2".equals(icd1) && "8120/2".equals(icd2) && (s1.startsWith("C67") && "C669".equals(s2) || s2.startsWith("C67") && "C669".equals(s1))) {
                    int sixtyDaysApart = GroupUtility.verifyDaysApart(i1, i2, 60);
                    if (-1 == sixtyDaysApart) {
                        result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                        result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupName());
                    } else if (0 == sixtyDaysApart) {
                        result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                    }
                }
                return result;
            }
        };
        rule.setQuestion("Are tumors of the bladder (C670-C679) and ureter (C669) in situ urothelial carcinoma (8120/2)?");
        rule.setReason("Tumors of the bladder (C670-C679) and ureter (C669) and are in situ urothelial carcinoma (8120/2) are a single primary.");
        rule.getNotes().add("No other urinary organs are involved.");
        rule.getNotes().add("Use this rule ONLY for noninvasive in situ urothelial carcinoma (may be called noninvasive urothelial carcinoma or noninvasive flat tumor). For other histologies, continue through the rules.");
        rule.getNotes().add("Urothelial carcinoma in situ spreads by intramucosal extension and may involve large areas of mucosal surface.  The default for these cases is coding a bladder primary.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituGreaterThan60Days("Solid Tumor 2018+ Urinary", "M6");
        rule.getNotes().add("Abstract both the invasive and in situ tumors.");
        rule.getNotes().add("Abstract as multiple primaries even if physician states the invasive tumor is disease recurrence or progression.");
        rule.getNotes().add("This rule is based on long-term epidemiologic studies of recurrence intervals. The specialty medical experts (SMEs) reviewed and approved these rules.  Many of the SMEs were also authors, co-authors, or editors of the AJCC Staging Manual.");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M7"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                if ("2".equals(i1.getBehavior()) && "2".equals(i2.getBehavior()) && i1.getPrimarySite().startsWith("C67") && i2.getPrimarySite().startsWith("C67") && MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS_EXCLUDE_MICROPAPILLARY.containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there multiple occurrences of noninvasive in situ /2 urothelial carcinoma (flat tumor) 8120/2 and/or Papillary urothelial carcinoma noninvasive 8130/2 tumors in the bladder?");
        rule.setReason("Multiple occurrences of noninvasive in situ /2 urothelial carcinoma (flat tumor) 8120/2 and/or Papillary urothelial carcinoma noninvasive 8130/2 tumors in the bladder is a single primary.");
        rule.getNotes().add("Timing is irrelevant.");
        rule.getNotes().add("Abstract only one in situ urothelial bladder tumor per the patient\u2019s lifetime.");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M8"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                if (GroupUtility.differentCategory(i1.getHistology(), i2.getHistology(), Collections.singletonList("8131"), MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS_EXCLUDE_MICROPAPILLARY)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there micropapillary urothelial carcinoma 8131/3 of the bladder AND a urothelial carcinoma 8120/3 (including papillary 8130/3)?");
        rule.setReason("Abstract multiple primaries when the patient has micropapillary urothelial carcinoma 8131/3 AND a urothelial carcinoma 8120/3 (including papillary 8130/3). Tumors may be in the same urinary site OR in any combination of urinary sites (C67._. C65.9, C66.9, C68_).");
        rule.getNotes().add("Micropapillary urothelial cell carcinoma is an extremely aggressive neoplasm. It is important to abstract a new primary to capture the incidence of micropapillary urothelial carcinoma. Micropapillary is excluded from the typical \"NOS and subtype/variant\" rule (same row in Table 2).");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M9"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String h2 = i2.getHistology();
                if ("3".equals(i1.getBehavior()) && "3".equals(i2.getBehavior()) && i1.getPrimarySite().startsWith("C67") && i2.getPrimarySite().startsWith("C67") && MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS.containsAll(Arrays.asList(h1, h2))) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there multiple invasive urothelial cell carcinomas in the bladder?");
        rule.setReason("Multiple invasive urothelial cell carcinomas in the bladder is a single primary.");
        rule.getNotes().add("Timing is irrelevant. Tumors may be synchronous or non-synchronous.");
        rule.getNotes().add("Abstract only one /3 invasive urothelial bladder primary AND only one micropapillary urothelial 8131/3 bladder primaryper the patient\u2019s lifetime.");
        rule.getNotes().add("An occurrence of micropapillary and an occurrence of urothelial carcinoma would be multiple primaries (see previous rules).");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M10"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                if (i1.getPrimarySite().startsWith("C67") && i2.getPrimarySite().startsWith("C67") && new HashSet<String>(MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS_EXCLUDE_MICROPAPILLARY).containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
                    return result;
                }
                int diff = GroupUtility.verifyYearsApart(i1, i2, 3);
                if (-1 == diff) {
                    result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                    result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupName());
                } else if (1 == diff) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are there tumors diagnosed greater than three (3) years apart?");
        rule.setReason("Tumors diagnosed greater than three (3) years apart are multiple primaries.");
        rule.getNotes().add("This rule does not apply when both/all tumors are urothelial carcinoma of the bladder.");
        rule.getNotes().add("Clinically disease-free means that there was no evidence of recurrence on follow-up.");
        rule.getNotes().add("  - Scans are NED");
        rule.getNotes().add("  - Urine cytology is NED");
        rule.getNotes().add("  - Scopes are NED");
        rule.getNotes().add("When there is a recurrence within three years of diagnosis, the \"clock\" starts over. The time interval is calculated from the date of last recurrence.");
        rule.getNotes().add("When it is unknown/not documented whether the patient had a recurrence, default to date of diagnosis to compute the time interval.");
        rule.getNotes().add("The physician may state this is a recurrence, meaning the patient had a previous urinary site tumor and now has another urinary site tumor. Follow the rules; do not attempt to interpret the physician\u2019s statement.");
        rule.getExamples().add("Patient is diagnosed with multifocal/multicentric urothelial carcinomas in the ureter and renal pelvis in January 2018. Both the kidney and ureter are surgically removed. In June 2022 the patient presents with tumor in the contralateral ureter. The physician states this is a recurrence of the original urothelial carcinoma. Code a new primary for the 2022 ureter carcinoma.");
        rule.setReason("Abstract multiple primaries when the patient has a subsequent tumor after being clinically disease-free for greater than three years after the original diagnosis or last recurrence. This rule does not apply when both/all tumors are urothelial carcinoma of the bladder.");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M11"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String h2 = i2.getHistology();
                if (Mp2018UrinarySitesGroup.this.areTwoDifferentUrinarySites(i1.getPrimarySite(), i2.getPrimarySite()) && MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS.contains(h1) && MphConstants.URINARY_2018_UROTHELIAL_CARCINOMAS.contains(h2)) {
                    result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
                }
                return result;
            }
        };
        rule.setQuestion("Are there urothelial carcinomas in multiple urinary organs?");
        rule.setReason("Urothelial carcinomas in multiple urinary organs is a single primary.");
        rule.getNotes().add("This rule is ONLY for urothelial carcinoma 8120 and all subtypes/variants of urothelial carcinoma. This rule does not apply to any other carcinomas or sarcomas.");
        rule.getNotes().add("The behavior is irrelevant.");
        rule.getNotes().add("This rule applies to multifocal/multicentric carcinoma which involves two or more of the following urinary sites:");
        rule.getNotes().add(" - Renal pelvis");
        rule.getNotes().add(" - Ureter");
        rule.getNotes().add(" - Bladder");
        rule.getNotes().add(" - Urethra");
        this._rules.add(rule);
        rule = new MphRule("Solid Tumor 2018+ Urinary", "M12"){

            @Override
            public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
                String subtype2;
                TempRuleResult result = new TempRuleResult();
                String h1 = i1.getHistology();
                String icd1 = i1.getIcdCode();
                String h2 = i2.getHistology();
                String icd2 = i2.getIcdCode();
                String subtype1 = MphConstants.URINARY_2018_TABLE2_SUBTYPES.containsKey(h1) ? MphConstants.URINARY_2018_TABLE2_SUBTYPES.get(h1) : MphConstants.URINARY_2018_TABLE2_SUBTYPES.get(icd1);
                String string = subtype2 = MphConstants.URINARY_2018_TABLE2_SUBTYPES.containsKey(h2) ? MphConstants.URINARY_2018_TABLE2_SUBTYPES.get(h2) : MphConstants.URINARY_2018_TABLE2_SUBTYPES.get(icd2);
                if (subtype1 != null && subtype2 != null && !subtype1.equals(subtype2)) {
                    result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                }
                return result;
            }
        };
        rule.setQuestion("Are separate/non-contiguous tumors two or more different subtypes/variants in Column 3, Table 2 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors that are two or more different subtypes/variants in Column 3, Table 2 in the Equivalent Terms and Definitions, are multiple primaries.");
        rule.getNotes().add("The tumors may be subtypes/variants of the same or different NOS histologies.");
        rule.getNotes().add("  - Same NOS: Leiomyosarcoma 8890/3 and liposarcoma 8850/3 are both subtypes of sarcoma NOS 8800/3 but are distinctly different histologies. Abstract multiple primaries.");
        rule.getNotes().add("  -  Different NOS: Verrucous carcinoma 8051 is a subtype of squamous cell carcinoma NOS 8070; giant cell urothelial carcinoma 8031 is a subtype of urothelial carcinoma 8120. They are distinctly different histologies. Abstract multiple primaries.");
        this._rules.add(rule);
        rule = new MpRuleDifferentRowInTable("Solid Tumor 2018+ Urinary", "M13", MphConstants.URINARY_2018_TABLE2_ROWS);
        rule.setQuestion("Are separate/non-contiguous tumors on different rows in Table 2 in the Equivalent Terms and Definitions?");
        rule.setReason("Separate/non-contiguous tumors that are on different rows in Table 2 in the Equivalent Terms and Definitions, are multiple primaries.");
        rule.getNotes().add("Each row in the table is a distinctly different histology.");
        rule.getExamples().add("Small cell neuroendocrine carcinoma 8041 and urothelial carcinoma 8120 are on different rows of Table 2. Abstract two primaries, one for the small cell neuroendocrine carcinoma and a second for the urothelial carcinoma.");
        this._rules.add(rule);
        rule = new MpRulePrimarySite("Solid Tumor 2018+ Urinary", "M14");
        this._rules.add(rule);
        rule = new MpRuleSameRowInTable("Solid Tumor 2018+ Urinary", "M15", MphConstants.URINARY_2018_TABLE2_ROWS, true);
        rule.setQuestion("Are synchronous, separate/non-contiguous tumors on the same row in Table 2 in the Equivalent Terms and Definitions?");
        rule.setReason("Synchronous, separate/non-contiguous tumors that are on the same row in Table 2 in the Equivalent Terms and Definitions are a single primary.");
        rule.getNotes().add("The same row means the tumors are:");
        rule.getNotes().add("  - The same histology (same four-digit ICD-O code) OR");
        rule.getNotes().add("  - One is the preferred term (column 1) and the other is a synonym for the preferred term (column 2) OR");
        rule.getNotes().add("  - A NOS (column 1/column 2) and the other is a subtype/variant of that NOS (column 3)");
        this._rules.add(rule);
        rule = new MpRuleInsituAfterInvasive("Solid Tumor 2018+ Urinary", "M16");
        rule.setQuestion("Is there an in situ tumor following an invasive tumor?");
        rule.setReason("An in situ tumor following an invasive tumor is a single primary.");
        rule.getNotes().add("The rules are hierarchical. Only use this rule when previous rules do not apply.");
        rule.getNotes().add("The tumors may be a NOS and a subtype/variant of that NOS. See Table 2 in the Equivalent Terms and Definitions for listings of NOS and subtype/variants.");
        rule.getNotes().add("Once the patient has an invasive tumor, the subsequent in situ is recorded as a recurrence for those registrars who collect recurrence data.");
        this._rules.add(rule);
        rule = new MpRuleInvasiveAfterInsituLessThan60Days("Solid Tumor 2018+ Urinary", "M17");
        rule.getExamples().add("The first presentation was multifocal/multicentric in situ tumors in multiple urinary organs; the subsequent presentation was invasive tumor in at least one of the previously involved urinary organs.");
        rule.getNotes().add("The rules are hierarchical. Only use this rule if none of the previous rules apply.");
        rule.getNotes().add("The tumors may be an NOS and a subtype/variant of that NOS.");
        rule.getNotes().add("When the case has been abstracted, change behavior code on original abstract from /2 to /3. Do not change date of diagnosis.");
        rule.getNotes().add("If the case has already been submitted to the central registry, report all changes.");
        rule.getNotes().add("The physician may stage both tumors because staging and determining multiple primaries are done for different reasons. Staging determines which treatment would be most effective. Determining multiple primaries is done to stabilize the data for the study of epidemiology (long-term studies done on incidence, mortality, and causation of a disease with the goal of reducing or eliminating that disease).");
        rule.getNotes().add("See the COC and SEER manuals for instructions on coding other data items such as Date of Diagnosis, Accession Year and Sequence Number");
        this._rules.add(rule);
        rule = new MpRuleNoCriteriaSatisfied("Solid Tumor 2018+ Urinary", "M18");
        rule.getNotes().add("Use this rule as a last resort.  Please confirm that you have not overlooked an applicable rule.");
        rule.getExamples().add("TURB shows invasive urothelial carcinoma 8120/3 and CIS/in situ urothelial carcinoma 8120/2. Abstract a single primary.");
        this._rules.add(rule);
    }

    private boolean areTwoDifferentUrinarySites(String s1, String s2) {
        return MphConstants.URINARY_2018_URINARY_SITES.contains(s1) && MphConstants.URINARY_2018_URINARY_SITES.contains(s2) && !s1.substring(0, 3).equals(s2.substring(0, 3));
    }
}

