/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;

public class MpRuleCNS
extends MphRule {
    private boolean _malignant;

    public MpRuleCNS(String groupName, String step, boolean malignant) {
        super(groupName, step);
        this._malignant = malignant;
        this.setQuestion("Are multiple tumors present in the following sites:\n - Any lobe(s) of the brain C710-C719 AND any other part of CNS\n - Cauda equina C721 AND any other part of CNS\n - Cerebral meninges C700 AND spinal meninges C701\n - Cerebral meninges C700 AND any other part of CNS\n - Any cranial nerve(s) C722-C725 AND any other part of the CNS\n" + (malignant ? " - Any two or more of the cranial nerves: C722 Olfactory, C723 Optic, C724 Acoustic, C725 Cranial nerves NOS,\n" : "") + " - Meninges of cranial nerves C709 AND any other part of the CNS\n - Spinal cord C720 AND any other part of CNS\n - Spinal meninges C701 AND any other part of CNS?");
        this.setReason("Multiple tumors present in the following sites:\n - Any lobe(s) of the brain C710-C719 AND any other part of CNS\n - Cauda equina C721 AND any other part of CNS\n - Cerebral meninges C700 AND spinal meninges C701\n - Cerebral meninges C700 AND any other part of CNS\n - Any cranial nerve(s) C722-C725 AND any other part of the CNS\n" + (malignant ? " - Any two or more of the cranial nerves: C722 Olfactory, C723 Optic, C724 Acoustic, C725 Cranial nerves NOS,\n" : "") + " - Meninges of cranial nerves C709 AND any other part of the CNS\n - Spinal cord C720 AND any other part of CNS\n - Spinal meninges C701 AND any other part of CNS\nare multiple primaries.");
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        boolean spinalMeningesAndOtherPart;
        TempRuleResult result = new TempRuleResult();
        String s1 = i1.getPrimarySite();
        String s2 = i2.getPrimarySite();
        boolean lobesAndOtherPart = GroupUtility.isSiteContained("C710-C719", s1) && !GroupUtility.isSiteContained("C710-C719", s2) || GroupUtility.isSiteContained("C710-C719", s2) && !GroupUtility.isSiteContained("C710-C719", s1);
        boolean caudaEquinaAndOtherPart = GroupUtility.isSiteContained("C721", s1) && !GroupUtility.isSiteContained("C721", s2) || GroupUtility.isSiteContained("C721", s2) && !GroupUtility.isSiteContained("C721", s1);
        boolean celebralMeningesAndOtherPart = GroupUtility.isSiteContained("C700", s1) && !GroupUtility.isSiteContained("C700", s2) || GroupUtility.isSiteContained("C700", s2) && !GroupUtility.isSiteContained("C700", s1);
        boolean cranialAndOtherPart = GroupUtility.isSiteContained("C722-C725", s1) && !GroupUtility.isSiteContained("C722-C725", s2) || GroupUtility.isSiteContained("C722-C725", s2) && !GroupUtility.isSiteContained("C722-C725", s1);
        boolean cranialNerves = GroupUtility.isSiteContained("C722-C725", s1) && GroupUtility.isSiteContained("C722-C725", s2) && !s1.equals(s2);
        boolean meningesOfCranialAndOtherPart = GroupUtility.isSiteContained("C709", s1) && !GroupUtility.isSiteContained("C709", s2) || GroupUtility.isSiteContained("C709", s2) && !GroupUtility.isSiteContained("C709", s1);
        boolean spinalCordAndOtherPart = GroupUtility.isSiteContained("C720", s1) && !GroupUtility.isSiteContained("C720", s2) || GroupUtility.isSiteContained("C720", s2) && !GroupUtility.isSiteContained("C720", s1);
        boolean bl = spinalMeningesAndOtherPart = GroupUtility.isSiteContained("C701", s1) && !GroupUtility.isSiteContained("C701", s2) || GroupUtility.isSiteContained("C701", s2) && !GroupUtility.isSiteContained("C701", s1);
        if (lobesAndOtherPart || caudaEquinaAndOtherPart || celebralMeningesAndOtherPart || cranialAndOtherPart || meningesOfCranialAndOtherPart || spinalCordAndOtherPart || spinalMeningesAndOtherPart || cranialNerves && this._malignant) {
            result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
        }
        return result;
    }
}

