/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Collections;

public class MpRuleFollowing
extends MphRule {
    private String _laterMorph;
    private String _earlierMorph;

    public MpRuleFollowing(String groupName, String step, String laterMorph, String earlierMorph) {
        super(groupName, step);
        this._laterMorph = laterMorph;
        this._earlierMorph = earlierMorph;
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        String icd2;
        TempRuleResult result = new TempRuleResult();
        String icd1 = i1.getIcdCode();
        if (GroupUtility.differentCategory(icd1, icd2 = i2.getIcdCode(), Collections.singletonList(this._laterMorph), Collections.singletonList(this._earlierMorph))) {
            int laterDiagnosedTumor = GroupUtility.compareDxDate(i1, i2);
            if (-1 == laterDiagnosedTumor) {
                result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupName());
            } else if (1 == laterDiagnosedTumor && icd1.equals(this._laterMorph) || 2 == laterDiagnosedTumor && icd2.equals(this._laterMorph)) {
                result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
            }
        }
        return result;
    }
}

