/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.List;

public class MpRuleLateralityPairedSites
extends MphRule {
    private List<String> _pairedSites;

    public MpRuleLateralityPairedSites(String groupName, String step, List<String> pairedSites) {
        super(groupName, step);
        this._pairedSites = pairedSites;
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        TempRuleResult result = new TempRuleResult();
        if (GroupUtility.isPairedSites(i1.getPrimarySite(), i2.getPrimarySite(), this._pairedSites)) {
            if (!GroupUtility.validPairedSiteLaterality(i1.getLaterality(), i2.getLaterality())) {
                result.setPotentialResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
                result.setMessageUnknownLaterality(this.getStep(), this.getGroupName());
            } else if (GroupUtility.areOppositeSides(i1.getLaterality(), i2.getLaterality())) {
                result.setFinalResult(MphUtils.MpResult.MULTIPLE_PRIMARIES);
            }
        }
        return result;
    }
}

