/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphConstants;
import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import java.util.Arrays;
import java.util.HashSet;

public class MpRuleRetinoblastoma
extends MphRule {
    public MpRuleRetinoblastoma(String groupName, String step) {
        super(groupName, step);
        this.setQuestion("Is the diagnosis retinoblastoma (unilateral or bilateral)?");
        this.setReason("Retinoblastoma is always a single primary (unilateral or bilateral).");
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        TempRuleResult result = new TempRuleResult();
        if (new HashSet<String>(MphConstants.RETINO_BLASTOMA).containsAll(Arrays.asList(i1.getHistology(), i2.getHistology()))) {
            result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
        }
        return result;
    }
}

