/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.mph.mprules;

import com.imsweb.mph.MphInput;
import com.imsweb.mph.MphRule;
import com.imsweb.mph.MphUtils;
import com.imsweb.mph.RuleExecutionContext;
import com.imsweb.mph.internal.TempRuleResult;
import com.imsweb.mph.mpgroups.GroupUtility;
import java.util.Arrays;
import java.util.Set;

public class MpRuleThyroidFollicularPapillary
extends MphRule {
    private Set<String> _follicularAndPapillary;

    public MpRuleThyroidFollicularPapillary(String groupName, String step, Set<String> follicularAndPapillary) {
        super(groupName, step);
        this._follicularAndPapillary = follicularAndPapillary;
    }

    @Override
    public TempRuleResult apply(MphInput i1, MphInput i2, RuleExecutionContext context) {
        TempRuleResult result = new TempRuleResult();
        String site1 = i1.getPrimarySite();
        String site2 = i2.getPrimarySite();
        String icd1 = i1.getIcdCode();
        String icd2 = i2.getIcdCode();
        if ("C739".equals(site1) && "C739".equals(site2) && this._follicularAndPapillary.containsAll(Arrays.asList(icd1, icd2))) {
            int sixtyDaysApart = GroupUtility.verifyDaysApart(i1, i2, 60);
            if (-1 == sixtyDaysApart) {
                result.setPotentialResult(MphUtils.MpResult.SINGLE_PRIMARY);
                result.setMessageUnknownDiagnosisDate(this.getStep(), this.getGroupName());
            } else if (0 == sixtyDaysApart) {
                result.setFinalResult(MphUtils.MpResult.SINGLE_PRIMARY);
            }
        }
        return result;
    }
}

