/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.TestReport;
import java.io.IOException;
import org.apache.http.client.HttpResponseException;

public class Build
extends BaseModel {
    public static final Build BUILD_HAS_NEVER_RAN = new Build(-1, -1, "UNKNOWN");
    private int number;
    private int queueId;
    private String url;

    private Build(int number, int queueId, String url) {
        this.number = number;
        this.queueId = queueId;
        this.url = url;
    }

    public Build() {
    }

    public Build(Build from) {
        this(from.getNumber(), from.getUrl());
    }

    public Build(int number, String url) {
        this.number = number;
        this.url = url;
    }

    public int getNumber() {
        return this.number;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public String getUrl() {
        return this.url;
    }

    public BuildWithDetails details() throws IOException {
        return this.client.get(this.url, BuildWithDetails.class);
    }

    public TestReport getTestReport() throws IOException {
        return this.client.get(this.getUrl() + "/testReport/?depth=1", TestReport.class);
    }

    public String Stop() throws HttpResponseException, IOException {
        try {
            return this.client.get(this.url + "stop");
        }
        catch (IOException ex) {
            if (((HttpResponseException)((Object)ex)).getStatusCode() == 405) {
                this.stopPost();
                return "";
            }
            return "";
        }
    }

    private void stopPost() throws HttpResponseException, IOException {
        this.client.post(this.url + "stop");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (this.number != build.number) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(build.url) : build.url != null);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }
}

