/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.jenkins_client_jarjar.base.Predicate;
import com.google.common.jenkins_client_jarjar.base.Strings;
import com.google.common.jenkins_client_jarjar.collect.Collections2;
import com.offbytwo.jenkins.model.Artifact;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildCause;
import com.offbytwo.jenkins.model.BuildChangeSet;
import com.offbytwo.jenkins.model.BuildChangeSetAuthor;
import com.offbytwo.jenkins.model.BuildResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildWithDetails
extends Build {
    private List actions;
    private boolean building;
    private String description;
    private long duration;
    private long estimatedDuration;
    private String fullDisplayName;
    private String id;
    private long timestamp;
    private BuildResult result;
    private List<Artifact> artifacts;
    private String consoleOutputText;
    private String consoleOutputHtml;
    private BuildChangeSet changeSet;
    private String builtOn;
    private List<BuildChangeSetAuthor> culprits;

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public List<BuildCause> getCauses() {
        Collection<Map<String, Object>> causes = Collections2.filter(this.actions, new Predicate<Map<String, Object>>(){

            @Override
            public boolean apply(Map<String, Object> action) {
                return action.containsKey("causes");
            }
        });
        ArrayList<BuildCause> result = new ArrayList<BuildCause>();
        if (causes != null && !causes.isEmpty()) {
            List causes_blob = (List)((Map)causes.toArray()[0]).get("causes");
            for (Map cause : causes_blob) {
                BuildCause convertToBuildCause = this.convertToBuildCause(cause);
                result.add(convertToBuildCause);
            }
        }
        return result;
    }

    private BuildCause convertToBuildCause(Map<String, Object> cause) {
        String userName;
        String userId;
        String upstreamProject;
        Integer upstreamBuild;
        BuildCause cause_object = new BuildCause();
        String description = (String)cause.get("shortDescription");
        if (!Strings.isNullOrEmpty(description)) {
            cause_object.setShortDescription(description);
        }
        if ((upstreamBuild = (Integer)cause.get("upstreamBuild")) != null) {
            cause_object.setUpstreamBuild(upstreamBuild);
        }
        if (!Strings.isNullOrEmpty(upstreamProject = (String)cause.get("upstreamProject"))) {
            cause_object.setUpstreamProject(upstreamProject);
        }
        String upstreamUrl = (String)cause.get("upstreamUrl");
        if (!Strings.isNullOrEmpty(upstreamProject)) {
            cause_object.setUpstreamUrl(upstreamUrl);
        }
        if (!Strings.isNullOrEmpty(userId = (String)cause.get("userId"))) {
            cause_object.setUserId(userId);
        }
        if (!Strings.isNullOrEmpty(userName = (String)cause.get("userName"))) {
            cause_object.setUserName(userName);
        }
        return cause_object;
    }

    public String getDescription() {
        return this.description;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public String getFullDisplayName() {
        return this.fullDisplayName;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public String getBuiltOn() {
        return this.builtOn;
    }

    public List getActions() {
        return this.actions;
    }

    public Map<String, String> getParameters() {
        Collection<Map<String, Object>> parameters = Collections2.filter(this.actions, new Predicate<Map<String, Object>>(){

            @Override
            public boolean apply(Map<String, Object> action) {
                return action.containsKey("parameters");
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map param : (List)((Map)parameters.toArray()[0]).get("parameters")) {
                String key = (String)param.get("name");
                Object value = param.get("value");
                params.put(key, String.valueOf(value));
            }
        }
        return params;
    }

    public String getConsoleOutputText() throws IOException {
        return this.client.get(this.getUrl() + "/logText/progressiveText");
    }

    public String getConsoleOutputHtml() throws IOException {
        return this.client.get(this.getUrl() + "/logText/progressiveHtml");
    }

    public BuildChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(BuildChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public List<BuildChangeSetAuthor> getCulprits() {
        return this.culprits;
    }

    public void setCulprits(List<BuildChangeSetAuthor> culprits) {
        this.culprits = culprits;
    }

    public InputStream downloadArtifact(Artifact a) throws IOException, URISyntaxException {
        URI uri = new URI(this.getUrl());
        String artifactPath = uri.getPath() + "artifact/" + a.getRelativePath();
        URI artifactUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), artifactPath, "", "");
        return this.client.getFile(artifactUri);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildWithDetails other = (BuildWithDetails)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts)) {
            return false;
        }
        if (this.building != other.building) {
            return false;
        }
        if (this.builtOn == null ? other.builtOn != null : !this.builtOn.equals(other.builtOn)) {
            return false;
        }
        if (this.changeSet == null ? other.changeSet != null : !this.changeSet.equals(other.changeSet)) {
            return false;
        }
        if (this.consoleOutputHtml == null ? other.consoleOutputHtml != null : !this.consoleOutputHtml.equals(other.consoleOutputHtml)) {
            return false;
        }
        if (this.consoleOutputText == null ? other.consoleOutputText != null : !this.consoleOutputText.equals(other.consoleOutputText)) {
            return false;
        }
        if (this.culprits == null ? other.culprits != null : !this.culprits.equals(other.culprits)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.estimatedDuration != other.estimatedDuration) {
            return false;
        }
        if (this.fullDisplayName == null ? other.fullDisplayName != null : !this.fullDisplayName.equals(other.fullDisplayName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.result != other.result) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.artifacts == null ? 0 : this.artifacts.hashCode());
        result = 31 * result + (this.building ? 1231 : 1237);
        result = 31 * result + (this.builtOn == null ? 0 : this.builtOn.hashCode());
        result = 31 * result + (this.changeSet == null ? 0 : this.changeSet.hashCode());
        result = 31 * result + (this.consoleOutputHtml == null ? 0 : this.consoleOutputHtml.hashCode());
        result = 31 * result + (this.consoleOutputText == null ? 0 : this.consoleOutputText.hashCode());
        result = 31 * result + (this.culprits == null ? 0 : this.culprits.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.estimatedDuration ^ this.estimatedDuration >>> 32);
        result = 31 * result + (this.fullDisplayName == null ? 0 : this.fullDisplayName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

