/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.jenkins_client_jarjar.base.Function;
import com.google.common.jenkins_client_jarjar.net.UrlEscapers;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.Executor;
import com.offbytwo.jenkins.model.LoadStatistics;
import com.offbytwo.jenkins.model.OfflineCause;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComputerWithDetails
extends Computer {
    private String displayName;
    private List actions;
    private List<Executor> executors;
    private Boolean idle;
    private Boolean jnlp;
    private Boolean launchSupported;
    private Boolean manualLaunchAllowed;
    private Map monitorData;
    private Integer numExecutors;
    private Boolean offline;
    private OfflineCause offlineCause;
    private String offlineCauseReason;
    private List oneOffExecutors;
    private Boolean temporarilyOffline;

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public List<Map> getActions() {
        return this.actions;
    }

    public List<Executor> getExecutors() {
        return this.executors;
    }

    public Boolean getIdle() {
        return this.idle;
    }

    public Boolean getJnlp() {
        return this.jnlp;
    }

    public Boolean getLaunchSupported() {
        return this.launchSupported;
    }

    public LoadStatistics getLoadStatistics() throws IOException {
        String name = "master".equals(this.displayName) ? "(master)" : UrlEscapers.urlPathSegmentEscaper().escape(this.displayName);
        return this.client.get("/computer/" + name + "/" + "loadStatistics/?depth=2", LoadStatistics.class);
    }

    public void toggleOffline(boolean crumbFlag) throws IOException {
        String name = "master".equals(this.displayName) ? "(master)" : UrlEscapers.urlPathSegmentEscaper().escape(this.displayName);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("json", "init");
        this.client.post("/computer/" + name + "/toggleOffline", crumbFlag);
    }

    public void toggleOffline() throws IOException {
        this.toggleOffline(false);
    }

    public Boolean getManualLaunchAllowed() {
        return this.manualLaunchAllowed;
    }

    public Map<String, Map> getMonitorData() {
        return this.monitorData;
    }

    public Integer getNumExecutors() {
        return this.numExecutors;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public OfflineCause getOfflineCause() throws IOException {
        return this.offlineCause;
    }

    public String getOfflineCauseReason() {
        return this.offlineCauseReason;
    }

    public List<Map> getOneOffExecutors() {
        return this.oneOffExecutors;
    }

    public Boolean getTemporarilyOffline() {
        return this.temporarilyOffline;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComputerWithDetails other = (ComputerWithDetails)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.executors == null ? other.executors != null : !this.executors.equals(other.executors)) {
            return false;
        }
        if (this.idle == null ? other.idle != null : !this.idle.equals(other.idle)) {
            return false;
        }
        if (this.jnlp == null ? other.jnlp != null : !this.jnlp.equals(other.jnlp)) {
            return false;
        }
        if (this.launchSupported == null ? other.launchSupported != null : !this.launchSupported.equals(other.launchSupported)) {
            return false;
        }
        if (this.manualLaunchAllowed == null ? other.manualLaunchAllowed != null : !this.manualLaunchAllowed.equals(other.manualLaunchAllowed)) {
            return false;
        }
        if (this.monitorData == null ? other.monitorData != null : !this.monitorData.equals(other.monitorData)) {
            return false;
        }
        if (this.numExecutors == null ? other.numExecutors != null : !this.numExecutors.equals(other.numExecutors)) {
            return false;
        }
        if (this.offline == null ? other.offline != null : !this.offline.equals(other.offline)) {
            return false;
        }
        if (this.offlineCause == null ? other.offlineCause != null : !this.offlineCause.equals(other.offlineCause)) {
            return false;
        }
        if (this.offlineCauseReason == null ? other.offlineCauseReason != null : !this.offlineCauseReason.equals(other.offlineCauseReason)) {
            return false;
        }
        if (this.oneOffExecutors == null ? other.oneOffExecutors != null : !this.oneOffExecutors.equals(other.oneOffExecutors)) {
            return false;
        }
        return !(this.temporarilyOffline == null ? other.temporarilyOffline != null : !this.temporarilyOffline.equals(other.temporarilyOffline));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.executors == null ? 0 : this.executors.hashCode());
        result = 31 * result + (this.idle == null ? 0 : this.idle.hashCode());
        result = 31 * result + (this.jnlp == null ? 0 : this.jnlp.hashCode());
        result = 31 * result + (this.launchSupported == null ? 0 : this.launchSupported.hashCode());
        result = 31 * result + (this.manualLaunchAllowed == null ? 0 : this.manualLaunchAllowed.hashCode());
        result = 31 * result + (this.monitorData == null ? 0 : this.monitorData.hashCode());
        result = 31 * result + (this.numExecutors == null ? 0 : this.numExecutors.hashCode());
        result = 31 * result + (this.offline == null ? 0 : this.offline.hashCode());
        result = 31 * result + (this.offlineCause == null ? 0 : this.offlineCause.hashCode());
        result = 31 * result + (this.offlineCauseReason == null ? 0 : this.offlineCauseReason.hashCode());
        result = 31 * result + (this.oneOffExecutors == null ? 0 : this.oneOffExecutors.hashCode());
        result = 31 * result + (this.temporarilyOffline == null ? 0 : this.temporarilyOffline.hashCode());
        return result;
    }

    private class ComputerWithClient
    implements Function<Computer, Computer> {
        private ComputerWithClient() {
        }

        @Override
        public Computer apply(Computer computer) {
            computer.setClient(ComputerWithDetails.this.client);
            return computer;
        }
    }
}

