/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.jenkins_client_jarjar.base.Function;
import com.google.common.jenkins_client_jarjar.collect.Lists;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.MavenBuild;
import com.offbytwo.jenkins.model.MavenJob;
import java.util.List;

public class MavenJobWithDetails
extends MavenJob {
    private String displayName;
    private boolean buildable;
    private List<MavenBuild> builds;
    private MavenBuild lastBuild;
    private MavenBuild lastCompletedBuild;
    private MavenBuild lastFailedBuild;
    private MavenBuild lastStableBuild;
    private MavenBuild lastSuccessfulBuild;
    private MavenBuild lastUnstableBuild;
    private MavenBuild lastUnsuccessfulBuild;
    private int nextBuildNumber;
    private List<Job> downstreamProjects;
    private List<Job> upstreamProjects;

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public List<MavenBuild> getBuilds() {
        return Lists.transform(this.builds, new Function<MavenBuild, MavenBuild>(){

            @Override
            public MavenBuild apply(MavenBuild from) {
                return MavenJobWithDetails.this.buildWithClient(from);
            }
        });
    }

    public MavenBuild getLastBuild() {
        return this.buildWithClient(this.lastBuild);
    }

    public MavenBuild getLastCompletedBuild() {
        return this.buildWithClient(this.lastCompletedBuild);
    }

    public MavenBuild getLastFailedBuild() {
        return this.buildWithClient(this.lastFailedBuild);
    }

    public MavenBuild getLastStableBuild() {
        return this.buildWithClient(this.lastStableBuild);
    }

    public MavenBuild getLastSuccessfulBuild() {
        return this.buildWithClient(this.lastSuccessfulBuild);
    }

    public MavenBuild getLastUnstableBuild() {
        return this.buildWithClient(this.lastUnstableBuild);
    }

    public MavenBuild getLastUnsuccessfulBuild() {
        return this.buildWithClient(this.lastUnsuccessfulBuild);
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public List<Job> getDownstreamProjects() {
        return Lists.transform(this.downstreamProjects, new MavenJobWithClient());
    }

    public List<Job> getUpstreamProjects() {
        return Lists.transform(this.upstreamProjects, new MavenJobWithClient());
    }

    private MavenBuild buildWithClient(MavenBuild from) {
        MavenBuild ret = new MavenBuild(from);
        ret.setClient(this.client);
        return ret;
    }

    private class MavenJobWithClient
    implements Function<Job, Job> {
        private MavenJobWithClient() {
        }

        @Override
        public Job apply(Job job) {
            job.setClient(MavenJobWithDetails.this.client);
            return job;
        }
    }
}

