/*
 * Decompiled with CFR 0.152.
 */
package com.peachapisecurity.tg.junit4;

import com.peachapisecurity.api.PeachApiException;
import com.peachapisecurity.api.PeachState;
import com.peachapisecurity.tg.junit4.PeachContext;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class PeachInvokeMethod
extends Statement {
    private final FrameworkMethod testMethod;
    private final Object target;
    private final PeachContext context;
    private final String name;

    public PeachInvokeMethod(PeachContext context, String name, FrameworkMethod testMethod, Object target) {
        this.testMethod = testMethod;
        this.target = target;
        this.context = context;
        this.name = name;
    }

    public void evaluate() throws Throwable {
        try {
            this.context.proxy.testCase(this.name);
            this.context.state = PeachState.Unknown;
            try {
                this.testMethod.invokeExplosively(this.target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.context.state = this.context.proxy.testTeardown();
        }
        catch (PeachApiException ex) {
            if (this.context.debug.booleanValue()) {
                System.out.println(String.format("PeachInvokeMethod.evaluate: Error: %s", ex.toString()));
            }
            this.context.state = PeachState.Error;
            this.context.ex = ex;
            throw ex;
        }
    }
}

