/*
 * Decompiled with CFR 0.152.
 */
package com.peachapisecurity.tg.junit4.examples;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUser {
    private static String _baseUrl = null;
    private int _lastUserId = 2;
    private static String _apiToken = "Token b5638ae7-6e77-4585-b035-7d9de2e3f6b3";
    public static HttpHost Proxy = null;

    @BeforeClass
    public static void setupClass() throws Throwable {
        _baseUrl = System.getenv("TARGET_URL");
    }

    @Before
    public void setup() throws Throwable {
        this._lastUserId = 2;
        Request.Delete((String)String.format("%s/api/users/%s", _baseUrl, this._lastUserId)).addHeader("Authorization", _apiToken).viaProxy(Proxy).execute().returnResponse();
        Request.Delete((String)String.format("%s/api/users?user=dd", _baseUrl)).addHeader("Authorization", _apiToken).viaProxy(Proxy).execute().returnResponse();
    }

    @After
    public void teardown() throws Throwable {
        Request.Delete((String)String.format("%s/api/users/%s", _baseUrl, this._lastUserId)).addHeader("Authorization", _apiToken).viaProxy(Proxy).execute().returnResponse();
    }

    @Test
    public void createUser() throws Throwable {
        JSONObject user = new JSONObject();
        user.put("user", (Object)"dd");
        user.put("first", (Object)"mike");
        user.put("last", (Object)"smith");
        user.put("password", (Object)"fnord");
        HttpResponse ret = Request.Post((String)String.format("%s/api/users", _baseUrl)).addHeader("Authorization", _apiToken).viaProxy(Proxy).bodyString(user.toString(), ContentType.APPLICATION_JSON).execute().returnResponse();
        Assert.assertEquals((long)201L, (long)ret.getStatusLine().getStatusCode());
        JSONObject msg = new JSONObject(EntityUtils.toString((HttpEntity)ret.getEntity()));
        this._lastUserId = msg.getInt("user_id");
    }

    @Test
    public void updateUser() throws Throwable {
        JSONObject user = new JSONObject();
        user.put("user", (Object)"dd");
        user.put("first", (Object)"mike");
        user.put("last", (Object)"smith");
        user.put("password", (Object)"fnord");
        HttpResponse ret = Request.Post((String)String.format("%s/api/users", _baseUrl)).addHeader("Authorization", _apiToken).viaProxy(Proxy).bodyString(user.toString(), ContentType.APPLICATION_JSON).execute().returnResponse();
        Assert.assertEquals((long)201L, (long)ret.getStatusLine().getStatusCode());
        JSONObject msg = new JSONObject(EntityUtils.toString((HttpEntity)ret.getEntity()));
        this._lastUserId = msg.getInt("user_id");
        user = new JSONObject();
        user.put("user", (Object)"dd");
        user.put("first", (Object)"john");
        user.put("last", (Object)"smith");
        user.put("password", (Object)"fn0rd");
        ret = Request.Put((String)String.format("%s/api/users/%s", _baseUrl, this._lastUserId)).addHeader("Authorization", _apiToken).viaProxy(Proxy).bodyString(user.toString(), ContentType.APPLICATION_JSON).execute().returnResponse();
        Assert.assertEquals((long)204L, (long)ret.getStatusLine().getStatusCode());
    }
}

