/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd;

import com.spotify.ffwd.Metric;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FastForward {
    @Deprecated
    public static final int LATEST_VERSION = 0;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 19091;
    private final InetAddress addr;
    private final int port;
    private final DatagramSocket socket;

    public static FastForward setup() throws UnknownHostException, SocketException {
        return FastForward.setup(InetAddress.getByName(DEFAULT_HOST), 19091);
    }

    public static FastForward setup(String host) throws UnknownHostException, SocketException {
        return FastForward.setup(InetAddress.getByName(host));
    }

    public static FastForward setup(String host, int port) throws UnknownHostException, SocketException {
        return FastForward.setup(InetAddress.getByName(host), port);
    }

    public static FastForward setup(InetAddress addr) throws SocketException {
        return FastForward.setup(addr, 19091);
    }

    public static FastForward setup(InetAddress addr, int port) throws SocketException {
        DatagramSocket socket = new DatagramSocket();
        return new FastForward(addr, port, socket);
    }

    private FastForward(InetAddress addr, int port, DatagramSocket socket) {
        this.addr = addr;
        this.port = port;
        this.socket = socket;
    }

    protected FastForward() throws UnknownHostException, SocketException {
        this.addr = InetAddress.getByName(DEFAULT_HOST);
        this.port = 19091;
        this.socket = new DatagramSocket();
    }

    public void send(Metric metric) throws IOException {
        this.sendFrame(metric.serialize(), Version.V0);
    }

    public void send(com.spotify.ffwd.v1.Metric metric) throws IOException {
        this.sendFrame(metric.serialize(), Version.V1);
    }

    void sendFrame(byte[] bytes, Version v) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(v.getVersion());
        buffer.putInt(buffer.capacity());
        buffer.put(bytes);
        buffer.rewind();
        byte[] send = new byte[buffer.capacity()];
        buffer.get(send);
        DatagramPacket packet = new DatagramPacket(send, send.length, this.addr, this.port);
        this.socket.send(packet);
    }

    public static Metric metric(String key) {
        return new Metric().key(key);
    }

    public static com.spotify.ffwd.v1.Metric metricV1(String key) {
        return new com.spotify.ffwd.v1.Metric().key(key);
    }

    public static enum Version {
        V0(0),
        V1(1);

        private final int version;

        private Version(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

