/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd;

import com.spotify.ffwd.protocol0.Protocol0;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Metric {
    private static final long PROC = 1L;
    private static final long TIME = 2L;
    private static final long KEY = 4L;
    private static final long VALUE = 8L;
    private static final long HOST = 16L;
    private static final long TAGS = 32L;
    private static final long ATTRIBUTES = 64L;
    private final long has;
    private final String proc;
    private final long time;
    private final String key;
    private final double value;
    private final String host;
    private final List<String> tags;
    private final Map<String, String> attributes;

    public Metric() {
        this.has = 0L;
        this.proc = null;
        this.time = 0L;
        this.key = null;
        this.value = 0.0;
        this.host = null;
        this.tags = new ArrayList<String>();
        this.attributes = new HashMap<String, String>();
    }

    public Metric(long has, String proc, long time, String key, double value, String host, List<String> tags, Map<String, String> attributes) {
        this.has = has;
        this.proc = proc;
        this.time = time;
        this.key = key;
        this.value = value;
        this.host = host;
        this.tags = tags;
        this.attributes = attributes;
    }

    private boolean test(long n) {
        return (this.has & n) != 0L;
    }

    private long set(long n) {
        return this.has | n;
    }

    public Metric proc(String proc) {
        return new Metric(this.set(1L), proc, this.time, this.key, this.value, this.host, this.tags, this.attributes);
    }

    public Metric time(long time) {
        return new Metric(this.set(2L), this.proc, time, this.key, this.value, this.host, this.tags, this.attributes);
    }

    public Metric key(String key) {
        return new Metric(this.set(4L), this.proc, this.time, key, this.value, this.host, this.tags, this.attributes);
    }

    public Metric value(double value) {
        return new Metric(this.set(8L), this.proc, this.time, this.key, value, this.host, this.tags, this.attributes);
    }

    public Metric host(String host) {
        return new Metric(this.set(16L), this.proc, this.time, this.key, this.value, host, this.tags, this.attributes);
    }

    public Metric tag(String tag) {
        ArrayList<String> tags = new ArrayList<String>(this.tags);
        tags.add(tag);
        return new Metric(this.set(32L), this.proc, this.time, this.key, this.value, this.host, tags, this.attributes);
    }

    public Metric tags(List<String> tags) {
        return new Metric(this.set(32L), this.proc, this.time, this.key, this.value, this.host, new ArrayList<String>(tags), this.attributes);
    }

    public Metric attribute(String k, String v) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.attributes);
        attributes.put(k, v);
        return new Metric(this.set(64L), this.proc, this.time, this.key, this.value, this.host, this.tags, attributes);
    }

    public Metric attributes(Map<String, String> attributes) {
        return new Metric(this.set(64L), this.proc, this.time, this.key, this.value, this.host, this.tags, new HashMap<String, String>(attributes));
    }

    public byte[] serialize() {
        Protocol0.Metric.Builder builder = Protocol0.Metric.newBuilder();
        if (this.test(1L)) {
            builder.setProc(this.proc);
        }
        if (this.test(2L)) {
            builder.setTime(this.time);
        }
        if (this.test(4L)) {
            builder.setKey(this.key);
        }
        if (this.test(8L)) {
            builder.setValue(this.value);
        }
        if (this.test(16L)) {
            builder.setHost(this.host);
        }
        if (this.test(32L)) {
            for (String string : this.tags) {
                builder.addTags(string);
            }
        }
        if (this.test(64L)) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                if (entry.getKey() == null) continue;
                Protocol0.Attribute.Builder attributeBuilder = Protocol0.Attribute.newBuilder().setKey((String)entry.getKey());
                if (entry.getValue() != null) {
                    attributeBuilder.setValue((String)entry.getValue());
                }
                builder.addAttributes(attributeBuilder.build());
            }
        }
        Protocol0.Metric m = builder.build();
        return Protocol0.Message.newBuilder().setMetric(m).build().toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.has != other.has) {
            return false;
        }
        String this$proc = this.proc;
        String other$proc = other.proc;
        if (this$proc == null ? other$proc != null : !this$proc.equals(other$proc)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (Double.compare(this.value, other.value) != 0) {
            return false;
        }
        String this$host = this.host;
        String other$host = other.host;
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<String> this$tags = this.tags;
        List<String> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$attributes = this.attributes;
        Map<String, String> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    private boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $has = this.has;
        result = result * 59 + (int)($has >>> 32 ^ $has);
        String $proc = this.proc;
        result = result * 59 + ($proc == null ? 43 : $proc.hashCode());
        long $time = this.time;
        result = result * 59 + (int)($time >>> 32 ^ $time);
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $host = this.host;
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String getProc() {
        return this.proc;
    }

    public long getTime() {
        return this.time;
    }

    public String getKey() {
        return this.key;
    }

    public double getValue() {
        return this.value;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

