/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.v1;

import com.spotify.ffwd.protocol1.Protocol1;
import com.spotify.ffwd.v1.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Metric {
    private static final long TIME = 2L;
    private static final long KEY = 4L;
    private static final long VALUE = 8L;
    private static final long HOST = 16L;
    private static final long TAGS = 32L;
    private static final long ATTRIBUTES = 64L;
    private final long has;
    private final long time;
    private final String key;
    private final Value value;
    private final String host;
    private final List<String> tags;
    private final Map<String, String> attributes;

    public Metric() {
        this.has = 0L;
        this.time = 0L;
        this.key = null;
        this.value = Value.doubleValue(0.0);
        this.host = null;
        this.tags = new ArrayList<String>();
        this.attributes = new HashMap<String, String>();
    }

    public Metric(long has, long time, String key, Value value, String host, List<String> tags, Map<String, String> attributes) {
        this.has = has;
        this.time = time;
        this.key = key;
        this.value = value == null ? Value.doubleValue(0.0) : value;
        this.host = host;
        this.tags = tags;
        this.attributes = attributes;
    }

    private boolean test(long n) {
        return (this.has & n) != 0L;
    }

    private long set(long n) {
        return this.has | n;
    }

    public Metric time(long time) {
        return new Metric(this.set(2L), time, this.key, this.value, this.host, this.tags, this.attributes);
    }

    public Metric key(String key) {
        return new Metric(this.set(4L), this.time, key, this.value, this.host, this.tags, this.attributes);
    }

    public Metric value(Value value) {
        Value newValue = value == null ? Value.doubleValue(0.0) : value;
        return new Metric(this.set(8L), this.time, this.key, newValue, this.host, this.tags, this.attributes);
    }

    public Metric host(String host) {
        return new Metric(this.set(16L), this.time, this.key, this.value, host, this.tags, this.attributes);
    }

    public Metric tag(String tag) {
        ArrayList<String> tags = new ArrayList<String>(this.tags);
        tags.add(tag);
        return new Metric(this.set(32L), this.time, this.key, this.value, this.host, tags, this.attributes);
    }

    public Metric tags(List<String> tags) {
        return new Metric(this.set(32L), this.time, this.key, this.value, this.host, new ArrayList<String>(tags), this.attributes);
    }

    public Metric attribute(String k, String v) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.attributes);
        attributes.put(k, v);
        return new Metric(this.set(64L), this.time, this.key, this.value, this.host, this.tags, attributes);
    }

    public Metric attributes(Map<String, String> attributes) {
        return new Metric(this.set(64L), this.time, this.key, this.value, this.host, this.tags, new HashMap<String, String>(attributes));
    }

    public byte[] serialize() {
        Protocol1.Metric.Builder builder = Protocol1.Metric.newBuilder();
        if (this.test(2L)) {
            builder.setTime(this.time);
        }
        if (this.test(4L)) {
            builder.setKey(this.key);
        }
        if (this.test(8L)) {
            if (this.value instanceof Value.DoubleValue) {
                Value.DoubleValue doubleValue = (Value.DoubleValue)this.value;
                builder.setValue(Protocol1.Value.newBuilder().setDoubleValue(doubleValue.getValue()));
            } else if (this.value instanceof Value.DistributionValue) {
                Iterator<Map.Entry<String, String>> distributionValue = (Value.DistributionValue)this.value;
                builder.setValue(Protocol1.Value.newBuilder().setDistributionValue(((Value.DistributionValue)((Object)distributionValue)).getValue()));
            } else {
                throw new IllegalArgumentException("Failed to identify distribution type : [" + this.value + "]");
            }
        }
        if (this.test(16L)) {
            builder.setHost(this.host);
        }
        if (this.test(32L)) {
            for (String tag : this.tags) {
                builder.addTags(tag);
            }
        }
        if (this.test(64L)) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                if (entry.getKey() == null) continue;
                Protocol1.Attribute.Builder attributeBuilder = Protocol1.Attribute.newBuilder().setKey(entry.getKey());
                if (entry.getValue() != null) {
                    attributeBuilder.setValue(entry.getValue());
                }
                builder.addAttributes(attributeBuilder.build());
            }
        }
        Protocol1.Metric m = builder.build();
        return Protocol1.Message.newBuilder().setMetric(m).build().toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.has != other.has) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Value this$value = this.value;
        Value other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$host = this.host;
        String other$host = other.host;
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<String> this$tags = this.tags;
        List<String> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$attributes = this.attributes;
        Map<String, String> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    private boolean canEqual(Object other) {
        return other instanceof com.spotify.ffwd.Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $has = this.has;
        result = result * 59 + (int)($has >>> 32 ^ $has);
        long $time = this.time;
        result = result * 59 + (int)($time >>> 32 ^ $time);
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Value $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $host = this.host;
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public long getTime() {
        return this.time;
    }

    public String getKey() {
        return this.key;
    }

    public Value getValue() {
        return this.value;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

