/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.carbon;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.spotify.ffwd.model.Metric;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

@ChannelHandler.Sharable
public class CarbonDecoder
extends MessageToMessageDecoder<String> {
    private static final Set<String> EMPTY_TAGS = Sets.newHashSet();
    private static final Map<String, String> EMPTY_RESOURCE = ImmutableMap.of();
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private final String key;

    public CarbonDecoder(String key) {
        this.key = key;
    }

    protected void decode(ChannelHandlerContext arg0, String in, List<Object> out) throws Exception {
        long timestamp;
        double value;
        String[] tokens = WHITE_SPACE_PATTERN.split(in);
        if (tokens.length != 3) {
            throw new CorruptedFrameException(String.format("malformed carbon frame (%s)", in));
        }
        try {
            value = Double.valueOf(tokens[1]);
        }
        catch (NumberFormatException e) {
            throw new CorruptedFrameException(String.format("malformed carbon frame (%s), (%s) is an invalid value", in, StringEscapeUtils.escapeJava((String)tokens[1])));
        }
        try {
            timestamp = Long.valueOf(tokens[2]);
        }
        catch (NumberFormatException e) {
            throw new CorruptedFrameException(String.format("malformed carbon frame (%s), (%s) is an invalid timestamp", in, StringEscapeUtils.escapeJava((String)tokens[2])));
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("what", tokens[0]);
        out.add(new Metric(this.key, value, new Date(timestamp), EMPTY_TAGS, tags, EMPTY_RESOURCE, null));
    }
}

