/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.carbon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.spotify.ffwd.carbon.CarbonDecoder;
import com.spotify.ffwd.carbon.CarbonLineServer;
import com.spotify.ffwd.carbon.CarbonPluginSource;
import com.spotify.ffwd.filter.Filter;
import com.spotify.ffwd.input.InputPlugin;
import com.spotify.ffwd.input.PluginSource;
import com.spotify.ffwd.protocol.Protocol;
import com.spotify.ffwd.protocol.ProtocolFactory;
import com.spotify.ffwd.protocol.ProtocolServer;
import com.spotify.ffwd.protocol.ProtocolType;
import com.spotify.ffwd.protocol.RetryPolicy;
import java.util.Optional;

public class CarbonInputPlugin
implements InputPlugin {
    private static final ProtocolType DEFAULT_PROTOCOL = ProtocolType.TCP;
    private static final int DEFAULT_PORT = 20003;
    private static final String FRAME = "frame";
    private static final String LINE = "line";
    private static final String DEFAULT_KEY = "carbon";
    private final Protocol protocol;
    private final Class<? extends ProtocolServer> protocolServer;
    private final RetryPolicy retry;
    private final String metricKey;

    @JsonCreator
    public CarbonInputPlugin(@JsonProperty(value="protocol") ProtocolFactory protocol, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="retry") RetryPolicy retry, @JsonProperty(value="key") String key, @JsonProperty(value="filter") Optional<Filter> filter) {
        this.protocol = Optional.ofNullable(protocol).orElseGet(ProtocolFactory.defaultFor()).protocol(DEFAULT_PROTOCOL, 20003);
        this.protocolServer = this.parseProtocolServer(Optional.ofNullable(delimiter).orElseGet(this::defaultDelimiter));
        this.retry = Optional.ofNullable(retry).orElseGet(RetryPolicy.Exponential::new);
        this.metricKey = Optional.ofNullable(key).orElse(DEFAULT_KEY);
    }

    private String defaultDelimiter() {
        if (this.protocol.getType() == ProtocolType.TCP) {
            return LINE;
        }
        if (this.protocol.getType() == ProtocolType.UDP) {
            throw new IllegalArgumentException("udp protocol is not supported yet");
        }
        return LINE;
    }

    private Class<? extends ProtocolServer> parseProtocolServer(String delimiter) {
        if (FRAME.equals(delimiter)) {
            if (this.protocol.getType() == ProtocolType.TCP) {
                throw new IllegalArgumentException("frame-based decoding is not suitable for TCP");
            }
            throw new IllegalArgumentException("frame-based decoding is not supported yet");
        }
        if (LINE.equals(delimiter)) {
            return CarbonLineServer.class;
        }
        return this.defaultProtocolServer();
    }

    private Class<? extends ProtocolServer> defaultProtocolServer() {
        return CarbonLineServer.class;
    }

    public Module module(final Key<PluginSource> key, String id) {
        return new PrivateModule(){

            protected void configure() {
                this.bind(CarbonDecoder.class).toInstance((Object)new CarbonDecoder(CarbonInputPlugin.this.metricKey));
                this.bind(Protocol.class).toInstance((Object)CarbonInputPlugin.this.protocol);
                this.bind(ProtocolServer.class).to(CarbonInputPlugin.this.protocolServer).in(Scopes.SINGLETON);
                this.bind(RetryPolicy.class).toInstance((Object)CarbonInputPlugin.this.retry);
                this.bind(key).to(CarbonPluginSource.class).in(Scopes.SINGLETON);
                this.expose(key);
            }
        };
    }
}

