/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.carbon;

import com.google.inject.Inject;
import com.spotify.ffwd.input.PluginSource;
import com.spotify.ffwd.protocol.Protocol;
import com.spotify.ffwd.protocol.ProtocolConnection;
import com.spotify.ffwd.protocol.ProtocolServer;
import com.spotify.ffwd.protocol.ProtocolServers;
import com.spotify.ffwd.protocol.RetryPolicy;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.Transform;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarbonPluginSource
implements PluginSource {
    private static final Logger log = LoggerFactory.getLogger(CarbonPluginSource.class);
    @Inject
    private AsyncFramework async;
    @Inject
    private ProtocolServers servers;
    @Inject
    private Protocol protocol;
    @Inject
    private ProtocolServer server;
    @Inject
    private RetryPolicy policy;
    private final AtomicReference<ProtocolConnection> connection = new AtomicReference();

    public void init() {
    }

    public AsyncFuture<Void> start() {
        return this.servers.bind(log, this.protocol, this.server, this.policy).transform((Transform)new Transform<ProtocolConnection, Void>(){

            public Void transform(ProtocolConnection c) throws Exception {
                if (!CarbonPluginSource.this.connection.compareAndSet(null, c)) {
                    c.stop();
                }
                return null;
            }
        });
    }

    public AsyncFuture<Void> stop() {
        ProtocolConnection c = this.connection.getAndSet(null);
        if (c == null) {
            return this.async.resolved(null);
        }
        return c.stop();
    }
}

