/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.EventSource;
import com.spotify.mobius.disposables.Disposable;
import com.spotify.mobius.functions.Consumer;
import com.spotify.mobius.internal_util.Preconditions;
import javax.annotation.Nonnull;
import rx.Emitter;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.plugins.RxJavaHooks;

public final class RxEventSources {
    private RxEventSources() {
    }

    @SafeVarargs
    public static <E> EventSource<E> fromObservables(Observable<E> ... observables) {
        final Observable eventSource = Observable.merge(observables);
        return new EventSource<E>(){

            @Nonnull
            public Disposable subscribe(final Consumer<E> eventConsumer) {
                final Subscription subscription = eventSource.subscribe(new Observer<E>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        RxJavaHooks.onError((Throwable)e);
                    }

                    public void onNext(E e) {
                        eventConsumer.accept(e);
                    }
                });
                return new Disposable(){

                    public void dispose() {
                        subscription.unsubscribe();
                    }
                };
            }
        };
    }

    public static <E> Observable<E> toObservable(final EventSource<E> eventSource, Emitter.BackpressureMode backpressureMode) {
        Preconditions.checkNotNull(eventSource);
        Preconditions.checkNotNull((Object)backpressureMode);
        return Observable.create((Action1)new Action1<Emitter<E>>(){

            public void call(final Emitter<E> emitter) {
                final Disposable disposable = eventSource.subscribe(new Consumer<E>(){

                    public void accept(E value) {
                        emitter.onNext(value);
                    }
                });
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        disposable.dispose();
                    }
                });
            }
        }, (Emitter.BackpressureMode)backpressureMode);
    }
}

