/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.rx.FlatMapCompletable;
import javax.annotation.Nullable;
import rx.Observable;
import rx.Scheduler;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Action1;

class Transformers {
    private Transformers() {
    }

    static <F, E> Observable.Transformer<F, E> fromAction(Action0 doEffect) {
        return Transformers.fromAction(doEffect, null);
    }

    static <F, E> Observable.Transformer<F, E> fromAction(final Action0 doEffect, @Nullable Scheduler scheduler) {
        return Transformers.fromConsumer(new Action1<F>(){

            public void call(F f) {
                try {
                    doEffect.call();
                }
                catch (Exception e) {
                    throw OnErrorThrowable.from((Throwable)e);
                }
            }
        }, scheduler);
    }

    static <F, E> Observable.Transformer<F, E> fromConsumer(Action1<F> doEffect) {
        return Transformers.fromConsumer(doEffect, null);
    }

    static <F, E> Observable.Transformer<F, E> fromConsumer(final Action1<F> doEffect, final @Nullable Scheduler scheduler) {
        return new Observable.Transformer<F, E>(){

            public Observable<E> call(Observable<F> effectStream) {
                return effectStream.compose(FlatMapCompletable.createForAction(doEffect, scheduler));
            }
        };
    }
}

