/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.MobiusLoop;
import com.spotify.mobius.functions.Consumer;
import com.spotify.mobius.rx.UnrecoverableIncomingException;
import rx.Emitter;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Cancellable;

class RxMobiusLoop<E, M>
implements Observable.Transformer<E, M> {
    private final MobiusLoop.Factory<M, E, ?> loopFactory;
    private final M loopStart;

    RxMobiusLoop(MobiusLoop.Factory<M, E, ?> loopFactory, M loopStart) {
        this.loopFactory = loopFactory;
        this.loopStart = loopStart;
    }

    public Observable<M> call(final Observable<E> events) {
        return Observable.create((Action1)new Action1<Emitter<M>>(){

            public void call(final Emitter<M> emitter) {
                final MobiusLoop loop = RxMobiusLoop.this.loopFactory.startFrom(RxMobiusLoop.this.loopStart);
                loop.observe(new Consumer<M>(){

                    public void accept(M newModel) {
                        emitter.onNext(newModel);
                    }
                });
                final Subscription eventSubscription = events.subscribe(new Observer<E>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        emitter.onError((Throwable)new UnrecoverableIncomingException(e));
                    }

                    public void onNext(E event) {
                        loop.dispatchEvent(event);
                    }
                });
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        loop.dispose();
                        eventSubscription.unsubscribe();
                    }
                });
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE);
    }
}

