/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.internal_util.Preconditions;
import javax.annotation.Nullable;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

class FlatMapCompletable<T, R>
implements Observable.Transformer<T, R> {
    private final Func1<T, Completable> func;
    @Nullable
    private final Scheduler scheduler;

    private FlatMapCompletable(Func1<T, Completable> func, @Nullable Scheduler scheduler) {
        this.func = func;
        this.scheduler = scheduler;
    }

    static <T, R> FlatMapCompletable<T, R> createForAction(final Action1<T> action, @Nullable Scheduler scheduler) {
        return FlatMapCompletable.create(new Func1<T, Completable>(){

            public Completable call(final T t) {
                return Completable.fromAction((Action0)new Action0(){

                    public void call() {
                        action.call(t);
                    }
                });
            }
        }, scheduler);
    }

    static <T, R> FlatMapCompletable<T, R> createForAction(Action1<T> action) {
        return FlatMapCompletable.createForAction(action, null);
    }

    static <T, R> FlatMapCompletable<T, R> create(Func1<T, Completable> func) {
        return FlatMapCompletable.create(func, null);
    }

    static <T, R> FlatMapCompletable<T, R> create(Func1<T, Completable> func, @Nullable Scheduler scheduler) {
        return new FlatMapCompletable<T, R>((Func1)Preconditions.checkNotNull(func), scheduler);
    }

    public Observable<R> call(Observable<T> observable) {
        return observable.flatMap(new Func1<T, Observable<R>>(){

            public Observable<R> call(T value) {
                Completable completable = (Completable)FlatMapCompletable.this.func.call(value);
                if (FlatMapCompletable.this.scheduler != null) {
                    completable = completable.subscribeOn(FlatMapCompletable.this.scheduler);
                }
                return completable.toObservable().ignoreElements().map(new Func1<Object, R>(){

                    public R call(Object ignored) {
                        throw new IllegalStateException("Impossible state! ignoreElements() mustn't allow values to be emitted!");
                    }
                });
            }
        });
    }
}

