/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.ConnectionException;
import com.spotify.mobius.Mobius;
import com.spotify.mobius.MobiusLoop;
import com.spotify.mobius.Update;
import com.spotify.mobius.functions.Function;
import com.spotify.mobius.internal_util.Preconditions;
import com.spotify.mobius.rx.MobiusEffectRouter;
import com.spotify.mobius.rx.RxConnectables;
import com.spotify.mobius.rx.RxMobiusLoop;
import com.spotify.mobius.rx.Transformers;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public final class RxMobius {
    private RxMobius() {
    }

    public static <M, E, F> Observable.Transformer<E, M> loopFrom(MobiusLoop.Factory<M, E, F> loopFactory, M startModel) {
        return new RxMobiusLoop<E, M>(loopFactory, startModel);
    }

    public static <M, E, F> MobiusLoop.Builder<M, E, F> loop(Update<M, E, F> update, Observable.Transformer<F, E> effectHandler) {
        return Mobius.loop(update, RxConnectables.fromTransformer(effectHandler));
    }

    public static <F, E> SubtypeEffectHandlerBuilder<F, E> subtypeEffectHandler() {
        return new SubtypeEffectHandlerBuilder();
    }

    public static class SubtypeEffectHandlerBuilder<F, E> {
        private final Map<Class<?>, Observable.Transformer<F, E>> effectPerformerMap = new HashMap();
        private Func1<Observable.Transformer<? extends F, E>, Action1<Throwable>> onErrorFunction = new DefaultOnError();

        private SubtypeEffectHandlerBuilder() {
        }

        @Deprecated
        public <G extends F> SubtypeEffectHandlerBuilder<F, E> add(Class<G> effectClass, Observable.Transformer<G, E> effectHandler) {
            return this.addTransformer(effectClass, effectHandler);
        }

        @Deprecated
        public <G extends F> SubtypeEffectHandlerBuilder<F, E> add(Class<G> effectClass, Action0 action) {
            return this.addAction(effectClass, action);
        }

        @Deprecated
        public <G extends F> SubtypeEffectHandlerBuilder<F, E> add(Class<G> effectClass, Action0 action, Scheduler scheduler) {
            return this.addAction(effectClass, action, scheduler);
        }

        @Deprecated
        public <G extends F> SubtypeEffectHandlerBuilder<F, E> add(Class<G> effectClass, Action1<G> action) {
            return this.addConsumer(effectClass, action);
        }

        @Deprecated
        public <G extends F> SubtypeEffectHandlerBuilder<F, E> add(Class<G> effectClass, Action1<G> action, Scheduler scheduler) {
            return this.addConsumer(effectClass, action, scheduler);
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addFunction(Class<G> effectClass, Function<G, E> function) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull(function);
            return this.addTransformer(effectClass, Transformers.fromFunction(function));
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addFunction(Class<G> effectClass, Function<G, E> function, Scheduler scheduler) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull(function);
            return this.addTransformer(effectClass, Transformers.fromFunction(function, scheduler));
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addTransformer(final Class<G> effectClass, final Observable.Transformer<G, E> effectHandler) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull(effectHandler);
            for (Class<G> clazz : this.effectPerformerMap.keySet()) {
                if (!clazz.isAssignableFrom(effectClass) && !effectClass.isAssignableFrom(clazz)) continue;
                throw new IllegalArgumentException("Effect classes may not be assignable to each other, collision found: " + effectClass.getSimpleName() + " <-> " + clazz.getSimpleName());
            }
            this.effectPerformerMap.put(effectClass, new Observable.Transformer<F, E>(){

                public Observable<E> call(Observable<F> effects) {
                    return effects.ofType(effectClass).compose(effectHandler).doOnError((Action1)onErrorFunction.call((Object)effectHandler));
                }
            });
            return this;
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addAction(Class<G> effectClass, Action0 action) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull((Object)action);
            return this.addTransformer(effectClass, Transformers.fromAction(action));
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addAction(Class<G> effectClass, Action0 action, Scheduler scheduler) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull((Object)action);
            return this.addTransformer(effectClass, Transformers.fromAction(action, scheduler));
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addConsumer(Class<G> effectClass, Action1<G> consumer) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull(consumer);
            return this.addTransformer(effectClass, Transformers.fromConsumer(consumer));
        }

        public <G extends F> SubtypeEffectHandlerBuilder<F, E> addConsumer(Class<G> effectClass, Action1<G> consumer, Scheduler scheduler) {
            Preconditions.checkNotNull(effectClass);
            Preconditions.checkNotNull(consumer);
            return this.addTransformer(effectClass, Transformers.fromConsumer(consumer, scheduler));
        }

        public SubtypeEffectHandlerBuilder<F, E> withFatalErrorHandler(Func1<Observable.Transformer<? extends F, E>, Action1<Throwable>> onErrorFunction) {
            this.onErrorFunction = (Func1)Preconditions.checkNotNull(onErrorFunction);
            return this;
        }

        public Observable.Transformer<F, E> build() {
            return new MobiusEffectRouter<F, E>(this.effectPerformerMap.keySet(), this.effectPerformerMap.values());
        }

        private class DefaultOnError
        implements Func1<Observable.Transformer<? extends F, E>, Action1<Throwable>> {
            private DefaultOnError() {
            }

            public Action1<Throwable> call(final Observable.Transformer<? extends F, E> effectHandler) {
                return new Action1<Throwable>(){

                    public void call(Throwable throwable) {
                        RxJavaHooks.onError((Throwable)new ConnectionException((Object)effectHandler.getClass().toString(), throwable));
                    }
                };
            }
        }
    }
}

