/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.functions.Function;
import com.spotify.mobius.rx.FlatMapCompletable;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import rx.Observable;
import rx.Scheduler;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

class Transformers {
    private Transformers() {
    }

    static <F, E> Observable.Transformer<F, E> fromAction(Action0 doEffect) {
        return Transformers.fromAction(doEffect, null);
    }

    static <F, E> Observable.Transformer<F, E> fromAction(final Action0 doEffect, @Nullable Scheduler scheduler) {
        return Transformers.fromConsumer(new Action1<F>(){

            public void call(F f) {
                try {
                    doEffect.call();
                }
                catch (Exception e) {
                    throw OnErrorThrowable.from((Throwable)e);
                }
            }
        }, scheduler);
    }

    static <F, E> Observable.Transformer<F, E> fromConsumer(Action1<F> doEffect) {
        return Transformers.fromConsumer(doEffect, null);
    }

    static <F, E> Observable.Transformer<F, E> fromConsumer(final Action1<F> doEffect, final @Nullable Scheduler scheduler) {
        return new Observable.Transformer<F, E>(){

            public Observable<E> call(Observable<F> effectStream) {
                return effectStream.compose(FlatMapCompletable.createForAction(doEffect, scheduler));
            }
        };
    }

    static <F, E> Observable.Transformer<F, E> fromFunction(final Function<F, E> function, final @Nullable Scheduler scheduler) {
        return new Observable.Transformer<F, E>(){

            public Observable<E> call(Observable<F> effectStream) {
                return effectStream.flatMap(new Func1<F, Observable<E>>(){

                    public Observable<E> call(final F f) {
                        Observable eventObservable = Observable.fromCallable((Callable)new Callable<E>(){

                            @Override
                            public E call() throws Exception {
                                return function.apply(f);
                            }
                        });
                        return scheduler == null ? eventObservable : eventObservable.subscribeOn(scheduler);
                    }
                });
            }
        };
    }

    static <F, E> Observable.Transformer<F, E> fromFunction(Function<F, E> function) {
        return Transformers.fromFunction(function, null);
    }
}

