/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.rx.MergedTransformer;
import com.spotify.mobius.rx.UnknownEffectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

class MobiusEffectRouter<F, E>
implements Observable.Transformer<F, E> {
    private final MergedTransformer<F, E> mergedTransformer;

    MobiusEffectRouter(Set<Class<?>> handledEffectClasses, Collection<Observable.Transformer<F, E>> effectPerformers) {
        final HashSet effectClasses = new HashSet(handledEffectClasses);
        List<Observable.Transformer<F, E>> immutableEffectPerformers = Collections.unmodifiableList(new ArrayList<Observable.Transformer<F, E>>(effectPerformers));
        Observable.Transformer unhandledEffectHandler = new Observable.Transformer<F, E>(){

            public Observable<E> call(Observable<F> effects) {
                return effects.filter(new Func1<F, Boolean>(){

                    public Boolean call(F e) {
                        for (Class effectClass : effectClasses) {
                            if (!effectClass.isAssignableFrom(e.getClass())) continue;
                            return false;
                        }
                        return true;
                    }
                }).map(new Func1<F, E>(){

                    public E call(F e) {
                        throw new UnknownEffectException(e);
                    }
                });
            }
        };
        ArrayList allHandlers = new ArrayList(immutableEffectPerformers);
        allHandlers.add(unhandledEffectHandler);
        this.mergedTransformer = new MergedTransformer(allHandlers);
    }

    public Observable<E> call(Observable<F> effects) {
        return effects.compose(this.mergedTransformer);
    }
}

